/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.lang;

import com.sun.el.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.FunctionMapper;

public class FunctionMapperImpl
extends FunctionMapper
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected Map<String, Function> functions = null;

    @Override
    public Method resolveFunction(String prefix, String localName) {
        if (this.functions != null) {
            Function f2 = this.functions.get(prefix + ":" + localName);
            return f2.getMethod();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunction(String prefix, String localName, Method m3) {
        if (this.functions == null) {
            this.functions = new HashMap<String, Function>();
        }
        Function f2 = new Function(prefix, localName, m3);
        FunctionMapperImpl functionMapperImpl = this;
        synchronized (functionMapperImpl) {
            this.functions.put(prefix + ":" + localName, f2);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.functions);
    }

    @Override
    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.functions = (Map)in2.readObject();
    }

    public static class Function
    implements Externalizable {
        protected transient Method m;
        protected String owner;
        protected String name;
        protected String[] types;
        protected String prefix;
        protected String localName;

        public Function(String prefix, String localName, Method m3) {
            if (localName == null) {
                throw new NullPointerException("LocalName cannot be null");
            }
            if (m3 == null) {
                throw new NullPointerException("Method cannot be null");
            }
            this.prefix = prefix;
            this.localName = localName;
            this.m = m3;
        }

        public Function() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.prefix != null ? this.prefix : "");
            out.writeUTF(this.localName);
            if (this.owner != null) {
                out.writeUTF(this.owner);
            } else {
                out.writeUTF(this.m.getDeclaringClass().getName());
            }
            if (this.name != null) {
                out.writeUTF(this.name);
            } else {
                out.writeUTF(this.m.getName());
            }
            if (this.types != null) {
                out.writeObject(this.types);
            } else {
                out.writeObject(ReflectionUtil.toTypeNameArray(this.m.getParameterTypes()));
            }
        }

        @Override
        public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
            this.prefix = in2.readUTF();
            if ("".equals(this.prefix)) {
                this.prefix = null;
            }
            this.localName = in2.readUTF();
            this.owner = in2.readUTF();
            this.name = in2.readUTF();
            this.types = (String[])in2.readObject();
        }

        public Method getMethod() {
            if (this.m == null) {
                try {
                    Class<?> t2 = Class.forName(this.owner, false, Thread.currentThread().getContextClassLoader());
                    Class[] p2 = ReflectionUtil.toTypeArray(this.types);
                    this.m = t2.getMethod(this.name, p2);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            return this.m;
        }

        public boolean matches(String prefix, String localName) {
            if (this.prefix != null) {
                if (prefix == null) {
                    return false;
                }
                if (!this.prefix.equals(prefix)) {
                    return false;
                }
            }
            return this.localName.equals(localName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Function) {
                return this.hashCode() == obj.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return (this.prefix + this.localName).hashCode();
        }
    }
}

