/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class IndentedWriter
extends FilterWriter {
    static final String EOL;
    int indent_level = 0;
    boolean at_line_start = true;
    String indentSpacing;

    public IndentedWriter(Writer writer, String string) {
        super(writer);
        this.indentSpacing = string;
    }

    public IndentedWriter(Writer writer) {
        this(writer, "\t");
    }

    private boolean isEol(char c2) {
        return c2 == '\r' || c2 == '\n';
    }

    public void upIndent() {
        ++this.indent_level;
    }

    public void downIndent() {
        --this.indent_level;
    }

    @Override
    public void write(int n2) throws IOException {
        this.out.write(n2);
        this.at_line_start = this.isEol((char)n2);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.out.write(cArray, n2, n3);
        this.at_line_start = this.isEol(cArray[n2 + n3 - 1]);
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        if (n3 > 0) {
            this.out.write(string, n2, n3);
            this.at_line_start = this.isEol(string.charAt(n2 + n3 - 1));
        }
    }

    private void printIndent() throws IOException {
        for (int i2 = 0; i2 < this.indent_level; ++i2) {
            this.out.write(this.indentSpacing);
        }
    }

    public void print(String string) throws IOException {
        if (this.at_line_start) {
            this.printIndent();
        }
        this.out.write(string);
        char c2 = string.charAt(string.length() - 1);
        this.at_line_start = this.isEol(c2);
    }

    public void println(String string) throws IOException {
        if (this.at_line_start) {
            this.printIndent();
        }
        this.out.write(string);
        this.out.write(EOL);
        this.at_line_start = true;
    }

    public void print(boolean bl2) throws IOException {
        this.print(String.valueOf(bl2));
    }

    public void print(byte by2) throws IOException {
        this.print(String.valueOf(by2));
    }

    public void print(char c2) throws IOException {
        this.print(String.valueOf(c2));
    }

    public void print(short s2) throws IOException {
        this.print(String.valueOf(s2));
    }

    public void print(int n2) throws IOException {
        this.print(String.valueOf(n2));
    }

    public void print(long l2) throws IOException {
        this.print(String.valueOf(l2));
    }

    public void print(float f2) throws IOException {
        this.print(String.valueOf(f2));
    }

    public void print(double d2) throws IOException {
        this.print(String.valueOf(d2));
    }

    public void print(Object object) throws IOException {
        this.print(String.valueOf(object));
    }

    public void println(boolean bl2) throws IOException {
        this.println(String.valueOf(bl2));
    }

    public void println(byte by2) throws IOException {
        this.println(String.valueOf(by2));
    }

    public void println(char c2) throws IOException {
        this.println(String.valueOf(c2));
    }

    public void println(short s2) throws IOException {
        this.println(String.valueOf(s2));
    }

    public void println(int n2) throws IOException {
        this.println(String.valueOf(n2));
    }

    public void println(long l2) throws IOException {
        this.println(String.valueOf(l2));
    }

    public void println(float f2) throws IOException {
        this.println(String.valueOf(f2));
    }

    public void println(double d2) throws IOException {
        this.println(String.valueOf(d2));
    }

    public void println(Object object) throws IOException {
        this.println(String.valueOf(object));
    }

    public void println() throws IOException {
        this.println("");
    }

    static {
        String string = System.getProperty("line.separator");
        EOL = string != null ? string : "\r\n";
    }
}

