/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.c3p0.impl.AbstractPoolBackedDataSource;
import com.mchange.v2.naming.ReferenceableUtils;
import com.mchange.v2.ser.SerializableUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;

public final class TestRefSerStuff {
    static String toString(DataSource ds2) {
        if (ds2 instanceof AbstractPoolBackedDataSource) {
            return ((AbstractPoolBackedDataSource)ds2).toString(true);
        }
        return ds2.toString();
    }

    static void create(DataSource ds2) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = ds2.getConnection();
            stmt = con.createStatement();
            stmt.executeUpdate("CREATE TABLE TRSS_TABLE ( a_col VARCHAR(16) )");
        }
        catch (Throwable throwable) {
            StatementUtils.attemptClose(stmt);
            ConnectionUtils.attemptClose(con);
            throw throwable;
        }
        StatementUtils.attemptClose(stmt);
        ConnectionUtils.attemptClose(con);
    }

    static void drop(DataSource ds2) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = ds2.getConnection();
            stmt = con.createStatement();
            stmt.executeUpdate("DROP TABLE TRSS_TABLE");
        }
        catch (Throwable throwable) {
            StatementUtils.attemptClose(stmt);
            ConnectionUtils.attemptClose(con);
            throw throwable;
        }
        StatementUtils.attemptClose(stmt);
        ConnectionUtils.attemptClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doSomething(DataSource ds2) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = ds2.getConnection();
            stmt = con.createStatement();
            int i2 = stmt.executeUpdate("INSERT INTO TRSS_TABLE VALUES ('" + System.currentTimeMillis() + "')");
            if (i2 != 1) {
                throw new SQLException("Insert failed somehow strange!");
            }
        }
        catch (Throwable throwable) {
            StatementUtils.attemptClose(stmt);
            ConnectionUtils.attemptClose(con);
            throw throwable;
        }
        StatementUtils.attemptClose(stmt);
        ConnectionUtils.attemptClose(con);
    }

    static void doTest(DataSource checkMe) throws Exception {
        TestRefSerStuff.doSomething(checkMe);
        System.err.println("\tcreated:   " + TestRefSerStuff.toString(checkMe));
        DataSource afterSer = (DataSource)SerializableUtils.testSerializeDeserialize(checkMe);
        TestRefSerStuff.doSomething(afterSer);
        System.err.println("\tafter ser: " + TestRefSerStuff.toString(afterSer));
        Reference ref = ((Referenceable)((Object)checkMe)).getReference();
        DataSource afterRef = (DataSource)ReferenceableUtils.referenceToObject(ref, null, null, null);
        TestRefSerStuff.doSomething(afterRef);
        System.err.println("\tafter ref: " + TestRefSerStuff.toString(afterRef));
    }

    public static void main(String[] argv) {
        if (argv.length > 0) {
            System.err.println(TestRefSerStuff.class.getName() + " now requires no args. Please set everything in standard c3p0 config files.");
            return;
        }
        try {
            DriverManagerDataSource dmds = new DriverManagerDataSource();
            try {
                TestRefSerStuff.drop(dmds);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TestRefSerStuff.create(dmds);
            System.err.println("DriverManagerDataSource:");
            TestRefSerStuff.doTest(dmds);
            WrapperConnectionPoolDataSource wcpds = new WrapperConnectionPoolDataSource();
            wcpds.setNestedDataSource(dmds);
            PoolBackedDataSource pbds = new PoolBackedDataSource();
            pbds.setConnectionPoolDataSource(wcpds);
            System.err.println("PoolBackedDataSource:");
            TestRefSerStuff.doTest(pbds);
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            TestRefSerStuff.doTest(cpds);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

