/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.C3P0ProxyConnection;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.NewProxyCallableStatement;
import com.mchange.v2.c3p0.impl.NewProxyDatabaseMetaData;
import com.mchange.v2.c3p0.impl.NewProxyPreparedStatement;
import com.mchange.v2.c3p0.impl.NewProxyResultSet;
import com.mchange.v2.c3p0.impl.NewProxyStatement;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.util.ResourceClosedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

public final class NewProxyConnection
implements Connection,
C3P0ProxyConnection {
    protected Connection inner;
    boolean txn_known_resolved = true;
    DatabaseMetaData metaData = null;
    private static final MLogger logger = MLog.getLogger("com.mchange.v2.c3p0.impl.NewProxyConnection");
    volatile NewPooledConnection parentPooledConnection;
    ConnectionEventListener cel = new ConnectionEventListener(){

        @Override
        public void connectionErrorOccurred(ConnectionEvent evt) {
        }

        @Override
        public void connectionClosed(ConnectionEvent evt) {
            NewProxyConnection.this.detach();
        }
    };

    private void __setInner(Connection inner) {
        this.inner = inner;
    }

    NewProxyConnection(Connection inner) {
        this.__setInner(inner);
    }

    @Override
    public synchronized void setReadOnly(boolean a2) throws SQLException {
        try {
            this.inner.setReadOnly(a2);
            this.parentPooledConnection.markNewReadOnly(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            if (!this.isDetached()) {
                NewPooledConnection npc = this.parentPooledConnection;
                this.detach();
                npc.markClosedProxyConnection(this, this.txn_known_resolved);
                this.inner = null;
            } else if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, this + ": close() called more than once.");
            }
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, this + ": close() called more than once.");
                }
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.isReadOnly();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Statement createStatement(int a2, int b2, int c2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            Statement innerStmt = this.inner.createStatement(a2, b2, c2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        try {
            this.txn_known_resolved = false;
            Statement innerStmt = this.inner.createStatement();
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Statement createStatement(int a2, int b2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            Statement innerStmt = this.inner.createStatement(a2, b2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String a2, int b2, int c2, int d2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.parentPooledConnection.isStatementCaching()) {
                try {
                    Class[] argTypes = new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
                    Method method = Connection.class.getMethod("prepareStatement", argTypes);
                    Object[] args2 = new Object[]{a2, new Integer(b2), new Integer(c2), new Integer(d2)};
                    PreparedStatement innerStmt = (PreparedStatement)this.parentPooledConnection.checkoutStatement(method, args2);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, true, this);
                }
                catch (ResourceClosedException e2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "A Connection tried to prepare a Statement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.", e2);
                    }
                    PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2, c2, d2);
                    this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
                }
            }
            PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2, c2, d2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String a2, int b2, int c2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.parentPooledConnection.isStatementCaching()) {
                try {
                    Class[] argTypes = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
                    Method method = Connection.class.getMethod("prepareStatement", argTypes);
                    Object[] args2 = new Object[]{a2, new Integer(b2), new Integer(c2)};
                    PreparedStatement innerStmt = (PreparedStatement)this.parentPooledConnection.checkoutStatement(method, args2);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, true, this);
                }
                catch (ResourceClosedException e2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "A Connection tried to prepare a Statement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.", e2);
                    }
                    PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2, c2);
                    this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
                }
            }
            PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2, c2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String a2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.parentPooledConnection.isStatementCaching()) {
                try {
                    Class[] argTypes = new Class[]{String.class};
                    Method method = Connection.class.getMethod("prepareStatement", argTypes);
                    Object[] args2 = new Object[]{a2};
                    PreparedStatement innerStmt = (PreparedStatement)this.parentPooledConnection.checkoutStatement(method, args2);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, true, this);
                }
                catch (ResourceClosedException e2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "A Connection tried to prepare a Statement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.", e2);
                    }
                    PreparedStatement innerStmt = this.inner.prepareStatement(a2);
                    this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
                }
            }
            PreparedStatement innerStmt = this.inner.prepareStatement(a2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String a2, int[] b2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.parentPooledConnection.isStatementCaching()) {
                try {
                    Class[] argTypes = new Class[]{String.class, int[].class};
                    Method method = Connection.class.getMethod("prepareStatement", argTypes);
                    Object[] args2 = new Object[]{a2, b2};
                    PreparedStatement innerStmt = (PreparedStatement)this.parentPooledConnection.checkoutStatement(method, args2);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, true, this);
                }
                catch (ResourceClosedException e2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "A Connection tried to prepare a Statement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.", e2);
                    }
                    PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2);
                    this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
                }
            }
            PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String a2, int b2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.parentPooledConnection.isStatementCaching()) {
                try {
                    Class[] argTypes = new Class[]{String.class, Integer.TYPE};
                    Method method = Connection.class.getMethod("prepareStatement", argTypes);
                    Object[] args2 = new Object[]{a2, new Integer(b2)};
                    PreparedStatement innerStmt = (PreparedStatement)this.parentPooledConnection.checkoutStatement(method, args2);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, true, this);
                }
                catch (ResourceClosedException e2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "A Connection tried to prepare a Statement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.", e2);
                    }
                    PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2);
                    this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
                }
            }
            PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String a2, String[] b2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.parentPooledConnection.isStatementCaching()) {
                try {
                    Class[] argTypes = new Class[]{String.class, String[].class};
                    Method method = Connection.class.getMethod("prepareStatement", argTypes);
                    Object[] args2 = new Object[]{a2, b2};
                    PreparedStatement innerStmt = (PreparedStatement)this.parentPooledConnection.checkoutStatement(method, args2);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, true, this);
                }
                catch (ResourceClosedException e2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "A Connection tried to prepare a Statement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.", e2);
                    }
                    PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2);
                    this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
                    return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
                }
            }
            PreparedStatement innerStmt = this.inner.prepareStatement(a2, b2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String a2, int b2, int c2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.parentPooledConnection.isStatementCaching()) {
                try {
                    Class[] argTypes = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
                    Method method = Connection.class.getMethod("prepareCall", argTypes);
                    Object[] args2 = new Object[]{a2, new Integer(b2), new Integer(c2)};
                    CallableStatement innerStmt = (CallableStatement)this.parentPooledConnection.checkoutStatement(method, args2);
                    return new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, true, this);
                }
                catch (ResourceClosedException e2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "A Connection tried to prepare a CallableStatement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.", e2);
                    }
                    CallableStatement innerStmt = this.inner.prepareCall(a2, b2, c2);
                    this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
                    return new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, false, this);
                }
            }
            CallableStatement innerStmt = this.inner.prepareCall(a2, b2, c2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String a2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.parentPooledConnection.isStatementCaching()) {
                try {
                    Class[] argTypes = new Class[]{String.class};
                    Method method = Connection.class.getMethod("prepareCall", argTypes);
                    Object[] args2 = new Object[]{a2};
                    CallableStatement innerStmt = (CallableStatement)this.parentPooledConnection.checkoutStatement(method, args2);
                    return new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, true, this);
                }
                catch (ResourceClosedException e2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "A Connection tried to prepare a CallableStatement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.", e2);
                    }
                    CallableStatement innerStmt = this.inner.prepareCall(a2);
                    this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
                    return new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, false, this);
                }
            }
            CallableStatement innerStmt = this.inner.prepareCall(a2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String a2, int b2, int c2, int d2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.parentPooledConnection.isStatementCaching()) {
                try {
                    Class[] argTypes = new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
                    Method method = Connection.class.getMethod("prepareCall", argTypes);
                    Object[] args2 = new Object[]{a2, new Integer(b2), new Integer(c2), new Integer(d2)};
                    CallableStatement innerStmt = (CallableStatement)this.parentPooledConnection.checkoutStatement(method, args2);
                    return new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, true, this);
                }
                catch (ResourceClosedException e2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "A Connection tried to prepare a CallableStatement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.", e2);
                    }
                    CallableStatement innerStmt = this.inner.prepareCall(a2, b2, c2, d2);
                    this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
                    return new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, false, this);
                }
            }
            CallableStatement innerStmt = this.inner.prepareCall(a2, b2, c2, d2);
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            return new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, false, this);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.txn_known_resolved = false;
            if (this.metaData == null) {
                DatabaseMetaData innerMetaData = this.inner.getMetaData();
                this.metaData = new NewProxyDatabaseMetaData(innerMetaData, this.parentPooledConnection, this);
            }
            return this.metaData;
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int a2) throws SQLException {
        try {
            this.inner.setTransactionIsolation(a2);
            this.parentPooledConnection.markNewTxnIsolation(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void setCatalog(String a2) throws SQLException {
        try {
            this.inner.setCatalog(a2);
            this.parentPooledConnection.markNewCatalog(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void setHoldability(int a2) throws SQLException {
        try {
            this.inner.setHoldability(a2);
            this.parentPooledConnection.markNewHoldability(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    public synchronized void setTypeMap(Map a2) throws SQLException {
        try {
            this.inner.setTypeMap(a2);
            this.parentPooledConnection.markNewTypeMap(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        try {
            return this.inner.getWarnings();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        try {
            this.inner.clearWarnings();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        try {
            return this.isDetached();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        try {
            this.inner.commit();
            this.txn_known_resolved = true;
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void rollback(Savepoint a2) throws SQLException {
        try {
            this.inner.rollback(a2);
            this.txn_known_resolved = true;
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        try {
            this.inner.rollback();
            this.txn_known_resolved = true;
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void setAutoCommit(boolean a2) throws SQLException {
        try {
            this.inner.setAutoCommit(a2);
            this.txn_known_resolved = true;
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void setClientInfo(String a2, String b2) throws SQLClientInfoException {
        try {
            try {
                this.txn_known_resolved = false;
                this.inner.setClientInfo(a2, b2);
            }
            catch (NullPointerException exc) {
                if (this.isDetached()) {
                    throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
                }
                throw exc;
            }
            catch (Exception exc) {
                if (!this.isDetached()) {
                    throw this.parentPooledConnection.handleThrowable(exc);
                }
                throw SqlUtils.toSQLException(exc);
            }
        }
        catch (Exception e2) {
            throw SqlUtils.toSQLClientInfoException(e2);
        }
    }

    @Override
    public synchronized void setClientInfo(Properties a2) throws SQLClientInfoException {
        try {
            try {
                this.txn_known_resolved = false;
                this.inner.setClientInfo(a2);
            }
            catch (NullPointerException exc) {
                if (this.isDetached()) {
                    throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
                }
                throw exc;
            }
            catch (Exception exc) {
                if (!this.isDetached()) {
                    throw this.parentPooledConnection.handleThrowable(exc);
                }
                throw SqlUtils.toSQLException(exc);
            }
        }
        catch (Exception e2) {
            throw SqlUtils.toSQLClientInfoException(e2);
        }
    }

    @Override
    public synchronized boolean isValid(int a2) throws SQLException {
        try {
            if (this.isDetached()) {
                return false;
            }
            return this.inner.isValid(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void abort(Executor a2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            this.inner.abort(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized String nativeSQL(String a2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.nativeSQL(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.getAutoCommit();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.getCatalog();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.getTransactionIsolation();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    public synchronized Map getTypeMap() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.getTypeMap();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.getHoldability();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Savepoint setSavepoint(String a2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.setSavepoint(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.setSavepoint();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint a2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            this.inner.releaseSavepoint(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Clob createClob() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.createClob();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Blob createBlob() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.createBlob();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized NClob createNClob() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.createNClob();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized SQLXML createSQLXML() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.createSQLXML();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Properties getClientInfo() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.getClientInfo();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized String getClientInfo(String a2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.getClientInfo(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Array createArrayOf(String a2, Object[] b2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.createArrayOf(a2, b2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized Struct createStruct(String a2, Object[] b2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.createStruct(a2, b2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void setSchema(String a2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            this.inner.setSchema(a2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized String getSchema() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.getSchema();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized void setNetworkTimeout(Executor a2, int b2) throws SQLException {
        try {
            this.txn_known_resolved = false;
            this.inner.setNetworkTimeout(a2, b2);
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    @Override
    public synchronized int getNetworkTimeout() throws SQLException {
        try {
            this.txn_known_resolved = false;
            return this.inner.getNetworkTimeout();
        }
        catch (NullPointerException exc) {
            if (this.isDetached()) {
                throw SqlUtils.toSQLException("You can't operate on a closed Connection!!!", exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            if (!this.isDetached()) {
                throw this.parentPooledConnection.handleThrowable(exc);
            }
            throw SqlUtils.toSQLException(exc);
        }
    }

    public synchronized Object unwrap(Class a2) throws SQLException {
        if (this.isWrapperForInner(a2)) {
            return this.inner.unwrap(a2);
        }
        if (this.isWrapperForThis(a2)) {
            return this;
        }
        throw new SQLException(this + " is not a wrapper for or implementation of " + a2.getName());
    }

    public synchronized boolean isWrapperFor(Class a2) throws SQLException {
        return this.isWrapperForInner(a2) || this.isWrapperForThis(a2);
    }

    @Override
    public Object rawConnectionOperation(Method m3, Object target, Object[] args2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        this.maybeDirtyTransaction();
        if (this.inner == null) {
            throw new SQLException("You cannot operate on a closed Connection!");
        }
        if (target == C3P0ProxyConnection.RAW_CONNECTION) {
            target = this.inner;
        }
        int len = args2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (args2[i2] != C3P0ProxyConnection.RAW_CONNECTION) continue;
            args2[i2] = this.inner;
        }
        Object out = m3.invoke(target, args2);
        if (out instanceof CallableStatement) {
            CallableStatement innerStmt = (CallableStatement)out;
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            out = new NewProxyCallableStatement(innerStmt, this.parentPooledConnection, false, this);
        } else if (out instanceof PreparedStatement) {
            PreparedStatement innerStmt = (PreparedStatement)out;
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            out = new NewProxyPreparedStatement(innerStmt, this.parentPooledConnection, false, this);
        } else if (out instanceof Statement) {
            Statement innerStmt = (Statement)out;
            this.parentPooledConnection.markActiveUncachedStatement(innerStmt);
            out = new NewProxyStatement(innerStmt, this.parentPooledConnection, false, this);
        } else if (out instanceof ResultSet) {
            ResultSet innerRs = (ResultSet)out;
            this.parentPooledConnection.markActiveRawConnectionResultSet(innerRs);
            out = new NewProxyResultSet(innerRs, this.parentPooledConnection, this.inner, this);
        } else if (out instanceof DatabaseMetaData) {
            out = new NewProxyDatabaseMetaData((DatabaseMetaData)out, this.parentPooledConnection);
        }
        return out;
    }

    synchronized void maybeDirtyTransaction() {
        this.txn_known_resolved = false;
    }

    void attach(NewPooledConnection parentPooledConnection) {
        this.parentPooledConnection = parentPooledConnection;
        parentPooledConnection.addConnectionEventListener(this.cel);
    }

    private void detach() {
        this.parentPooledConnection.removeConnectionEventListener(this.cel);
        this.parentPooledConnection = null;
    }

    NewProxyConnection(Connection inner, NewPooledConnection parentPooledConnection) {
        this(inner);
        this.attach(parentPooledConnection);
    }

    boolean isDetached() {
        return this.parentPooledConnection == null;
    }

    public String toString() {
        return super.toString() + " [wrapping: " + this.inner + "]";
    }

    private boolean isWrapperForInner(Class intfcl) {
        return Connection.class == intfcl || intfcl.isAssignableFrom(this.inner.getClass());
    }

    private boolean isWrapperForThis(Class intfcl) {
        return intfcl.isAssignableFrom(this.getClass());
    }
}

