/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.AbstractConnectionTester;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.ThreadLocalQuerylessTestRunner;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class DefaultConnectionTester
extends AbstractConnectionTester {
    private static final String PROP_KEY = "com.mchange.v2.c3p0.impl.DefaultConnectionTester.querylessTestRunner";
    private static final String IS_VALID_TIMEOUT_KEY = "com.mchange.v2.c3p0.impl.DefaultConnectionTester.isValidTimeout";
    static final MLogger logger;
    static final int IS_VALID_TIMEOUT;
    static final String CONNECTION_TESTING_URL = "http://www.mchange.com/projects/c3p0/#configuring_connection_testing";
    static final int HASH_CODE;
    static final Set INVALID_DB_STATES;
    static final QuerylessTestRunner METADATA_TABLESEARCH;
    static final QuerylessTestRunner IS_VALID;
    static final QuerylessTestRunner SWITCH;
    static final QuerylessTestRunner THREAD_LOCAL;
    private final QuerylessTestRunner querylessTestRunner;

    public static boolean probableInvalidDb(SQLException sqle) {
        return INVALID_DB_STATES.contains(sqle.getSQLState());
    }

    private static QuerylessTestRunner reflectTestRunner(String propval) {
        try {
            if (propval.indexOf(46) >= 0) {
                return (QuerylessTestRunner)Class.forName(propval).newInstance();
            }
            Field staticField = DefaultConnectionTester.class.getDeclaredField(propval);
            return (QuerylessTestRunner)staticField.get(null);
        }
        catch (Exception e2) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Specified QuerylessTestRunner '" + propval + "' could not be found or instantiated. Reverting to default 'SWITCH'", e2);
            }
            return null;
        }
    }

    public DefaultConnectionTester() {
        QuerylessTestRunner reflected;
        QuerylessTestRunner defaultQuerylessTestRunner = SWITCH;
        String prop = C3P0Config.getMultiPropertiesConfig().getProperty(PROP_KEY);
        this.querylessTestRunner = prop == null ? defaultQuerylessTestRunner : ((reflected = DefaultConnectionTester.reflectTestRunner(prop.trim())) != null ? reflected : defaultQuerylessTestRunner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int activeCheckConnection(Connection c2, String query, Throwable[] rootCauseOutParamHolder) {
        int n2;
        if (query == null) {
            return this.querylessTestRunner.activeCheckConnectionNoQuery(c2, rootCauseOutParamHolder);
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c2.createStatement();
            rs = stmt.executeQuery(query);
            n2 = 0;
        }
        catch (SQLException e2) {
            block13: {
                String state;
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Connection " + c2 + " failed Connection test with an Exception! [query=" + query + "]", e2);
                }
                if (rootCauseOutParamHolder != null) {
                    rootCauseOutParamHolder[0] = e2;
                }
                if (!INVALID_DB_STATES.contains(state = e2.getSQLState())) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception which occurred during a Connection test (test with query '" + query + "') implies that the database is invalid, and the pool should refill itself with fresh Connections.", e2);
                }
                int n3 = -8;
                ResultSetUtils.attemptClose(rs);
                StatementUtils.attemptClose(stmt);
                return n3;
            }
            int n4 = -1;
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose(stmt);
            return n4;
        }
        catch (Exception e3) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + c2 + " failed Connection test with an Exception!", e3);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = e3;
            }
            int n5 = -1;
            {
                catch (Throwable throwable) {
                    ResultSetUtils.attemptClose(rs);
                    StatementUtils.attemptClose(stmt);
                    throw throwable;
                }
            }
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose(stmt);
            return n5;
        }
        ResultSetUtils.attemptClose(rs);
        StatementUtils.attemptClose(stmt);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int statusOnException(Connection c2, Throwable t2, String query, Throwable[] rootCauseOutParamHolder) {
        block12: {
            block13: {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Testing a Connection in response to an Exception:", t2);
                }
                if (!(t2 instanceof SQLException)) break block12;
                String state = ((SQLException)t2).getSQLState();
                if (!INVALID_DB_STATES.contains(state)) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception tested by statusOnException() implies that the database is invalid, and the pool should refill itself with fresh Connections.", t2);
                }
                int n2 = -8;
                return n2;
            }
            int n3 = this.activeCheckConnection(c2, query, rootCauseOutParamHolder);
            return n3;
        }
        try {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection test failed because test-provoking Throwable is an unexpected, non-SQLException.", t2);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = t2;
            }
            int state = -1;
            return state;
        }
        catch (Exception e2) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + c2 + " failed Connection test with an Exception!", e2);
            }
            if (rootCauseOutParamHolder != null) {
                rootCauseOutParamHolder[0] = e2;
            }
            int n4 = -1;
            return n4;
        }
    }

    private static String queryInfo(String query) {
        return query == null ? "[using Connection.isValid(...) if supported, or else traditional default query]" : "[query=" + query + "]";
    }

    @Override
    public boolean equals(Object o2) {
        return o2 != null && o2.getClass() == DefaultConnectionTester.class;
    }

    @Override
    public int hashCode() {
        return HASH_CODE;
    }

    static {
        int isValidTimeout;
        block6: {
            logger = MLog.getLogger(DefaultConnectionTester.class);
            HASH_CODE = DefaultConnectionTester.class.getName().hashCode();
            METADATA_TABLESEARCH = new QuerylessTestRunner(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public int activeCheckConnectionNoQuery(Connection c2, Throwable[] rootCauseOutParamHolder) {
                    int n2;
                    ResultSet rs = null;
                    try {
                        rs = c2.getMetaData().getTables(null, null, "PROBABLYNOT", new String[]{"TABLE"});
                        n2 = 0;
                    }
                    catch (SQLException e2) {
                        block12: {
                            String state;
                            if (logger.isLoggable(MLevel.FINE)) {
                                logger.log(MLevel.FINE, "Connection " + c2 + " failed default system-table Connection test with an Exception!", e2);
                            }
                            if (rootCauseOutParamHolder != null) {
                                rootCauseOutParamHolder[0] = e2;
                            }
                            if (!INVALID_DB_STATES.contains(state = e2.getSQLState())) break block12;
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception which occurred during a Connection test (fallback DatabaseMetaData test) implies that the database is invalid, and the pool should refill itself with fresh Connections.", e2);
                            }
                            int n3 = -8;
                            ResultSetUtils.attemptClose(rs);
                            return n3;
                        }
                        int n4 = -1;
                        ResultSetUtils.attemptClose(rs);
                        return n4;
                    }
                    catch (Exception e3) {
                        if (logger.isLoggable(MLevel.FINE)) {
                            logger.log(MLevel.FINE, "Connection " + c2 + " failed default system-table Connection test with an Exception!", e3);
                        }
                        if (rootCauseOutParamHolder != null) {
                            rootCauseOutParamHolder[0] = e3;
                        }
                        int n5 = -1;
                        {
                            catch (Throwable throwable) {
                                ResultSetUtils.attemptClose(rs);
                                throw throwable;
                            }
                        }
                        ResultSetUtils.attemptClose(rs);
                        return n5;
                    }
                    ResultSetUtils.attemptClose(rs);
                    return n2;
                }
            };
            IS_VALID = new QuerylessTestRunner(){

                @Override
                public int activeCheckConnectionNoQuery(Connection c2, Throwable[] rootCauseOutParamHolder) {
                    try {
                        boolean okay = c2.isValid(IS_VALID_TIMEOUT);
                        if (okay) {
                            return 0;
                        }
                        if (rootCauseOutParamHolder != null) {
                            rootCauseOutParamHolder[0] = new SQLException("Connection.isValid(" + IS_VALID_TIMEOUT + ") returned false.");
                        }
                        return -1;
                    }
                    catch (SQLException e2) {
                        String state;
                        if (rootCauseOutParamHolder != null) {
                            rootCauseOutParamHolder[0] = e2;
                        }
                        if (INVALID_DB_STATES.contains(state = e2.getSQLState())) {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "SQL State '" + state + "' of Exception which occurred during a Connection test (fallback DatabaseMetaData test) implies that the database is invalid, and the pool should refill itself with fresh Connections.", e2);
                            }
                            return -8;
                        }
                        return -1;
                    }
                    catch (Exception e3) {
                        if (rootCauseOutParamHolder != null) {
                            rootCauseOutParamHolder[0] = e3;
                        }
                        return -1;
                    }
                }
            };
            SWITCH = new QuerylessTestRunner(){

                @Override
                public int activeCheckConnectionNoQuery(Connection c2, Throwable[] rootCauseOutParamHolder) {
                    int out;
                    try {
                        out = IS_VALID.activeCheckConnectionNoQuery(c2, rootCauseOutParamHolder);
                    }
                    catch (AbstractMethodError e2) {
                        out = METADATA_TABLESEARCH.activeCheckConnectionNoQuery(c2, rootCauseOutParamHolder);
                    }
                    return out;
                }
            };
            THREAD_LOCAL = new ThreadLocalQuerylessTestRunner();
            HashSet<String> temp = new HashSet<String>();
            temp.add("08001");
            temp.add("08007");
            INVALID_DB_STATES = Collections.unmodifiableSet(temp);
            isValidTimeout = -1;
            String timeoutStr = C3P0Config.getMultiPropertiesConfig().getProperty(IS_VALID_TIMEOUT_KEY);
            try {
                if (timeoutStr != null) {
                    isValidTimeout = Integer.parseInt(timeoutStr);
                }
            }
            catch (NumberFormatException e2) {
                if (!logger.isLoggable(MLevel.WARNING)) break block6;
                logger.log(MLevel.WARNING, "Could not parse value set for com.mchange.v2.c3p0.impl.DefaultConnectionTester.isValidTimeout ['" + timeoutStr + "'] into int.", e2);
            }
        }
        if (isValidTimeout <= 0) {
            isValidTimeout = 0;
        } else if (logger.isLoggable(MLevel.INFO)) {
            logger.log(MLevel.INFO, "Connection.isValid(...) based Connection tests will timeout and fail after " + isValidTimeout + " seconds.");
        }
        IS_VALID_TIMEOUT = isValidTimeout;
    }

    public static interface QuerylessTestRunner
    extends Serializable {
        public int activeCheckConnectionNoQuery(Connection var1, Throwable[] var2);
    }
}

