/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.codegen;

import com.mchange.v2.c3p0.C3P0ProxyConnection;
import com.mchange.v2.c3p0.C3P0ProxyStatement;
import com.mchange.v2.c3p0.impl.ProxyResultSetDetachable;
import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.intfc.DelegatorGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public abstract class JdbcProxyGenerator
extends DelegatorGenerator {
    private static final boolean PREMATURE_DETACH_DEBUG = false;

    JdbcProxyGenerator() {
        this.setGenerateInnerSetter(false);
        this.setGenerateInnerGetter(false);
        this.setGenerateNoArgConstructor(false);
        this.setGenerateWrappingConstructor(true);
        this.setClassModifiers(17);
        this.setMethodModifiers(17);
        this.setWrappingConstructorModifiers(0);
    }

    abstract String getInnerTypeName();

    @Override
    protected void generateDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
        super.generateDelegateCode(intfcl, genclass, method, iw2);
    }

    @Override
    protected void generatePreDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
        if (!JdbcProxyGenerator.jdbc4WrapperMethod(method.getName())) {
            this.generateTryOpener(iw2);
        }
    }

    @Override
    protected void generatePostDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
        if (!JdbcProxyGenerator.jdbc4WrapperMethod(method.getName())) {
            this.generateTryCloserAndCatch(intfcl, genclass, method, iw2);
        }
    }

    void generateTryOpener(IndentedWriter iw2) throws IOException {
        iw2.println("try");
        iw2.println("{");
        iw2.upIndent();
    }

    void generateTryCloserAndCatch(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
        iw2.downIndent();
        iw2.println("}");
        iw2.println("catch (NullPointerException exc)");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("if ( this.isDetached() )");
        iw2.println("{");
        iw2.upIndent();
        if ("close".equals(method.getName())) {
            iw2.println("if (Debug.DEBUG && logger.isLoggable( MLevel.FINE ))");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("logger.log( MLevel.FINE, this + \": close() called more than once.\" );");
            iw2.downIndent();
            iw2.println("}");
        } else {
            iw2.println("throw SqlUtils.toSQLException(\"You can't operate on a closed " + this.getInnerTypeName() + "!!!\", exc);");
        }
        iw2.downIndent();
        iw2.println("}");
        iw2.println("else throw exc;");
        iw2.downIndent();
        iw2.println("}");
        iw2.println("catch (Exception exc)");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("if (! this.isDetached())");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("throw parentPooledConnection.handleThrowable( exc );");
        iw2.downIndent();
        iw2.println("}");
        iw2.println("else throw SqlUtils.toSQLException( exc );");
        iw2.downIndent();
        iw2.println("}");
    }

    @Override
    protected void generateExtraDeclarations(Class intfcl, String genclass, IndentedWriter iw2) throws IOException {
        iw2.println("private final static MLogger logger = MLog.getLogger( \"" + genclass + "\" );");
        iw2.println();
        iw2.println("volatile NewPooledConnection parentPooledConnection;");
        iw2.println();
        iw2.println("ConnectionEventListener cel = new ConnectionEventListener()");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("public void connectionErrorOccurred(ConnectionEvent evt)");
        iw2.println("{ /* DON'T detach()... IGNORE -- this could be an ordinary error. Leave it to the PooledConnection to test, but leave proxies intact */ }");
        iw2.println();
        iw2.println("public void connectionClosed(ConnectionEvent evt)");
        iw2.println("{ detach(); }");
        iw2.downIndent();
        iw2.println("};");
        iw2.println();
        iw2.println("void attach( NewPooledConnection parentPooledConnection )");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("this.parentPooledConnection = parentPooledConnection;");
        iw2.println("parentPooledConnection.addConnectionEventListener( cel );");
        iw2.downIndent();
        iw2.println("}");
        iw2.println();
        iw2.println("private void detach()");
        iw2.println("{");
        iw2.upIndent();
        this.writeDetachBody(iw2);
        iw2.downIndent();
        iw2.println("}");
        iw2.println();
        iw2.print(CodegenUtils.fqcnLastElement(genclass));
        iw2.println("( " + CodegenUtils.simpleClassName(intfcl) + " inner, NewPooledConnection parentPooledConnection )");
        iw2.println("{");
        iw2.upIndent();
        iw2.println("this( inner );");
        iw2.println("attach( parentPooledConnection );");
        this.generateExtraConstructorCode(intfcl, genclass, iw2);
        iw2.downIndent();
        iw2.println("}");
        iw2.println();
        iw2.println("boolean isDetached()");
        iw2.println("{ return (this.parentPooledConnection == null); }");
        iw2.println();
        iw2.println("public String toString() { return super.toString() + \" [wrapping: \" + inner + \"]\"; }");
        iw2.println();
        JdbcProxyGenerator.generateIsWrapperHelperMethods(intfcl, iw2);
    }

    protected void writeDetachBody(IndentedWriter iw2) throws IOException {
        iw2.println("parentPooledConnection.removeConnectionEventListener( cel );");
        iw2.println("parentPooledConnection = null;");
    }

    @Override
    protected void generateExtraImports(IndentedWriter iw2) throws IOException {
        iw2.println("import java.sql.*;");
        iw2.println("import javax.sql.*;");
        iw2.println("import com.mchange.v2.log.*;");
        iw2.println("import java.lang.reflect.Method;");
        iw2.println("import com.mchange.v2.sql.SqlUtils;");
    }

    void generateExtraConstructorCode(Class intfcl, String genclass, IndentedWriter iw2) throws IOException {
    }

    private static void generateIsWrapperHelperMethods(Class intfcl, IndentedWriter iw2) throws IOException {
        iw2.println("// helper methods for unwrap( ... ), isWrapperFor( ... )");
        iw2.println("private boolean isWrapperForInner( Class intfcl )");
        iw2.println("{ return ( " + intfcl.getName() + ".class == intfcl || intfcl.isAssignableFrom( inner.getClass() ) ); }");
        iw2.println();
        iw2.println("private boolean isWrapperForThis( Class intfcl )");
        iw2.println("{ return intfcl.isAssignableFrom( this.getClass() ); }");
    }

    private static void generateWrapperDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
        String mname = method.getName();
        if ("isWrapperFor".equals(mname)) {
            iw2.println("return ( isWrapperForInner( a ) || isWrapperForThis( a ) );");
        } else if ("unwrap".equals(mname)) {
            iw2.println("if (this.isWrapperForInner( a )) return inner.unwrap( a );");
            iw2.println("if (this.isWrapperForThis( a )) return this;");
            iw2.println("else throw new SQLException( this + \" is not a wrapper for or implementation of \" + a.getName());");
        }
    }

    private static boolean jdbc4WrapperMethod(String mname) {
        return "unwrap".equals(mname) || "isWrapperFor".equals(mname);
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 1) {
                System.err.println("java " + JdbcProxyGenerator.class.getName() + " <source-root-directory>");
                return;
            }
            File srcroot = new File(argv[0]);
            if (!srcroot.exists() || !srcroot.canWrite()) {
                System.err.println(JdbcProxyGenerator.class.getName() + " -- sourceroot: " + argv[0] + " must exist and be writable");
                return;
            }
            NewProxyMetaDataGenerator mdgen = new NewProxyMetaDataGenerator();
            NewProxyResultSetGenerator rsgen = new NewProxyResultSetGenerator();
            NewProxyAnyStatementGenerator stgen = new NewProxyAnyStatementGenerator();
            NewProxyConnectionGenerator cngen = new NewProxyConnectionGenerator();
            JdbcProxyGenerator.genclass(cngen, Connection.class, "com.mchange.v2.c3p0.impl.NewProxyConnection", srcroot);
            JdbcProxyGenerator.genclass(stgen, Statement.class, "com.mchange.v2.c3p0.impl.NewProxyStatement", srcroot);
            JdbcProxyGenerator.genclass(stgen, PreparedStatement.class, "com.mchange.v2.c3p0.impl.NewProxyPreparedStatement", srcroot);
            JdbcProxyGenerator.genclass(stgen, CallableStatement.class, "com.mchange.v2.c3p0.impl.NewProxyCallableStatement", srcroot);
            JdbcProxyGenerator.genclass(rsgen, ResultSet.class, "com.mchange.v2.c3p0.impl.NewProxyResultSet", srcroot);
            JdbcProxyGenerator.genclass(mdgen, DatabaseMetaData.class, "com.mchange.v2.c3p0.impl.NewProxyDatabaseMetaData", srcroot);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void genclass(DelegatorGenerator dg2, Class intfcl, String fqcn, File srcroot) throws IOException {
        File genDir = new File(srcroot, JdbcProxyGenerator.dirForFqcn(fqcn));
        if (!genDir.exists()) {
            System.err.println(JdbcProxyGenerator.class.getName() + " -- creating directory: " + genDir.getAbsolutePath());
            genDir.mkdirs();
        }
        String fileName = CodegenUtils.fqcnLastElement(fqcn) + ".java";
        Writer w2 = null;
        try {
            w2 = new BufferedWriter(new FileWriter(new File(genDir, fileName)));
            dg2.writeDelegator(intfcl, fqcn, w2);
            w2.flush();
            System.err.println("Generated " + fileName);
        }
        finally {
            try {
                if (w2 != null) {
                    w2.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    static String dirForFqcn(String fqcn) {
        int last_dot = fqcn.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(fqcn.substring(0, last_dot + 1));
        int len = sb.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (sb.charAt(i2) != '.') continue;
            sb.setCharAt(i2, '/');
        }
        return sb.toString();
    }

    static final class NewProxyConnectionGenerator
    extends JdbcProxyGenerator {
        NewProxyConnectionGenerator() {
            this.setMethodModifiers(33);
            this.setExtraInterfaces(new Class[]{C3P0ProxyConnection.class});
        }

        @Override
        String getInnerTypeName() {
            return "Connection";
        }

        @Override
        protected void generateDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            String mname = method.getName();
            if (JdbcProxyGenerator.jdbc4WrapperMethod(mname)) {
                JdbcProxyGenerator.generateWrapperDelegateCode(intfcl, genclass, method, iw2);
                return;
            }
            if (mname.equals("createStatement")) {
                iw2.println("txn_known_resolved = false;");
                iw2.println();
                iw2.println("Statement innerStmt = inner." + CodegenUtils.methodCall(method) + ";");
                iw2.println("parentPooledConnection.markActiveUncachedStatement( innerStmt );");
                iw2.println("return new NewProxyStatement( innerStmt, parentPooledConnection, false, this );");
            } else if (mname.equals("prepareStatement")) {
                iw2.println("txn_known_resolved = false;");
                iw2.println();
                iw2.println("PreparedStatement innerStmt;");
                iw2.println();
                iw2.println("if ( parentPooledConnection.isStatementCaching() )");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("try");
                iw2.println("{");
                iw2.upIndent();
                this.generateFindMethodAndArgs(method, iw2);
                iw2.println("innerStmt = (PreparedStatement) parentPooledConnection.checkoutStatement( method, args );");
                iw2.println("return new NewProxyPreparedStatement( innerStmt, parentPooledConnection, true, this );");
                iw2.downIndent();
                iw2.println("}");
                iw2.println("catch (ResourceClosedException e)");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("if ( logger.isLoggable( MLevel.FINE ) )");
                iw2.upIndent();
                iw2.println("logger.log( MLevel.FINE, \"A Connection tried to prepare a Statement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.\", e );");
                iw2.downIndent();
                iw2.println("innerStmt = inner." + CodegenUtils.methodCall(method) + ";");
                iw2.println("parentPooledConnection.markActiveUncachedStatement( innerStmt );");
                iw2.println("return new NewProxyPreparedStatement( innerStmt, parentPooledConnection, false, this );");
                iw2.downIndent();
                iw2.println("}");
                iw2.downIndent();
                iw2.println("}");
                iw2.println("else");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("innerStmt = inner." + CodegenUtils.methodCall(method) + ";");
                iw2.println("parentPooledConnection.markActiveUncachedStatement( innerStmt );");
                iw2.println("return new NewProxyPreparedStatement( innerStmt, parentPooledConnection, false, this );");
                iw2.downIndent();
                iw2.println("}");
            } else if (mname.equals("prepareCall")) {
                iw2.println("txn_known_resolved = false;");
                iw2.println();
                iw2.println("CallableStatement innerStmt;");
                iw2.println();
                iw2.println("if ( parentPooledConnection.isStatementCaching() )");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("try");
                iw2.println("{");
                iw2.upIndent();
                this.generateFindMethodAndArgs(method, iw2);
                iw2.println("innerStmt = (CallableStatement) parentPooledConnection.checkoutStatement( method, args );");
                iw2.println("return new NewProxyCallableStatement( innerStmt, parentPooledConnection, true, this );");
                iw2.downIndent();
                iw2.println("}");
                iw2.println("catch (ResourceClosedException e)");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("if ( logger.isLoggable( MLevel.FINE ) )");
                iw2.upIndent();
                iw2.println("logger.log( MLevel.FINE, \"A Connection tried to prepare a CallableStatement via a Statement cache that is already closed. This can happen -- rarely -- if a DataSource is closed or reset() while Connections are checked-out and in use.\", e );");
                iw2.downIndent();
                iw2.println("innerStmt = inner." + CodegenUtils.methodCall(method) + ";");
                iw2.println("parentPooledConnection.markActiveUncachedStatement( innerStmt );");
                iw2.println("return new NewProxyCallableStatement( innerStmt, parentPooledConnection, false, this );");
                iw2.downIndent();
                iw2.println("}");
                iw2.downIndent();
                iw2.println("}");
                iw2.println("else");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("innerStmt = inner." + CodegenUtils.methodCall(method) + ";");
                iw2.println("parentPooledConnection.markActiveUncachedStatement( innerStmt );");
                iw2.println("return new NewProxyCallableStatement( innerStmt, parentPooledConnection, false, this );");
                iw2.downIndent();
                iw2.println("}");
            } else if (mname.equals("getMetaData")) {
                iw2.println("txn_known_resolved = false;");
                iw2.println();
                iw2.println("if (this.metaData == null)");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("DatabaseMetaData innerMetaData = inner." + CodegenUtils.methodCall(method) + ";");
                iw2.println("this.metaData = new NewProxyDatabaseMetaData( innerMetaData, parentPooledConnection, this );");
                iw2.downIndent();
                iw2.println("}");
                iw2.println("return this.metaData;");
            } else if (mname.equals("setTransactionIsolation")) {
                super.generateDelegateCode(intfcl, genclass, method, iw2);
                iw2.println("parentPooledConnection.markNewTxnIsolation( " + CodegenUtils.generatedArgumentName(0) + " );");
            } else if (mname.equals("setCatalog")) {
                super.generateDelegateCode(intfcl, genclass, method, iw2);
                iw2.println("parentPooledConnection.markNewCatalog( " + CodegenUtils.generatedArgumentName(0) + " );");
            } else if (mname.equals("setHoldability")) {
                super.generateDelegateCode(intfcl, genclass, method, iw2);
                iw2.println("parentPooledConnection.markNewHoldability( " + CodegenUtils.generatedArgumentName(0) + " );");
            } else if (mname.equals("setReadOnly")) {
                super.generateDelegateCode(intfcl, genclass, method, iw2);
                iw2.println("parentPooledConnection.markNewReadOnly( " + CodegenUtils.generatedArgumentName(0) + " );");
            } else if (mname.equals("setTypeMap")) {
                super.generateDelegateCode(intfcl, genclass, method, iw2);
                iw2.println("parentPooledConnection.markNewTypeMap( " + CodegenUtils.generatedArgumentName(0) + " );");
            } else if (mname.equals("getWarnings") || mname.equals("clearWarnings")) {
                super.generateDelegateCode(intfcl, genclass, method, iw2);
            } else if (mname.equals("close")) {
                iw2.println("if (! this.isDetached())");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("NewPooledConnection npc = parentPooledConnection;");
                iw2.println("this.detach();");
                iw2.println("npc.markClosedProxyConnection( this, txn_known_resolved );");
                iw2.println("this.inner = null;");
                iw2.downIndent();
                iw2.println("}");
                iw2.println("else if (Debug.DEBUG && logger.isLoggable( MLevel.FINE ))");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("logger.log( MLevel.FINE, this + \": close() called more than once.\" );");
                iw2.downIndent();
                iw2.println("}");
            } else if (mname.equals("isClosed")) {
                iw2.println("return this.isDetached();");
            } else if (mname.equals("isValid")) {
                iw2.println("if (this.isDetached()) return false;");
                super.generateDelegateCode(intfcl, genclass, method, iw2);
            } else {
                boolean known_resolved;
                boolean bl2 = known_resolved = mname.equals("commit") || mname.equals("rollback") || mname.equals("setAutoCommit");
                if (!known_resolved) {
                    iw2.println("txn_known_resolved = false;");
                    iw2.println();
                }
                super.generateDelegateCode(intfcl, genclass, method, iw2);
                if (known_resolved) {
                    iw2.println();
                    iw2.println("txn_known_resolved = true;");
                }
            }
        }

        @Override
        protected void generateExtraDeclarations(Class intfcl, String genclass, IndentedWriter iw2) throws IOException {
            iw2.println("boolean txn_known_resolved = true;");
            iw2.println();
            iw2.println("DatabaseMetaData metaData = null;");
            iw2.println();
            iw2.println("public Object rawConnectionOperation(Method m, Object target, Object[] args)");
            iw2.upIndent();
            iw2.println("throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException");
            iw2.downIndent();
            iw2.println("{");
            iw2.upIndent();
            iw2.println("maybeDirtyTransaction();");
            iw2.println();
            iw2.println("if (inner == null)");
            iw2.upIndent();
            iw2.println("throw new SQLException(\"You cannot operate on a closed Connection!\");");
            iw2.downIndent();
            iw2.println("if ( target == C3P0ProxyConnection.RAW_CONNECTION)");
            iw2.upIndent();
            iw2.println("target = inner;");
            iw2.downIndent();
            iw2.println("for (int i = 0, len = args.length; i < len; ++i)");
            iw2.upIndent();
            iw2.println("if (args[i] == C3P0ProxyConnection.RAW_CONNECTION)");
            iw2.upIndent();
            iw2.println("args[i] = inner;");
            iw2.downIndent();
            iw2.downIndent();
            iw2.println("Object out = m.invoke( target, args );");
            iw2.println();
            iw2.println("// we never cache Statements generated by an operation on the raw Connection");
            iw2.println("if (out instanceof CallableStatement)");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("CallableStatement innerStmt = (CallableStatement) out;");
            iw2.println("parentPooledConnection.markActiveUncachedStatement( innerStmt );");
            iw2.println("out = new NewProxyCallableStatement( innerStmt, parentPooledConnection, false, this );");
            iw2.downIndent();
            iw2.println("}");
            iw2.println("else if (out instanceof PreparedStatement)");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("PreparedStatement innerStmt = (PreparedStatement) out;");
            iw2.println("parentPooledConnection.markActiveUncachedStatement( innerStmt );");
            iw2.println("out = new NewProxyPreparedStatement( innerStmt, parentPooledConnection, false, this );");
            iw2.downIndent();
            iw2.println("}");
            iw2.println("else if (out instanceof Statement)");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("Statement innerStmt = (Statement) out;");
            iw2.println("parentPooledConnection.markActiveUncachedStatement( innerStmt );");
            iw2.println("out = new NewProxyStatement( innerStmt, parentPooledConnection, false, this );");
            iw2.downIndent();
            iw2.println("}");
            iw2.println("else if (out instanceof ResultSet)");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("ResultSet innerRs = (ResultSet) out;");
            iw2.println("parentPooledConnection.markActiveRawConnectionResultSet( innerRs );");
            iw2.println("out = new NewProxyResultSet( innerRs, parentPooledConnection, inner, this );");
            iw2.downIndent();
            iw2.println("}");
            iw2.println("else if (out instanceof DatabaseMetaData)");
            iw2.upIndent();
            iw2.println("out = new NewProxyDatabaseMetaData( (DatabaseMetaData) out, parentPooledConnection );");
            iw2.downIndent();
            iw2.println("return out;");
            iw2.downIndent();
            iw2.println("}");
            iw2.println();
            iw2.println("synchronized void maybeDirtyTransaction()");
            iw2.println("{ txn_known_resolved = false; }");
            super.generateExtraDeclarations(intfcl, genclass, iw2);
        }

        void generateFindMethodAndArgs(Method method, IndentedWriter iw2) throws IOException {
            int i2;
            iw2.println("Class[] argTypes = ");
            iw2.println("{");
            iw2.upIndent();
            Class<?>[] argTypes = method.getParameterTypes();
            int len = argTypes.length;
            for (i2 = 0; i2 < len; ++i2) {
                if (i2 != 0) {
                    iw2.println(",");
                }
                iw2.print(CodegenUtils.simpleClassName(argTypes[i2]) + ".class");
            }
            iw2.println();
            iw2.downIndent();
            iw2.println("};");
            iw2.println("Method method = Connection.class.getMethod( \"" + method.getName() + "\" , argTypes );");
            iw2.println();
            iw2.println("Object[] args = ");
            iw2.println("{");
            iw2.upIndent();
            len = argTypes.length;
            for (i2 = 0; i2 < len; ++i2) {
                if (i2 != 0) {
                    iw2.println(",");
                }
                String argName = CodegenUtils.generatedArgumentName(i2);
                Class<?> argType = argTypes[i2];
                if (argType.isPrimitive()) {
                    if (argType == Boolean.TYPE) {
                        iw2.print("Boolean.valueOf( " + argName + " )");
                        continue;
                    }
                    if (argType == Byte.TYPE) {
                        iw2.print("new Byte( " + argName + " )");
                        continue;
                    }
                    if (argType == Character.TYPE) {
                        iw2.print("new Character( " + argName + " )");
                        continue;
                    }
                    if (argType == Short.TYPE) {
                        iw2.print("new Short( " + argName + " )");
                        continue;
                    }
                    if (argType == Integer.TYPE) {
                        iw2.print("new Integer( " + argName + " )");
                        continue;
                    }
                    if (argType == Long.TYPE) {
                        iw2.print("new Long( " + argName + " )");
                        continue;
                    }
                    if (argType == Float.TYPE) {
                        iw2.print("new Float( " + argName + " )");
                        continue;
                    }
                    if (argType != Double.TYPE) continue;
                    iw2.print("new Double( " + argName + " )");
                    continue;
                }
                iw2.print(argName);
            }
            iw2.downIndent();
            iw2.println("};");
        }

        @Override
        protected void generateExtraImports(IndentedWriter iw2) throws IOException {
            super.generateExtraImports(iw2);
            iw2.println("import java.lang.reflect.InvocationTargetException;");
            iw2.println("import com.mchange.v2.util.ResourceClosedException;");
        }

        @Override
        protected void generatePreDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            if ("setClientInfo".equals(method.getName())) {
                iw2.println("try");
                iw2.println("{");
                iw2.upIndent();
                super.generatePreDelegateCode(intfcl, genclass, method, iw2);
            } else {
                super.generatePreDelegateCode(intfcl, genclass, method, iw2);
            }
        }

        @Override
        protected void generatePostDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            if ("setClientInfo".equals(method.getName())) {
                super.generatePostDelegateCode(intfcl, genclass, method, iw2);
                iw2.downIndent();
                iw2.println("}");
                iw2.println("catch (Exception e)");
                iw2.println("{ throw SqlUtils.toSQLClientInfoException( e ); }");
            } else {
                super.generatePostDelegateCode(intfcl, genclass, method, iw2);
            }
        }
    }

    static final class NewProxyAnyStatementGenerator
    extends JdbcProxyGenerator {
        private static final boolean CONCURRENT_ACCESS_DEBUG = false;

        NewProxyAnyStatementGenerator() {
            this.setExtraInterfaces(new Class[]{C3P0ProxyStatement.class, ProxyResultSetDetachable.class});
        }

        @Override
        String getInnerTypeName() {
            return "Statement";
        }

        @Override
        protected void generateDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            String mname = method.getName();
            if (JdbcProxyGenerator.jdbc4WrapperMethod(mname)) {
                JdbcProxyGenerator.generateWrapperDelegateCode(intfcl, genclass, method, iw2);
                return;
            }
            Class<?> retType = method.getReturnType();
            iw2.println("maybeDirtyTransaction();");
            iw2.println();
            if (ResultSet.class.isAssignableFrom(retType)) {
                iw2.println("ResultSet innerResultSet = inner." + CodegenUtils.methodCall(method) + ";");
                iw2.println("if (innerResultSet == null) return null;");
                iw2.println("parentPooledConnection.markActiveResultSetForStatement( inner, innerResultSet );");
                iw2.println("NewProxyResultSet out = new NewProxyResultSet( innerResultSet, parentPooledConnection, inner, this );");
                iw2.println("synchronized ( myProxyResultSets ) { myProxyResultSets.add( out ); }");
                iw2.println("return out;");
            } else if (mname.equals("getConnection")) {
                iw2.println("if (! this.isDetached())");
                iw2.upIndent();
                iw2.println("return creatorProxy;");
                iw2.downIndent();
                iw2.println("else");
                iw2.upIndent();
                iw2.println("throw new SQLException(\"You cannot operate on a closed Statement!\");");
                iw2.downIndent();
            } else if (mname.equals("close")) {
                iw2.println("if (! this.isDetached())");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("synchronized ( myProxyResultSets )");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("for( Iterator ii = myProxyResultSets.iterator(); ii.hasNext(); )");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("ResultSet closeMe = (ResultSet) ii.next();");
                iw2.println("ii.remove();");
                iw2.println();
                iw2.println("try { closeMe.close(); }");
                iw2.println("catch (SQLException e)");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("if (logger.isLoggable( MLevel.WARNING ))");
                iw2.upIndent();
                iw2.println("logger.log( MLevel.WARNING, \"Exception on close of apparently orphaned ResultSet.\", e);");
                iw2.downIndent();
                iw2.downIndent();
                iw2.println("}");
                iw2.println("if (logger.isLoggable( MLevel.FINE ))");
                iw2.upIndent();
                iw2.println("logger.log( MLevel.FINE, this + \" closed orphaned ResultSet: \" +closeMe);");
                iw2.downIndent();
                iw2.downIndent();
                iw2.println("}");
                iw2.downIndent();
                iw2.println("}");
                iw2.println();
                iw2.println("if ( is_cached )");
                iw2.upIndent();
                iw2.println("parentPooledConnection.checkinStatement( inner );");
                iw2.downIndent();
                iw2.println("else");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("parentPooledConnection.markInactiveUncachedStatement( inner );");
                iw2.println("try{ inner.close(); }");
                iw2.println("catch (Exception e )");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("if (logger.isLoggable( MLevel.WARNING ))");
                iw2.upIndent();
                iw2.println("logger.log( MLevel.WARNING, \"Exception on close of inner statement.\", e);");
                iw2.downIndent();
                iw2.println("SQLException sqle = SqlUtils.toSQLException( e );");
                iw2.println("throw sqle;");
                iw2.downIndent();
                iw2.println("}");
                iw2.downIndent();
                iw2.println("}");
                iw2.println();
                iw2.println("this.detach();");
                iw2.println("this.inner = null;");
                iw2.println("this.creatorProxy = null;");
                iw2.downIndent();
                iw2.println("}");
            } else if (mname.equals("isClosed")) {
                iw2.println("return this.isDetached();");
            } else {
                super.generateDelegateCode(intfcl, genclass, method, iw2);
            }
        }

        @Override
        protected void generatePreDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            super.generatePreDelegateCode(intfcl, genclass, method, iw2);
        }

        @Override
        protected void generatePostDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            super.generatePostDelegateCode(intfcl, genclass, method, iw2);
        }

        @Override
        protected void generateExtraDeclarations(Class intfcl, String genclass, IndentedWriter iw2) throws IOException {
            super.generateExtraDeclarations(intfcl, genclass, iw2);
            iw2.println();
            iw2.println("boolean is_cached;");
            iw2.println("NewProxyConnection creatorProxy;");
            iw2.println();
            iw2.println("// Although formally unnecessary, we sync access to myProxyResultSets on");
            iw2.println("// that set's own lock, in case clients (illegally but not uncommonly) close()");
            iw2.println("// the Statement from a Thread other than the one they use in general");
            iw2.println("// with the Statement");
            iw2.println("HashSet myProxyResultSets = new HashSet();");
            iw2.println();
            iw2.println("public void detachProxyResultSet( ResultSet prs )");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("synchronized (myProxyResultSets) { myProxyResultSets.remove( prs ); }");
            iw2.downIndent();
            iw2.println("}");
            iw2.println();
            iw2.print(CodegenUtils.fqcnLastElement(genclass));
            iw2.println("( " + CodegenUtils.simpleClassName(intfcl) + " inner, NewPooledConnection parentPooledConnection, boolean cached, NewProxyConnection cProxy )");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("this( inner, parentPooledConnection );");
            iw2.println("this.is_cached = cached;");
            iw2.println("this.creatorProxy = cProxy;");
            iw2.downIndent();
            iw2.println("}");
            iw2.println();
            iw2.println("public Object rawStatementOperation(Method m, Object target, Object[] args) throws IllegalAccessException, InvocationTargetException, SQLException");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("maybeDirtyTransaction();");
            iw2.println();
            iw2.println("if (target == C3P0ProxyStatement.RAW_STATEMENT) target = inner;");
            iw2.println("for (int i = 0, len = args.length; i < len; ++i)");
            iw2.upIndent();
            iw2.println("if (args[i] == C3P0ProxyStatement.RAW_STATEMENT) args[i] = inner;");
            iw2.downIndent();
            iw2.println("Object out = m.invoke(target, args);");
            iw2.println("if (out instanceof ResultSet)");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("ResultSet innerResultSet = (ResultSet) out;");
            iw2.println("parentPooledConnection.markActiveResultSetForStatement( inner, innerResultSet );");
            iw2.println("out = new NewProxyResultSet( innerResultSet, parentPooledConnection, inner, this );");
            iw2.downIndent();
            iw2.println("}");
            iw2.println();
            iw2.println("return out;");
            iw2.downIndent();
            iw2.println("}");
            iw2.println();
            iw2.println("void maybeDirtyTransaction()");
            iw2.println("{ if (creatorProxy != null) creatorProxy.maybeDirtyTransaction(); }");
        }

        @Override
        protected void generateExtraImports(IndentedWriter iw2) throws IOException {
            super.generateExtraImports(iw2);
            iw2.println("import java.lang.reflect.InvocationTargetException;");
            iw2.println("import java.util.HashSet;");
            iw2.println("import java.util.Iterator;");
        }
    }

    static final class NewProxyResultSetGenerator
    extends JdbcProxyGenerator {
        NewProxyResultSetGenerator() {
        }

        @Override
        String getInnerTypeName() {
            return "ResultSet";
        }

        @Override
        protected void generateDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            String mname = method.getName();
            if (JdbcProxyGenerator.jdbc4WrapperMethod(mname)) {
                JdbcProxyGenerator.generateWrapperDelegateCode(intfcl, genclass, method, iw2);
                return;
            }
            Class<?> retType = method.getReturnType();
            iw2.println("if (proxyConn != null) proxyConn.maybeDirtyTransaction();");
            iw2.println();
            if (mname.equals("close")) {
                iw2.println("if (! this.isDetached())");
                iw2.println("{");
                iw2.upIndent();
                iw2.println("if (creator instanceof Statement)");
                iw2.upIndent();
                iw2.println("parentPooledConnection.markInactiveResultSetForStatement( (Statement) creator, inner );");
                iw2.downIndent();
                iw2.println("else if (creator instanceof DatabaseMetaData)");
                iw2.upIndent();
                iw2.println("parentPooledConnection.markInactiveMetaDataResultSet( inner );");
                iw2.downIndent();
                iw2.println("else if (creator instanceof Connection)");
                iw2.upIndent();
                iw2.println("parentPooledConnection.markInactiveRawConnectionResultSet( inner );");
                iw2.downIndent();
                iw2.println("else throw new InternalError(\"Must be Statement or DatabaseMetaData -- Bad Creator: \" + creator);");
                iw2.println("if (creatorProxy instanceof ProxyResultSetDetachable) ((ProxyResultSetDetachable) creatorProxy).detachProxyResultSet( this );");
                iw2.println("this.detach();");
                iw2.println("inner.close();");
                iw2.println("this.inner = null;");
                iw2.downIndent();
                iw2.println("}");
            } else if (mname.equals("getStatement")) {
                iw2.println("if (creator instanceof Statement)");
                iw2.upIndent();
                iw2.println("return (Statement) creatorProxy;");
                iw2.downIndent();
                iw2.println("else if (creator instanceof DatabaseMetaData)");
                iw2.upIndent();
                iw2.println("return null;");
                iw2.downIndent();
                iw2.println("else throw new InternalError(\"Must be Statement or DatabaseMetaData -- Bad Creator: \" + creator);");
            } else if (mname.equals("isClosed")) {
                iw2.println("return this.isDetached();");
            } else {
                super.generateDelegateCode(intfcl, genclass, method, iw2);
            }
        }

        @Override
        protected void generateExtraDeclarations(Class intfcl, String genclass, IndentedWriter iw2) throws IOException {
            super.generateExtraDeclarations(intfcl, genclass, iw2);
            iw2.println();
            iw2.println("Object creator;");
            iw2.println("Object creatorProxy;");
            iw2.println("NewProxyConnection proxyConn;");
            iw2.println();
            iw2.print(CodegenUtils.fqcnLastElement(genclass));
            iw2.println("( " + CodegenUtils.simpleClassName(intfcl) + " inner, NewPooledConnection parentPooledConnection, Object c, Object cProxy )");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("this( inner, parentPooledConnection );");
            iw2.println("this.creator      = c;");
            iw2.println("this.creatorProxy = cProxy;");
            iw2.println("if (creatorProxy instanceof NewProxyConnection) this.proxyConn = (NewProxyConnection) cProxy;");
            iw2.downIndent();
            iw2.println("}");
        }

        @Override
        protected void generatePreDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            super.generatePreDelegateCode(intfcl, genclass, method, iw2);
        }
    }

    static final class NewProxyMetaDataGenerator
    extends JdbcProxyGenerator {
        NewProxyMetaDataGenerator() {
        }

        @Override
        String getInnerTypeName() {
            return "DatabaseMetaData";
        }

        @Override
        protected void generateDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            String mname = method.getName();
            if (JdbcProxyGenerator.jdbc4WrapperMethod(mname)) {
                JdbcProxyGenerator.generateWrapperDelegateCode(intfcl, genclass, method, iw2);
                return;
            }
            Class<?> retType = method.getReturnType();
            if (ResultSet.class.isAssignableFrom(retType)) {
                iw2.println("ResultSet innerResultSet = inner." + CodegenUtils.methodCall(method) + ";");
                iw2.println("if (innerResultSet == null) return null;");
                iw2.println("return new NewProxyResultSet( innerResultSet, parentPooledConnection, inner, this );");
            } else if (mname.equals("getConnection")) {
                iw2.println("return this.proxyCon;");
            } else {
                super.generateDelegateCode(intfcl, genclass, method, iw2);
            }
        }

        @Override
        protected void generatePreDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            if (method.getExceptionTypes().length > 0) {
                super.generatePreDelegateCode(intfcl, genclass, method, iw2);
            }
        }

        @Override
        protected void generatePostDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw2) throws IOException {
            if (method.getExceptionTypes().length > 0) {
                super.generatePostDelegateCode(intfcl, genclass, method, iw2);
            }
        }

        @Override
        protected void generateExtraDeclarations(Class intfcl, String genclass, IndentedWriter iw2) throws IOException {
            super.generateExtraDeclarations(intfcl, genclass, iw2);
            iw2.println();
            iw2.println("NewProxyConnection proxyCon;");
            iw2.println();
            iw2.print(CodegenUtils.fqcnLastElement(genclass));
            iw2.println("( " + CodegenUtils.simpleClassName(intfcl) + " inner, NewPooledConnection parentPooledConnection, NewProxyConnection proxyCon )");
            iw2.println("{");
            iw2.upIndent();
            iw2.println("this( inner, parentPooledConnection );");
            iw2.println("this.proxyCon = proxyCon;");
            iw2.downIndent();
            iw2.println("}");
        }
    }
}

