/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.CarefulRunnableQueue;
import com.mchange.v2.async.Queuable;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.ResourceClosedException;

public class RoundRobinAsynchronousRunner
implements AsynchronousRunner,
Queuable {
    private static final MLogger logger = MLog.getLogger(RoundRobinAsynchronousRunner.class);
    final RunnableQueue[] rqs;
    int task_turn = 0;
    int view_turn = 0;

    public RoundRobinAsynchronousRunner(int n2, boolean bl2) {
        this.rqs = new RunnableQueue[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.rqs[i2] = new CarefulRunnableQueue(bl2, false);
        }
    }

    @Override
    public synchronized void postRunnable(Runnable runnable2) {
        try {
            int n2 = this.task_turn;
            this.task_turn = (this.task_turn + 1) % this.rqs.length;
            this.rqs[n2].postRunnable(runnable2);
        }
        catch (NullPointerException nullPointerException) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "NullPointerException while posting Runnable -- Probably we're closed.", nullPointerException);
            }
            this.close(true);
            throw new ResourceClosedException("Attempted to use a RoundRobinAsynchronousRunner in a closed or broken state.");
        }
    }

    @Override
    public synchronized RunnableQueue asRunnableQueue() {
        try {
            int n2 = this.view_turn;
            this.view_turn = (this.view_turn + 1) % this.rqs.length;
            return new RunnableQueueView(n2);
        }
        catch (NullPointerException nullPointerException) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "NullPointerException in asRunnableQueue() -- Probably we're closed.", nullPointerException);
            }
            this.close(true);
            throw new ResourceClosedException("Attempted to use a RoundRobinAsynchronousRunner in a closed or broken state.");
        }
    }

    @Override
    public synchronized void close(boolean bl2) {
        int n2 = this.rqs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            RoundRobinAsynchronousRunner.attemptClose(this.rqs[i2], bl2);
            this.rqs[i2] = null;
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    static void attemptClose(RunnableQueue runnableQueue, boolean bl2) {
        block2: {
            try {
                runnableQueue.close(bl2);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block2;
                logger.log(MLevel.WARNING, "RunnableQueue close FAILED.", exception);
            }
        }
    }

    class RunnableQueueView
    implements RunnableQueue {
        final int rq_num;

        RunnableQueueView(int n2) {
            this.rq_num = n2;
        }

        @Override
        public void postRunnable(Runnable runnable2) {
            RoundRobinAsynchronousRunner.this.rqs[this.rq_num].postRunnable(runnable2);
        }

        @Override
        public void close(boolean bl2) {
        }

        @Override
        public void close() {
        }
    }
}

