/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import com.mchange.v1.util.BrokenObjectException;
import com.mchange.v1.util.RunnableQueue;
import com.mchange.v1.util.SimpleRunnableQueue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractResourcePool {
    private static final boolean TRACE = true;
    private static final boolean DEBUG = true;
    private static RunnableQueue sharedQueue = new SimpleRunnableQueue();
    Set managed = new HashSet();
    List unused = new LinkedList();
    int start;
    int max;
    int inc;
    int num_acq_attempts = Integer.MAX_VALUE;
    int acq_attempt_delay = 50;
    RunnableQueue rq;
    boolean initted = false;
    boolean broken = false;

    protected AbstractResourcePool(int n2, int n3, int n4) {
        this(n2, n3, n4, sharedQueue);
    }

    protected AbstractResourcePool(int n2, int n3, int n4, RunnableQueue runnableQueue) {
        this.start = n2;
        this.max = n3;
        this.inc = n4;
        this.rq = runnableQueue;
    }

    protected abstract Object acquireResource() throws Exception;

    protected abstract void refurbishResource(Object var1) throws BrokenObjectException;

    protected abstract void destroyResource(Object var1) throws Exception;

    protected synchronized void init() throws Exception {
        for (int i2 = 0; i2 < this.start; ++i2) {
            this.assimilateResource();
        }
        this.initted = true;
    }

    protected Object checkoutResource() throws BrokenObjectException, InterruptedException, Exception {
        return this.checkoutResource(0L);
    }

    protected synchronized Object checkoutResource(long l2) throws BrokenObjectException, InterruptedException, TimeoutException, Exception {
        if (!this.initted) {
            this.init();
        }
        this.ensureNotBroken();
        int n2 = this.unused.size();
        if (n2 == 0) {
            int n3 = this.managed.size();
            if (n3 < this.max) {
                this.postAcquireMore();
            }
            this.awaitAvailable(l2);
        }
        Object e2 = this.unused.get(0);
        this.unused.remove(0);
        try {
            this.refurbishResource(e2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.removeResource(e2);
            return this.checkoutResource(l2);
        }
        this.trace();
        return e2;
    }

    protected synchronized void checkinResource(Object object) throws BrokenObjectException {
        if (!this.managed.contains(object)) {
            throw new IllegalArgumentException("ResourcePool: Tried to check-in a foreign resource!");
        }
        this.unused.add(object);
        this.notifyAll();
        this.trace();
    }

    protected synchronized void markBad(Object object) throws Exception {
        this.removeResource(object);
    }

    protected synchronized void close() throws Exception {
        this.broken = true;
        Iterator iterator2 = this.managed.iterator();
        while (iterator2.hasNext()) {
            try {
                this.removeResource(iterator2.next());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void postAcquireMore() throws InterruptedException {
        this.rq.postRunnable(new AcquireTask());
    }

    private void awaitAvailable(long l2) throws InterruptedException, TimeoutException {
        int n2;
        while ((n2 = this.unused.size()) == 0) {
            this.wait(l2);
        }
        if (n2 == 0) {
            throw new TimeoutException();
        }
    }

    private void acquireMore() throws Exception {
        int n2 = this.managed.size();
        for (int i2 = 0; i2 < Math.min(this.inc, this.max - n2); ++i2) {
            this.assimilateResource();
        }
    }

    private void assimilateResource() throws Exception {
        Object object = this.acquireResource();
        this.managed.add(object);
        this.unused.add(object);
        this.notifyAll();
        this.trace();
    }

    private void removeResource(Object object) throws Exception {
        this.managed.remove(object);
        this.unused.remove(object);
        this.destroyResource(object);
        this.trace();
    }

    private void ensureNotBroken() throws BrokenObjectException {
        if (this.broken) {
            throw new BrokenObjectException(this);
        }
    }

    private synchronized void unexpectedBreak() {
        this.broken = true;
        Iterator iterator2 = this.unused.iterator();
        while (iterator2.hasNext()) {
            try {
                this.removeResource(iterator2.next());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void trace() {
        System.err.println(this + "  [managed: " + this.managed.size() + ", " + "unused: " + this.unused.size() + ']');
    }

    protected class TimeoutException
    extends Exception {
        protected TimeoutException() {
        }
    }

    class AcquireTask
    implements Runnable {
        boolean success = false;

        AcquireTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i2 = 0; !this.success && i2 < AbstractResourcePool.this.num_acq_attempts; ++i2) {
                try {
                    if (i2 > 0) {
                        Thread.sleep(AbstractResourcePool.this.acq_attempt_delay);
                    }
                    AbstractResourcePool abstractResourcePool = AbstractResourcePool.this;
                    synchronized (abstractResourcePool) {
                        AbstractResourcePool.this.acquireMore();
                    }
                    this.success = true;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!this.success) {
                AbstractResourcePool.this.unexpectedBreak();
            }
        }
    }
}

