/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.CommandLineParser;

public class CommandLineParserImpl
implements CommandLineParser {
    String[] argv;
    String[] validSwitches;
    String[] reqSwitches;
    String[] argSwitches;
    char switch_char;

    public CommandLineParserImpl(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, char c2) {
        this.argv = stringArray;
        this.validSwitches = stringArray2 == null ? new String[]{} : stringArray2;
        this.reqSwitches = stringArray3 == null ? new String[]{} : stringArray3;
        this.argSwitches = stringArray4 == null ? new String[]{} : stringArray4;
        this.switch_char = c2;
    }

    public CommandLineParserImpl(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        this(stringArray, stringArray2, stringArray3, stringArray4, '-');
    }

    @Override
    public boolean checkSwitch(String string) {
        for (int i2 = 0; i2 < this.argv.length; ++i2) {
            if (this.argv[i2].charAt(0) != this.switch_char || !this.argv[i2].equals(this.switch_char + string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String findSwitchArg(String string) {
        for (int i2 = 0; i2 < this.argv.length - 1; ++i2) {
            if (this.argv[i2].charAt(0) != this.switch_char || !this.argv[i2].equals(this.switch_char + string)) continue;
            return this.argv[i2 + 1].charAt(0) == this.switch_char ? null : this.argv[i2 + 1];
        }
        return null;
    }

    @Override
    public boolean checkArgv() {
        return this.checkValidSwitches() && this.checkRequiredSwitches() && this.checkSwitchArgSyntax();
    }

    boolean checkValidSwitches() {
        block0: for (int i2 = 0; i2 < this.argv.length; ++i2) {
            if (this.argv[i2].charAt(0) != this.switch_char) continue;
            for (int i3 = 0; i3 < this.validSwitches.length; ++i3) {
                if (this.argv[i2].equals(this.switch_char + this.validSwitches[i3])) continue block0;
            }
            return false;
        }
        return true;
    }

    boolean checkRequiredSwitches() {
        int n2 = this.reqSwitches.length;
        while (--n2 >= 0) {
            if (this.checkSwitch(this.reqSwitches[n2])) continue;
            return false;
        }
        return true;
    }

    boolean checkSwitchArgSyntax() {
        int n2 = this.argSwitches.length;
        while (--n2 >= 0) {
            String string;
            if (!this.checkSwitch(this.argSwitches[n2]) || (string = this.findSwitchArg(this.argSwitches[n2])) != null && string.charAt(0) != this.switch_char) continue;
            return false;
        }
        return true;
    }

    @Override
    public int findLastSwitched() {
        int n2 = this.argv.length;
        while (--n2 >= 0) {
            if (this.argv[n2].charAt(0) != this.switch_char) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public String[] findUnswitchedArgs() {
        String[] stringArray = new String[this.argv.length];
        int n2 = 0;
        for (int i2 = 0; i2 < this.argv.length; ++i2) {
            if (this.argv[i2].charAt(0) == this.switch_char) {
                if (!CommandLineParserImpl.contains(this.argv[i2].substring(1), this.argSwitches)) continue;
                ++i2;
                continue;
            }
            stringArray[n2++] = this.argv[i2];
        }
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    private static boolean contains(String string, String[] stringArray) {
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            if (!stringArray[n2].equals(string)) continue;
            return true;
        }
        return false;
    }
}

