/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.impl.CircularListEnumeration;
import com.mchange.util.impl.CircularListRecord;
import java.util.Enumeration;

public class CircularList
implements Cloneable {
    CircularListRecord firstRecord = null;
    int size = 0;

    private void addElement(Object object, boolean bl2) {
        if (this.firstRecord == null) {
            this.firstRecord = new CircularListRecord(object);
        } else {
            CircularListRecord circularListRecord;
            this.firstRecord.prev.next = circularListRecord = new CircularListRecord(object, this.firstRecord.prev, this.firstRecord);
            this.firstRecord.prev = circularListRecord;
            if (bl2) {
                this.firstRecord = circularListRecord;
            }
        }
        ++this.size;
    }

    private void removeElement(boolean bl2) {
        if (this.size == 1) {
            this.firstRecord = null;
        } else {
            if (bl2) {
                this.firstRecord = this.firstRecord.next;
            }
            this.zap(this.firstRecord.prev);
        }
        --this.size;
    }

    private void zap(CircularListRecord circularListRecord) {
        circularListRecord.next.prev = circularListRecord.prev;
        circularListRecord.prev.next = circularListRecord.next;
    }

    public void appendElement(Object object) {
        this.addElement(object, false);
    }

    public void addElementToFront(Object object) {
        this.addElement(object, true);
    }

    public void removeFirstElement() {
        this.removeElement(true);
    }

    public void removeLastElement() {
        this.removeElement(false);
    }

    public void removeFromFront(int n2) {
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException(n2 + ">" + this.size);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.removeElement(true);
        }
    }

    public void removeFromBack(int n2) {
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException(n2 + ">" + this.size);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.removeElement(false);
        }
    }

    public void removeAllElements() {
        this.size = 0;
        this.firstRecord = null;
    }

    public Object getElementFromFront(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException(n2 + ">=" + this.size);
        }
        CircularListRecord circularListRecord = this.firstRecord;
        for (int i2 = 0; i2 < n2; ++i2) {
            circularListRecord = circularListRecord.next;
        }
        return circularListRecord.object;
    }

    public Object getElementFromBack(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException(n2 + ">=" + this.size);
        }
        CircularListRecord circularListRecord = this.firstRecord.prev;
        for (int i2 = 0; i2 < n2; ++i2) {
            circularListRecord = circularListRecord.prev;
        }
        return circularListRecord.object;
    }

    public Object getFirstElement() {
        try {
            return this.firstRecord.object;
        }
        catch (NullPointerException nullPointerException) {
            throw new IndexOutOfBoundsException("CircularList is empty.");
        }
    }

    public Object getLastElement() {
        try {
            return this.firstRecord.prev.object;
        }
        catch (NullPointerException nullPointerException) {
            throw new IndexOutOfBoundsException("CircularList is empty.");
        }
    }

    public Enumeration elements(boolean bl2, boolean bl3) {
        return new CircularListEnumeration(this, bl2, bl3);
    }

    public Enumeration elements(boolean bl2) {
        return this.elements(bl2, true);
    }

    public Enumeration elements() {
        return this.elements(true, true);
    }

    public int size() {
        return this.size;
    }

    public Object clone() {
        CircularList circularList = new CircularList();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            circularList.appendElement(this.getElementFromFront(i2));
        }
        return circularList;
    }

    public static void main(String[] stringArray) {
        CircularList circularList = new CircularList();
        circularList.appendElement("Hello");
        circularList.appendElement("There");
        circularList.appendElement("Joe.");
        Enumeration enumeration = circularList.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("x " + enumeration.nextElement());
        }
    }
}

