/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.rmi;

import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class RegistryManager {
    public static Registry ensureRegistry(int n2) throws RemoteException {
        Registry registry = RegistryManager.findRegistry(n2);
        if (registry == null) {
            registry = LocateRegistry.createRegistry(n2);
        }
        return registry;
    }

    public static Registry ensureRegistry() throws RemoteException {
        return RegistryManager.ensureRegistry(1099);
    }

    public static boolean registryAvailable(int n2) throws RemoteException, AccessException {
        try {
            Registry registry = LocateRegistry.getRegistry(n2);
            registry.list();
            return true;
        }
        catch (ConnectException connectException) {
            return false;
        }
    }

    public static boolean registryAvailable() throws RemoteException, AccessException {
        return RegistryManager.registryAvailable(1099);
    }

    public static Registry findRegistry(int n2) throws RemoteException, AccessException {
        if (!RegistryManager.registryAvailable(n2)) {
            return null;
        }
        return LocateRegistry.getRegistry(n2);
    }

    public static Registry findRegistry() throws RemoteException, AccessException {
        return RegistryManager.findRegistry(1099);
    }
}

