/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.lang;

import com.mchange.lang.ByteUtils;

public class LongUtils {
    private LongUtils() {
    }

    public static long longFromByteArray(byte[] byArray, int n2) {
        long l2 = 0L;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 0]) << 56;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 1]) << 48;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 2]) << 40;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 3]) << 32;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 4]) << 24;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 5]) << 16;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 6]) << 8;
        return l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 7]) << 0;
    }

    public static byte[] byteArrayFromLong(long l2) {
        byte[] byArray = new byte[8];
        LongUtils.longIntoByteArray(l2, 0, byArray);
        return byArray;
    }

    public static void longIntoByteArray(long l2, int n2, byte[] byArray) {
        byArray[n2 + 0] = (byte)(l2 >>> 56 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >>> 48 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >>> 40 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 >>> 32 & 0xFFL);
        byArray[n2 + 4] = (byte)(l2 >>> 24 & 0xFFL);
        byArray[n2 + 5] = (byte)(l2 >>> 16 & 0xFFL);
        byArray[n2 + 6] = (byte)(l2 >>> 8 & 0xFFL);
        byArray[n2 + 7] = (byte)(l2 >>> 0 & 0xFFL);
    }

    public static long longFromByteArrayLittleEndian(byte[] byArray, int n2) {
        long l2 = 0L;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 7]) << 56;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 6]) << 48;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 5]) << 40;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 4]) << 32;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 3]) << 24;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 2]) << 16;
        l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 1]) << 8;
        return l2 |= (long)ByteUtils.toUnsigned(byArray[n2 + 0]) << 0;
    }

    public static void longIntoByteArrayLittleEndian(long l2, int n2, byte[] byArray) {
        byArray[n2 + 7] = (byte)(l2 >>> 56 & 0xFFL);
        byArray[n2 + 6] = (byte)(l2 >>> 48 & 0xFFL);
        byArray[n2 + 5] = (byte)(l2 >>> 40 & 0xFFL);
        byArray[n2 + 4] = (byte)(l2 >>> 32 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 >>> 24 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >>> 16 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >>> 8 & 0xFFL);
        byArray[n2 + 0] = (byte)(l2 >>> 0 & 0xFFL);
    }

    public static int fullHashLong(long l2) {
        return LongUtils.hashLong(l2);
    }

    public static int hashLong(long l2) {
        return (int)l2 ^ (int)(l2 >>> 32);
    }
}

