/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.lang;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public final class ByteUtils {
    public static final short UNSIGNED_MAX_VALUE = 255;

    public static short toUnsigned(byte n2) {
        return (short)(n2 < 0 ? 256 + n2 : n2);
    }

    public static int unsignedPromote(byte by2) {
        return by2 & 0xFF;
    }

    public static String toHexAscii(byte by2) {
        StringWriter stringWriter = new StringWriter(2);
        ByteUtils.addHexAscii(by2, stringWriter);
        return stringWriter.toString();
    }

    public static String toLowercaseHexAscii(byte by2) {
        StringWriter stringWriter = new StringWriter(2);
        ByteUtils.addLowercaseHexAscii(by2, stringWriter);
        return stringWriter.toString();
    }

    public static String toHexAscii(byte[] byArray) {
        int n2 = byArray.length;
        StringWriter stringWriter = new StringWriter(n2 * 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteUtils.addHexAscii(byArray[i2], stringWriter);
        }
        return stringWriter.toString();
    }

    public static String toLowercaseHexAscii(byte[] byArray) {
        int n2 = byArray.length;
        StringWriter stringWriter = new StringWriter(n2 * 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteUtils.addLowercaseHexAscii(byArray[i2], stringWriter);
        }
        return stringWriter.toString();
    }

    public static byte[] fromHexAscii(String string) throws NumberFormatException {
        try {
            int n2 = string.length();
            if (n2 % 2 != 0) {
                throw new NumberFormatException("Hex ascii must be exactly two digits per byte.");
            }
            int n3 = n2 / 2;
            byte[] byArray = new byte[n3];
            int n4 = 0;
            StringReader stringReader = new StringReader(string);
            while (n4 < n3) {
                int n5 = 16 * ByteUtils.fromHexDigit(stringReader.read()) + ByteUtils.fromHexDigit(stringReader.read());
                byArray[n4++] = (byte)n5;
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new InternalError("IOException reading from StringReader?!?!");
        }
    }

    static void addHexAscii(byte by2, StringWriter stringWriter) {
        int n2 = ByteUtils.unsignedPromote(by2);
        int n3 = n2 / 16;
        int n4 = n2 % 16;
        stringWriter.write(ByteUtils.toHexDigit(n3));
        stringWriter.write(ByteUtils.toHexDigit(n4));
    }

    static void addLowercaseHexAscii(byte by2, StringWriter stringWriter) {
        int n2 = ByteUtils.unsignedPromote(by2);
        int n3 = n2 / 16;
        int n4 = n2 % 16;
        stringWriter.write(ByteUtils.toLowercaseHexDigit(n3));
        stringWriter.write(ByteUtils.toLowercaseHexDigit(n4));
    }

    private static int fromHexDigit(int n2) throws NumberFormatException {
        if (n2 >= 48 && n2 < 58) {
            return n2 - 48;
        }
        if (n2 >= 65 && n2 < 71) {
            return n2 - 55;
        }
        if (n2 >= 97 && n2 < 103) {
            return n2 - 87;
        }
        throw new NumberFormatException(39 + n2 + "' is not a valid hexadecimal digit.");
    }

    private static char toHexDigit(int n2) {
        char c2 = n2 <= 9 ? (char)(n2 + 48) : (char)(n2 + 55);
        return c2;
    }

    private static char toLowercaseHexDigit(int n2) {
        char c2 = n2 <= 9 ? (char)(n2 + 48) : (char)(n2 + 87);
        return c2;
    }

    private ByteUtils() {
    }
}

