/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.io;

import com.mchange.util.RobustMessageLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class InputStreamUtils {
    private static InputStream EMPTY_ISTREAM = new ByteArrayInputStream(new byte[0]);

    public static boolean compare(InputStream inputStream2, InputStream inputStream3, long l2) throws IOException {
        for (long i2 = 0L; i2 < l2; ++i2) {
            int n2 = inputStream2.read();
            if (n2 != inputStream3.read()) {
                return false;
            }
            if (n2 < 0) break;
        }
        return true;
    }

    public static boolean compare(InputStream inputStream2, InputStream inputStream3) throws IOException {
        int n2 = 0;
        while (n2 >= 0) {
            n2 = inputStream2.read();
            if (n2 == inputStream3.read()) continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(InputStream inputStream2, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        int n3 = inputStream2.read();
        for (int i2 = 0; n3 >= 0 && i2 < n2; ++i2) {
            byteArrayOutputStream.write(n3);
            n3 = inputStream2.read();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] getBytes(InputStream inputStream2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = inputStream2.read();
        while (n2 >= 0) {
            byteArrayOutputStream.write(n2);
            n2 = inputStream2.read();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String getContentsAsString(InputStream inputStream2, String string) throws IOException, UnsupportedEncodingException {
        return new String(InputStreamUtils.getBytes(inputStream2), string);
    }

    public static String getContentsAsString(InputStream inputStream2) throws IOException {
        try {
            return InputStreamUtils.getContentsAsString(inputStream2, System.getProperty("file.encoding", "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("You have no default character encoding, and iso-8859-1 is unsupported?!?!");
        }
    }

    public static String getContentsAsString(InputStream inputStream2, int n2, String string) throws IOException, UnsupportedEncodingException {
        return new String(InputStreamUtils.getBytes(inputStream2, n2), string);
    }

    public static String getContentsAsString(InputStream inputStream2, int n2) throws IOException {
        try {
            return InputStreamUtils.getContentsAsString(inputStream2, n2, System.getProperty("file.encoding", "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("You have no default character encoding, and iso-8859-1 is unsupported?!?!");
        }
    }

    public static InputStream getEmptyInputStream() {
        return EMPTY_ISTREAM;
    }

    public static void attemptClose(InputStream inputStream2) {
        InputStreamUtils.attemptClose(inputStream2, null);
    }

    public static void attemptClose(InputStream inputStream2, RobustMessageLogger robustMessageLogger) {
        block4: {
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {
                if (robustMessageLogger != null) {
                    robustMessageLogger.log(iOException, "IOException trying to close InputStream");
                }
            }
            catch (NullPointerException nullPointerException) {
                if (robustMessageLogger == null) break block4;
                robustMessageLogger.log(nullPointerException, "NullPointerException trying to close InputStream");
            }
        }
    }

    public static void skipFully(InputStream inputStream2, long l2) throws EOFException, IOException {
        long l3 = 0L;
        while (l3 < l2) {
            long l4 = inputStream2.skip(l2 - l3);
            if (l4 > 0L) {
                l3 += l4;
                continue;
            }
            int n2 = inputStream2.read();
            if (inputStream2.read() < 0) {
                throw new EOFException("Skipped only " + l3 + " bytes to end of file.");
            }
            ++l3;
        }
    }

    private InputStreamUtils() {
    }
}

