/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.virtual;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.screen.TabBehaviour;
import com.googlecode.lanterna.terminal.AbstractTerminal;
import com.googlecode.lanterna.terminal.virtual.TextBuffer;
import com.googlecode.lanterna.terminal.virtual.VirtualTerminal;
import com.googlecode.lanterna.terminal.virtual.VirtualTerminalListener;
import com.googlecode.lanterna.terminal.virtual.VirtualTerminalTextGraphics;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DefaultVirtualTerminal
extends AbstractTerminal
implements VirtualTerminal {
    private final TextBuffer regularTextBuffer = new TextBuffer();
    private final TextBuffer privateModeTextBuffer = new TextBuffer();
    private final TreeSet<TerminalPosition> dirtyTerminalCells = new TreeSet();
    private final List<VirtualTerminalListener> listeners = new ArrayList<VirtualTerminalListener>();
    private TextBuffer currentTextBuffer;
    private boolean wholeBufferDirty = false;
    private TerminalSize terminalSize;
    private boolean cursorVisible;
    private int backlogSize;
    private final BlockingQueue<KeyStroke> inputQueue = new LinkedBlockingQueue<KeyStroke>();
    private final EnumSet<SGR> activeModifiers = EnumSet.noneOf(SGR.class);
    private TextColor activeForegroundColor = TextColor.ANSI.DEFAULT;
    private TextColor activeBackgroundColor = TextColor.ANSI.DEFAULT;
    private TerminalPosition cursorPosition;
    private TerminalPosition savedCursorPosition;

    public DefaultVirtualTerminal() {
        this(new TerminalSize(80, 24));
    }

    public DefaultVirtualTerminal(TerminalSize initialTerminalSize) {
        this.currentTextBuffer = this.regularTextBuffer;
        this.terminalSize = initialTerminalSize;
        this.cursorVisible = true;
        this.cursorPosition = TerminalPosition.TOP_LEFT_CORNER;
        this.savedCursorPosition = TerminalPosition.TOP_LEFT_CORNER;
        this.backlogSize = 1000;
    }

    @Override
    public synchronized TerminalSize getTerminalSize() {
        return this.terminalSize;
    }

    @Override
    public synchronized void setTerminalSize(TerminalSize newSize) {
        this.terminalSize = newSize;
        this.trimBufferBacklog();
        this.correctCursor();
        for (VirtualTerminalListener listener : this.listeners) {
            listener.onResized(this, this.terminalSize);
        }
        super.onResized(newSize.getColumns(), newSize.getRows());
    }

    @Override
    public synchronized void enterPrivateMode() {
        this.currentTextBuffer = this.privateModeTextBuffer;
        this.savedCursorPosition = this.getCursorBufferPosition();
        this.setCursorPosition(TerminalPosition.TOP_LEFT_CORNER);
        this.setWholeBufferDirty();
    }

    @Override
    public synchronized void exitPrivateMode() {
        this.currentTextBuffer = this.regularTextBuffer;
        this.cursorPosition = this.savedCursorPosition;
        this.setWholeBufferDirty();
    }

    @Override
    public synchronized void clearScreen() {
        this.currentTextBuffer.clear();
        this.setWholeBufferDirty();
        this.setCursorPosition(TerminalPosition.TOP_LEFT_CORNER);
    }

    @Override
    public synchronized void setCursorPosition(int x2, int y2) {
        this.setCursorPosition(this.cursorPosition.withColumn(x2).withRow(y2));
    }

    @Override
    public synchronized void setCursorPosition(TerminalPosition cursorPosition) {
        if (this.terminalSize.getRows() < this.getBufferLineCount()) {
            cursorPosition = cursorPosition.withRelativeRow(this.getBufferLineCount() - this.terminalSize.getRows());
        }
        this.cursorPosition = cursorPosition;
        this.correctCursor();
    }

    @Override
    public synchronized TerminalPosition getCursorPosition() {
        if (this.getBufferLineCount() <= this.terminalSize.getRows()) {
            return this.getCursorBufferPosition();
        }
        return this.cursorPosition.withRelativeRow(-(this.getBufferLineCount() - this.terminalSize.getRows()));
    }

    @Override
    public synchronized TerminalPosition getCursorBufferPosition() {
        return this.cursorPosition;
    }

    @Override
    public synchronized void setCursorVisible(boolean visible) {
        this.cursorVisible = visible;
    }

    @Override
    public synchronized void putCharacter(char c2) {
        if (c2 == '\n') {
            this.moveCursorToNextLine();
        } else if (TerminalTextUtils.isPrintableCharacter(c2)) {
            this.putCharacter(new TextCharacter(c2, this.activeForegroundColor, this.activeBackgroundColor, this.activeModifiers));
        }
    }

    @Override
    public synchronized void putString(String string) {
        for (TextCharacter textCharacter : TextCharacter.fromString(string, this.activeForegroundColor, this.activeBackgroundColor, this.activeModifiers)) {
            this.putCharacter(textCharacter);
        }
    }

    @Override
    public synchronized void enableSGR(SGR sgr) {
        this.activeModifiers.add(sgr);
    }

    @Override
    public synchronized void disableSGR(SGR sgr) {
        this.activeModifiers.remove((Object)sgr);
    }

    @Override
    public synchronized void resetColorAndSGR() {
        this.activeModifiers.clear();
        this.activeForegroundColor = TextColor.ANSI.DEFAULT;
        this.activeBackgroundColor = TextColor.ANSI.DEFAULT;
    }

    @Override
    public synchronized void setForegroundColor(TextColor color) {
        this.activeForegroundColor = color;
    }

    @Override
    public synchronized void setBackgroundColor(TextColor color) {
        this.activeBackgroundColor = color;
    }

    @Override
    public synchronized byte[] enquireTerminal(int timeout2, TimeUnit timeoutUnit) {
        return this.getClass().getName().getBytes();
    }

    @Override
    public synchronized void bell() {
        for (VirtualTerminalListener listener : this.listeners) {
            listener.onBell();
        }
    }

    @Override
    public synchronized void flush() {
        for (VirtualTerminalListener listener : this.listeners) {
            listener.onFlush();
        }
    }

    @Override
    public void close() {
        for (VirtualTerminalListener listener : this.listeners) {
            listener.onClose();
        }
    }

    @Override
    public synchronized KeyStroke pollInput() {
        return (KeyStroke)this.inputQueue.poll();
    }

    @Override
    public synchronized KeyStroke readInput() {
        try {
            return this.inputQueue.take();
        }
        catch (InterruptedException e2) {
            throw new RuntimeException("Unexpected interrupt", e2);
        }
    }

    @Override
    public TextGraphics newTextGraphics() {
        return new VirtualTerminalTextGraphics(this);
    }

    @Override
    public synchronized void addVirtualTerminalListener(VirtualTerminalListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeVirtualTerminalListener(VirtualTerminalListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void setBacklogSize(int backlogSize) {
        this.backlogSize = backlogSize;
    }

    @Override
    public synchronized boolean isCursorVisible() {
        return this.cursorVisible;
    }

    @Override
    public void addInput(KeyStroke keyStroke) {
        this.inputQueue.add(keyStroke);
    }

    public synchronized TreeSet<TerminalPosition> getDirtyCells() {
        return new TreeSet<TerminalPosition>((SortedSet<TerminalPosition>)this.dirtyTerminalCells);
    }

    public synchronized TreeSet<TerminalPosition> getAndResetDirtyCells() {
        TreeSet<TerminalPosition> copy = new TreeSet<TerminalPosition>((SortedSet<TerminalPosition>)this.dirtyTerminalCells);
        this.dirtyTerminalCells.clear();
        return copy;
    }

    public synchronized boolean isWholeBufferDirtyThenReset() {
        boolean copy = this.wholeBufferDirty;
        this.wholeBufferDirty = false;
        return copy;
    }

    @Override
    public synchronized TextCharacter getCharacter(TerminalPosition position) {
        return this.getCharacter(position.getColumn(), position.getRow());
    }

    @Override
    public synchronized TextCharacter getCharacter(int column, int row) {
        if (this.terminalSize.getRows() < this.currentTextBuffer.getLineCount()) {
            row += this.currentTextBuffer.getLineCount() - this.terminalSize.getRows();
        }
        return this.getBufferCharacter(column, row);
    }

    @Override
    public TextCharacter getBufferCharacter(int column, int row) {
        return this.currentTextBuffer.getCharacter(row, column);
    }

    @Override
    public TextCharacter getBufferCharacter(TerminalPosition position) {
        return this.getBufferCharacter(position.getColumn(), position.getRow());
    }

    @Override
    public synchronized int getBufferLineCount() {
        return this.currentTextBuffer.getLineCount();
    }

    @Override
    public synchronized void forEachLine(int startRow, int endRow, VirtualTerminal.BufferWalker bufferWalker) {
        VirtualTerminal.BufferLine emptyLine = column -> TextCharacter.DEFAULT_CHARACTER;
        ListIterator<List<TextCharacter>> iterator2 = this.currentTextBuffer.getLinesFrom(startRow);
        for (int row = startRow; row <= endRow; ++row) {
            VirtualTerminal.BufferLine bufferLine = emptyLine;
            if (iterator2.hasNext()) {
                List<TextCharacter> list = iterator2.next();
                bufferLine = column -> {
                    if (column >= list.size()) {
                        return TextCharacter.DEFAULT_CHARACTER;
                    }
                    return (TextCharacter)list.get(column);
                };
            }
            bufferWalker.onLine(row, bufferLine);
        }
    }

    synchronized void putCharacter(TextCharacter terminalCharacter) {
        if (terminalCharacter.is('\t')) {
            int nrOfSpaces = TabBehaviour.ALIGN_TO_COLUMN_4.getTabReplacement(this.cursorPosition.getColumn()).length();
            for (int i2 = 0; i2 < nrOfSpaces && this.cursorPosition.getColumn() < this.terminalSize.getColumns() - 1; ++i2) {
                this.putCharacter(terminalCharacter.withCharacter(' '));
            }
        } else {
            boolean doubleWidth = terminalCharacter.isDoubleWidth();
            if (this.cursorPosition.getColumn() == this.terminalSize.getColumns() - 1 && doubleWidth) {
                this.currentTextBuffer.setCharacter(this.cursorPosition.getRow(), this.cursorPosition.getColumn(), TextCharacter.DEFAULT_CHARACTER);
                this.moveCursorToNextLine();
            }
            if (this.cursorPosition.getColumn() == this.terminalSize.getColumns()) {
                this.moveCursorToNextLine();
            }
            int i3 = this.currentTextBuffer.setCharacter(this.cursorPosition.getRow(), this.cursorPosition.getColumn(), terminalCharacter);
            if (!this.wholeBufferDirty) {
                this.dirtyTerminalCells.add(new TerminalPosition(this.cursorPosition.getColumn(), this.cursorPosition.getRow()));
                if (i3 == 1) {
                    this.dirtyTerminalCells.add(new TerminalPosition(this.cursorPosition.getColumn() + 1, this.cursorPosition.getRow()));
                } else if (i3 == 2) {
                    this.dirtyTerminalCells.add(new TerminalPosition(this.cursorPosition.getColumn() - 1, this.cursorPosition.getRow()));
                }
                if ((double)this.dirtyTerminalCells.size() > (double)(this.terminalSize.getColumns() * this.terminalSize.getRows()) * 0.9) {
                    this.setWholeBufferDirty();
                }
            }
            this.cursorPosition = this.cursorPosition.withRelativeColumn(doubleWidth ? 2 : 1);
            if (this.cursorPosition.getColumn() > this.terminalSize.getColumns()) {
                this.moveCursorToNextLine();
            }
        }
    }

    private void moveCursorToNextLine() {
        this.cursorPosition = this.cursorPosition.withColumn(0).withRelativeRow(1);
        if (this.cursorPosition.getRow() >= this.currentTextBuffer.getLineCount()) {
            this.currentTextBuffer.newLine();
        }
        this.trimBufferBacklog();
        this.correctCursor();
    }

    private void setWholeBufferDirty() {
        this.wholeBufferDirty = true;
        this.dirtyTerminalCells.clear();
    }

    private void trimBufferBacklog() {
        int trimBacklogRows;
        int bufferBacklogSize = this.backlogSize;
        if (this.currentTextBuffer == this.privateModeTextBuffer) {
            bufferBacklogSize = 0;
        }
        if ((trimBacklogRows = this.currentTextBuffer.getLineCount() - (bufferBacklogSize + this.terminalSize.getRows())) > 0) {
            this.currentTextBuffer.removeTopLines(trimBacklogRows);
            this.cursorPosition = this.cursorPosition.withRelativeRow(-trimBacklogRows);
            this.correctCursor();
            if (!this.wholeBufferDirty) {
                TreeSet<TerminalPosition> newDirtySet = new TreeSet<TerminalPosition>();
                for (TerminalPosition dirtyPosition : this.dirtyTerminalCells) {
                    TerminalPosition adjustedPosition = dirtyPosition.withRelativeRow(-trimBacklogRows);
                    if (adjustedPosition.getRow() < 0) continue;
                    newDirtySet.add(adjustedPosition);
                }
                this.dirtyTerminalCells.clear();
                this.dirtyTerminalCells.addAll(newDirtySet);
            }
        }
    }

    private void correctCursor() {
        this.cursorPosition = this.cursorPosition.withColumn(Math.min(this.cursorPosition.getColumn(), this.terminalSize.getColumns() - 1));
        this.cursorPosition = this.cursorPosition.withRow(Math.min(this.cursorPosition.getRow(), Math.max(this.terminalSize.getRows(), this.getBufferLineCount()) - 1));
        this.cursorPosition = new TerminalPosition(Math.max(this.cursorPosition.getColumn(), 0), Math.max(this.cursorPosition.getRow(), 0));
    }

    public String toString() {
        return this.currentTextBuffer.toString();
    }
}

