/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.terminal.IOSafeTerminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import com.googlecode.lanterna.terminal.swing.SwingTerminal;
import com.googlecode.lanterna.terminal.swing.SwingTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorAutoCloseTrigger;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;

public class SwingTerminalFrame
extends JFrame
implements IOSafeTerminal {
    private final SwingTerminal swingTerminal;
    private final EnumSet<TerminalEmulatorAutoCloseTrigger> autoCloseTriggers;
    private boolean disposed;

    public SwingTerminalFrame(TerminalEmulatorAutoCloseTrigger ... autoCloseTriggers) {
        this("SwingTerminalFrame", autoCloseTriggers);
    }

    public SwingTerminalFrame(String title, TerminalEmulatorAutoCloseTrigger ... autoCloseTriggers) throws HeadlessException {
        this(title, new SwingTerminal(), autoCloseTriggers);
    }

    public SwingTerminalFrame(String title, TerminalEmulatorDeviceConfiguration deviceConfiguration, SwingTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalEmulatorAutoCloseTrigger ... autoCloseTriggers) {
        this(title, null, deviceConfiguration, fontConfiguration, colorConfiguration, autoCloseTriggers);
    }

    public SwingTerminalFrame(String title, TerminalSize terminalSize, TerminalEmulatorDeviceConfiguration deviceConfiguration, SwingTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalEmulatorAutoCloseTrigger ... autoCloseTriggers) {
        this(title, new SwingTerminal(terminalSize, deviceConfiguration, fontConfiguration, colorConfiguration), autoCloseTriggers);
    }

    private SwingTerminalFrame(String title, SwingTerminal swingTerminal, TerminalEmulatorAutoCloseTrigger ... autoCloseTriggers) {
        super(title != null ? title : "SwingTerminalFrame");
        this.swingTerminal = swingTerminal;
        this.autoCloseTriggers = EnumSet.copyOf(Arrays.asList(autoCloseTriggers));
        this.disposed = false;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)swingTerminal, "Center");
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.BLACK);
    }

    public SwingTerminalFontConfiguration getFontConfiguration() {
        return this.swingTerminal.getFontConfiguration();
    }

    public TerminalEmulatorColorConfiguration getColorConfiguration() {
        return this.swingTerminal.getColorConfiguration();
    }

    public TerminalEmulatorDeviceConfiguration getDeviceConfiguration() {
        return this.swingTerminal.getDeviceConfiguration();
    }

    public Set<TerminalEmulatorAutoCloseTrigger> getAutoCloseTrigger() {
        return EnumSet.copyOf(this.autoCloseTriggers);
    }

    public SwingTerminalFrame setAutoCloseTrigger(TerminalEmulatorAutoCloseTrigger autoCloseTrigger) {
        this.autoCloseTriggers.clear();
        if (autoCloseTrigger != null) {
            this.autoCloseTriggers.add(autoCloseTrigger);
        }
        return this;
    }

    public SwingTerminalFrame addAutoCloseTrigger(TerminalEmulatorAutoCloseTrigger autoCloseTrigger) {
        if (autoCloseTrigger != null) {
            this.autoCloseTriggers.add(autoCloseTrigger);
        }
        return this;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposed = true;
    }

    @Override
    public void pack() {
        super.pack();
        this.disposed = false;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.pack();
            this.swingTerminal.requestFocusInWindow();
        }
        super.setVisible(visible);
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void addInput(KeyStroke keyStroke) {
        this.swingTerminal.addInput(keyStroke);
    }

    @Override
    public KeyStroke pollInput() {
        if (this.disposed) {
            return new KeyStroke(KeyType.EOF);
        }
        KeyStroke keyStroke = this.swingTerminal.pollInput();
        if (this.autoCloseTriggers.contains((Object)TerminalEmulatorAutoCloseTrigger.CloseOnEscape) && keyStroke != null && keyStroke.getKeyType() == KeyType.Escape) {
            this.dispose();
        }
        return keyStroke;
    }

    @Override
    public KeyStroke readInput() {
        return this.swingTerminal.readInput();
    }

    @Override
    public void enterPrivateMode() {
        this.swingTerminal.enterPrivateMode();
    }

    @Override
    public void exitPrivateMode() {
        this.swingTerminal.exitPrivateMode();
        if (this.autoCloseTriggers.contains((Object)TerminalEmulatorAutoCloseTrigger.CloseOnExitPrivateMode)) {
            this.dispose();
        }
    }

    @Override
    public void clearScreen() {
        this.swingTerminal.clearScreen();
    }

    @Override
    public void setCursorPosition(int x2, int y2) {
        this.swingTerminal.setCursorPosition(x2, y2);
    }

    @Override
    public void setCursorPosition(TerminalPosition position) {
        this.swingTerminal.setCursorPosition(position);
    }

    @Override
    public TerminalPosition getCursorPosition() {
        return this.swingTerminal.getCursorPosition();
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.swingTerminal.setCursorVisible(visible);
    }

    @Override
    public void putCharacter(char c2) {
        this.swingTerminal.putCharacter(c2);
    }

    @Override
    public void putString(String string) {
        this.swingTerminal.putString(string);
    }

    @Override
    public TextGraphics newTextGraphics() {
        return this.swingTerminal.newTextGraphics();
    }

    @Override
    public void enableSGR(SGR sgr) {
        this.swingTerminal.enableSGR(sgr);
    }

    @Override
    public void disableSGR(SGR sgr) {
        this.swingTerminal.disableSGR(sgr);
    }

    @Override
    public void resetColorAndSGR() {
        this.swingTerminal.resetColorAndSGR();
    }

    @Override
    public void setForegroundColor(TextColor color) {
        this.swingTerminal.setForegroundColor(color);
    }

    @Override
    public void setBackgroundColor(TextColor color) {
        this.swingTerminal.setBackgroundColor(color);
    }

    @Override
    public TerminalSize getTerminalSize() {
        return this.swingTerminal.getTerminalSize();
    }

    @Override
    public byte[] enquireTerminal(int timeout2, TimeUnit timeoutUnit) {
        return this.swingTerminal.enquireTerminal(timeout2, timeoutUnit);
    }

    @Override
    public void bell() {
        this.swingTerminal.bell();
    }

    @Override
    public void flush() {
        this.swingTerminal.flush();
    }

    @Override
    public void addResizeListener(TerminalResizeListener listener) {
        this.swingTerminal.addResizeListener(listener);
    }

    @Override
    public void removeResizeListener(TerminalResizeListener listener) {
        this.swingTerminal.removeResizeListener(listener);
    }
}

