/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.ansi;

import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.terminal.ansi.ANSITerminal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class UnixLikeTerminal
extends ANSITerminal {
    private final CtrlCBehaviour terminalCtrlCBehaviour;
    private final boolean catchSpecialCharacters;
    private final Thread shutdownHook;
    private boolean acquired = false;

    protected UnixLikeTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset, CtrlCBehaviour terminalCtrlCBehaviour) throws IOException {
        super(terminalInput, terminalOutput, terminalCharset);
        String catchSpecialCharactersPropValue = System.getProperty("com.googlecode.lanterna.terminal.UnixTerminal.catchSpecialCharacters", "");
        this.catchSpecialCharacters = !"false".equals(catchSpecialCharactersPropValue.trim().toLowerCase());
        this.terminalCtrlCBehaviour = terminalCtrlCBehaviour;
        this.shutdownHook = new Thread("Lanterna STTY restore"){

            @Override
            public void run() {
                UnixLikeTerminal.this.exitPrivateModeAndRestoreState();
            }
        };
        this.acquire();
    }

    protected void acquire() throws IOException {
        this.onResized(80, 24);
        this.saveTerminalSettings();
        this.canonicalMode(false);
        this.keyEchoEnabled(false);
        if (this.catchSpecialCharacters) {
            this.keyStrokeSignalsEnabled(false);
        }
        this.registerTerminalResizeListener(() -> {
            try {
                this.getTerminalSize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.acquired = true;
    }

    @Override
    public void close() throws IOException {
        this.exitPrivateModeAndRestoreState();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.acquired = false;
        super.close();
    }

    @Override
    public KeyStroke pollInput() throws IOException {
        KeyStroke key = super.pollInput();
        this.isCtrlC(key);
        return key;
    }

    @Override
    public KeyStroke readInput() throws IOException {
        KeyStroke key = super.readInput();
        this.isCtrlC(key);
        return key;
    }

    protected CtrlCBehaviour getTerminalCtrlCBehaviour() {
        return this.terminalCtrlCBehaviour;
    }

    protected abstract void registerTerminalResizeListener(Runnable var1) throws IOException;

    protected abstract void saveTerminalSettings() throws IOException;

    protected abstract void restoreTerminalSettings() throws IOException;

    private void restoreTerminalSettingsAndKeyStrokeSignals() throws IOException {
        this.restoreTerminalSettings();
        if (this.catchSpecialCharacters) {
            this.keyStrokeSignalsEnabled(true);
        }
    }

    protected abstract void keyEchoEnabled(boolean var1) throws IOException;

    protected abstract void canonicalMode(boolean var1) throws IOException;

    protected abstract void keyStrokeSignalsEnabled(boolean var1) throws IOException;

    private void isCtrlC(KeyStroke key) throws IOException {
        if (key != null && this.terminalCtrlCBehaviour == CtrlCBehaviour.CTRL_C_KILLS_APPLICATION && key.getCharacter() != null && key.getCharacter().charValue() == 'c' && !key.isAltDown() && key.isCtrlDown()) {
            if (this.isInPrivateMode()) {
                this.exitPrivateMode();
            }
            System.exit(1);
        }
    }

    private void exitPrivateModeAndRestoreState() {
        if (!this.acquired) {
            return;
        }
        try {
            if (this.isInPrivateMode()) {
                this.exitPrivateMode();
            }
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
        try {
            this.restoreTerminalSettingsAndKeyStrokeSignals();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum CtrlCBehaviour {
        TRAP,
        CTRL_C_KILLS_APPLICATION;

    }
}

