/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.ansi;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.input.DefaultKeyDecodingProfile;
import com.googlecode.lanterna.input.KeyDecodingProfile;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseAction;
import com.googlecode.lanterna.terminal.ExtendedTerminal;
import com.googlecode.lanterna.terminal.MouseCaptureMode;
import com.googlecode.lanterna.terminal.ansi.StreamBasedTerminal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class ANSITerminal
extends StreamBasedTerminal
implements ExtendedTerminal {
    private MouseCaptureMode requestedMouseCaptureMode = null;
    private MouseCaptureMode mouseCaptureMode = null;
    private boolean inPrivateMode = false;

    protected ANSITerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        super(terminalInput, terminalOutput, terminalCharset);
        this.getInputDecoder().addProfile(this.getDefaultKeyDecodingProfile());
    }

    protected KeyDecodingProfile getDefaultKeyDecodingProfile() {
        return new DefaultKeyDecodingProfile();
    }

    private void writeCSISequenceToTerminal(byte ... tail) throws IOException {
        byte[] completeSequence = new byte[tail.length + 2];
        completeSequence[0] = 27;
        completeSequence[1] = 91;
        System.arraycopy(tail, 0, completeSequence, 2, tail.length);
        this.writeToTerminal(completeSequence);
    }

    private void writeSGRSequenceToTerminal(byte ... sgrParameters) throws IOException {
        byte[] completeSequence = new byte[sgrParameters.length + 3];
        completeSequence[0] = 27;
        completeSequence[1] = 91;
        completeSequence[completeSequence.length - 1] = 109;
        System.arraycopy(sgrParameters, 0, completeSequence, 2, sgrParameters.length);
        this.writeToTerminal(completeSequence);
    }

    private void writeOSCSequenceToTerminal(byte ... tail) throws IOException {
        byte[] completeSequence = new byte[tail.length + 2];
        completeSequence[0] = 27;
        completeSequence[1] = 93;
        System.arraycopy(tail, 0, completeSequence, 2, tail.length);
        this.writeToTerminal(completeSequence);
    }

    @Override
    public final synchronized TerminalSize getTerminalSize() throws IOException {
        TerminalSize size = this.findTerminalSize();
        this.onResized(size);
        return size;
    }

    protected TerminalSize findTerminalSize() throws IOException {
        this.saveCursorPosition();
        this.setCursorPosition(5000, 5000);
        this.resetMemorizedCursorPosition();
        this.reportPosition();
        this.restoreCursorPosition();
        TerminalPosition terminalPosition = this.waitForCursorPositionReport();
        if (terminalPosition == null) {
            terminalPosition = new TerminalPosition(80, 24);
        }
        return new TerminalSize(terminalPosition.getColumn(), terminalPosition.getRow());
    }

    @Override
    public void setTerminalSize(int columns, int rows) throws IOException {
        this.writeCSISequenceToTerminal(("8;" + rows + ";" + columns + "t").getBytes());
        this.getTerminalSize();
    }

    @Override
    public void setTitle(String title) throws IOException {
        title = title.replace("\u0007", "");
        this.writeOSCSequenceToTerminal(("2;" + title + "\u0007").getBytes());
    }

    @Override
    public void setForegroundColor(TextColor color) throws IOException {
        this.writeSGRSequenceToTerminal(color.getForegroundSGRSequence());
    }

    @Override
    public void setBackgroundColor(TextColor color) throws IOException {
        this.writeSGRSequenceToTerminal(color.getBackgroundSGRSequence());
    }

    @Override
    public void enableSGR(SGR sgr) throws IOException {
        switch (sgr) {
            case BLINK: {
                this.writeCSISequenceToTerminal(53, 109);
                break;
            }
            case BOLD: {
                this.writeCSISequenceToTerminal(49, 109);
                break;
            }
            case BORDERED: {
                this.writeCSISequenceToTerminal(53, 49, 109);
                break;
            }
            case CIRCLED: {
                this.writeCSISequenceToTerminal(53, 50, 109);
                break;
            }
            case CROSSED_OUT: {
                this.writeCSISequenceToTerminal(57, 109);
                break;
            }
            case FRAKTUR: {
                this.writeCSISequenceToTerminal(50, 48, 109);
                break;
            }
            case REVERSE: {
                this.writeCSISequenceToTerminal(55, 109);
                break;
            }
            case UNDERLINE: {
                this.writeCSISequenceToTerminal(52, 109);
                break;
            }
            case ITALIC: {
                this.writeCSISequenceToTerminal(51, 109);
            }
        }
    }

    @Override
    public void disableSGR(SGR sgr) throws IOException {
        switch (sgr) {
            case BLINK: {
                this.writeCSISequenceToTerminal(50, 53, 109);
                break;
            }
            case BOLD: {
                this.writeCSISequenceToTerminal(50, 50, 109);
                break;
            }
            case BORDERED: {
                this.writeCSISequenceToTerminal(53, 52, 109);
                break;
            }
            case CIRCLED: {
                this.writeCSISequenceToTerminal(53, 52, 109);
                break;
            }
            case CROSSED_OUT: {
                this.writeCSISequenceToTerminal(50, 57, 109);
                break;
            }
            case FRAKTUR: {
                this.writeCSISequenceToTerminal(50, 51, 109);
                break;
            }
            case REVERSE: {
                this.writeCSISequenceToTerminal(50, 55, 109);
                break;
            }
            case UNDERLINE: {
                this.writeCSISequenceToTerminal(50, 52, 109);
                break;
            }
            case ITALIC: {
                this.writeCSISequenceToTerminal(50, 51, 109);
            }
        }
    }

    @Override
    public void resetColorAndSGR() throws IOException {
        this.writeCSISequenceToTerminal(48, 109);
    }

    @Override
    public void clearScreen() throws IOException {
        this.writeCSISequenceToTerminal(50, 74);
    }

    @Override
    public void enterPrivateMode() throws IOException {
        if (this.inPrivateMode) {
            throw new IllegalStateException("Cannot call enterPrivateMode() when already in private mode");
        }
        this.writeCSISequenceToTerminal(63, 49, 48, 52, 57, 104);
        if (this.requestedMouseCaptureMode != null) {
            this.mouseCaptureMode = this.requestedMouseCaptureMode;
            this.updateMouseCaptureMode(this.mouseCaptureMode, 'h');
        }
        this.flush();
        this.inPrivateMode = true;
    }

    @Override
    public void exitPrivateMode() throws IOException {
        if (!this.inPrivateMode) {
            throw new IllegalStateException("Cannot call exitPrivateMode() when not in private mode");
        }
        this.resetColorAndSGR();
        this.setCursorVisible(true);
        this.writeCSISequenceToTerminal(63, 49, 48, 52, 57, 108);
        if (null != this.mouseCaptureMode) {
            this.updateMouseCaptureMode(this.mouseCaptureMode, 'l');
            this.mouseCaptureMode = null;
        }
        this.flush();
        this.inPrivateMode = false;
    }

    @Override
    public void close() throws IOException {
        if (this.isInPrivateMode()) {
            this.exitPrivateMode();
        }
        super.close();
    }

    @Override
    public void setCursorPosition(int x2, int y2) throws IOException {
        this.writeCSISequenceToTerminal((y2 + 1 + ";" + (x2 + 1) + "H").getBytes());
    }

    @Override
    public void setCursorPosition(TerminalPosition position) throws IOException {
        this.setCursorPosition(position.getColumn(), position.getRow());
    }

    @Override
    public synchronized TerminalPosition getCursorPosition() throws IOException {
        this.resetMemorizedCursorPosition();
        this.reportPosition();
        TerminalPosition terminalPosition = this.waitForCursorPositionReport();
        if (terminalPosition == null) {
            terminalPosition = TerminalPosition.OFFSET_1x1;
        }
        return terminalPosition.withRelative(-1, -1);
    }

    @Override
    public void setCursorVisible(boolean visible) throws IOException {
        this.writeCSISequenceToTerminal(("?25" + (visible ? "h" : "l")).getBytes());
    }

    @Override
    public KeyStroke readInput() throws IOException {
        KeyStroke keyStroke;
        while ((keyStroke = this.filterMouseEvents(super.readInput())) == null) {
        }
        return keyStroke;
    }

    @Override
    public KeyStroke pollInput() throws IOException {
        return this.filterMouseEvents(super.pollInput());
    }

    private KeyStroke filterMouseEvents(KeyStroke keyStroke) {
        if (keyStroke == null || keyStroke.getKeyType() != KeyType.MouseEvent) {
            return keyStroke;
        }
        MouseAction mouseAction = (MouseAction)keyStroke;
        switch (mouseAction.getActionType()) {
            case CLICK_RELEASE: {
                if (this.mouseCaptureMode != MouseCaptureMode.CLICK) break;
                return null;
            }
            case DRAG: {
                if (this.mouseCaptureMode != MouseCaptureMode.CLICK && this.mouseCaptureMode != MouseCaptureMode.CLICK_RELEASE) break;
                return null;
            }
            case MOVE: {
                if (this.mouseCaptureMode != MouseCaptureMode.CLICK && this.mouseCaptureMode != MouseCaptureMode.CLICK_RELEASE && this.mouseCaptureMode != MouseCaptureMode.CLICK_RELEASE_DRAG) break;
                return null;
            }
        }
        return mouseAction;
    }

    @Override
    public void pushTitle() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void popTitle() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void iconify() throws IOException {
        this.writeCSISequenceToTerminal(50, 116);
    }

    @Override
    public void deiconify() throws IOException {
        this.writeCSISequenceToTerminal(49, 116);
    }

    @Override
    public void maximize() throws IOException {
        this.writeCSISequenceToTerminal(57, 59, 49, 116);
    }

    @Override
    public void unmaximize() throws IOException {
        this.writeCSISequenceToTerminal(57, 59, 48, 116);
    }

    private void updateMouseCaptureMode(MouseCaptureMode mouseCaptureMode, char l_or_h) throws IOException {
        if (mouseCaptureMode == null) {
            return;
        }
        switch (mouseCaptureMode) {
            case CLICK: {
                this.writeCSISequenceToTerminal(63, 57, (byte)l_or_h);
                break;
            }
            case CLICK_RELEASE: {
                this.writeCSISequenceToTerminal(63, 49, 48, 48, 48, (byte)l_or_h);
                break;
            }
            case CLICK_RELEASE_DRAG: {
                this.writeCSISequenceToTerminal(63, 49, 48, 48, 50, (byte)l_or_h);
                break;
            }
            case CLICK_RELEASE_DRAG_MOVE: {
                this.writeCSISequenceToTerminal(63, 49, 48, 48, 51, (byte)l_or_h);
            }
        }
        if (this.getCharset().equals(StandardCharsets.UTF_8)) {
            this.writeCSISequenceToTerminal(63, 49, 48, 48, 53, (byte)l_or_h);
        }
    }

    @Override
    public void setMouseCaptureMode(MouseCaptureMode mouseCaptureMode) throws IOException {
        this.requestedMouseCaptureMode = mouseCaptureMode;
        if (this.inPrivateMode && this.requestedMouseCaptureMode != this.mouseCaptureMode) {
            this.updateMouseCaptureMode(this.mouseCaptureMode, 'l');
            this.mouseCaptureMode = this.requestedMouseCaptureMode;
            this.updateMouseCaptureMode(this.mouseCaptureMode, 'h');
        }
    }

    @Override
    public void scrollLines(int firstLine, int lastLine, int distance) throws IOException {
        String CSI = "\u001b[";
        if (distance == 0) {
            return;
        }
        if (firstLine < 0) {
            firstLine = 0;
        }
        if (lastLine < firstLine) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u001b[").append(firstLine + 1).append(';').append(lastLine + 1).append('r');
        int target = distance > 0 ? lastLine : firstLine;
        sb.append("\u001b[").append(target + 1).append(";1H");
        if (distance > 0) {
            int num = Math.min(distance, lastLine - firstLine + 1);
            for (int i2 = 0; i2 < num; ++i2) {
                sb.append('\n');
            }
        } else {
            int num = Math.min(-distance, lastLine - firstLine + 1);
            for (int i3 = 0; i3 < num; ++i3) {
                sb.append("\u001bM");
            }
        }
        sb.append("\u001b[").append('r');
        this.writeToTerminal(sb.toString().getBytes());
    }

    boolean isInPrivateMode() {
        return this.inPrivateMode;
    }

    void reportPosition() throws IOException {
        this.writeCSISequenceToTerminal("6n".getBytes());
    }

    void restoreCursorPosition() throws IOException {
        this.writeCSISequenceToTerminal("u".getBytes());
    }

    void saveCursorPosition() throws IOException {
        this.writeCSISequenceToTerminal("s".getBytes());
    }
}

