/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.terminal.ExtendedTerminal;
import com.googlecode.lanterna.terminal.IOSafeExtendedTerminal;
import com.googlecode.lanterna.terminal.IOSafeTerminal;
import com.googlecode.lanterna.terminal.MouseCaptureMode;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class IOSafeTerminalAdapter
implements IOSafeTerminal {
    private final Terminal backend;
    final ExceptionHandler exceptionHandler;

    public static IOSafeTerminal createRuntimeExceptionConvertingAdapter(Terminal terminal) {
        if (terminal instanceof ExtendedTerminal) {
            return IOSafeTerminalAdapter.createRuntimeExceptionConvertingAdapter((ExtendedTerminal)terminal);
        }
        return new IOSafeTerminalAdapter(terminal, new ConvertToRuntimeException());
    }

    public static IOSafeExtendedTerminal createRuntimeExceptionConvertingAdapter(ExtendedTerminal terminal) {
        return new Extended(terminal, (ExceptionHandler)new ConvertToRuntimeException());
    }

    public static IOSafeTerminal createDoNothingOnExceptionAdapter(Terminal terminal) {
        if (terminal instanceof ExtendedTerminal) {
            return IOSafeTerminalAdapter.createDoNothingOnExceptionAdapter((ExtendedTerminal)terminal);
        }
        return new IOSafeTerminalAdapter(terminal, new DoNothingAndOrReturnNull());
    }

    public static IOSafeExtendedTerminal createDoNothingOnExceptionAdapter(ExtendedTerminal terminal) {
        return new Extended(terminal, (ExceptionHandler)new DoNothingAndOrReturnNull());
    }

    public IOSafeTerminalAdapter(Terminal backend, ExceptionHandler exceptionHandler) {
        this.backend = backend;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void enterPrivateMode() {
        try {
            this.backend.enterPrivateMode();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void exitPrivateMode() {
        try {
            this.backend.exitPrivateMode();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void clearScreen() {
        try {
            this.backend.clearScreen();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void setCursorPosition(int x2, int y2) {
        try {
            this.backend.setCursorPosition(x2, y2);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void setCursorPosition(TerminalPosition position) {
        try {
            this.backend.setCursorPosition(position);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public TerminalPosition getCursorPosition() {
        try {
            return this.backend.getCursorPosition();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
            return null;
        }
    }

    @Override
    public void setCursorVisible(boolean visible) {
        try {
            this.backend.setCursorVisible(visible);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void putCharacter(char c2) {
        try {
            this.backend.putCharacter(c2);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void putString(String string) {
        try {
            this.backend.putString(string);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public TextGraphics newTextGraphics() {
        try {
            return this.backend.newTextGraphics();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
            return null;
        }
    }

    @Override
    public void enableSGR(SGR sgr) {
        try {
            this.backend.enableSGR(sgr);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void disableSGR(SGR sgr) {
        try {
            this.backend.disableSGR(sgr);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void resetColorAndSGR() {
        try {
            this.backend.resetColorAndSGR();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void setForegroundColor(TextColor color) {
        try {
            this.backend.setForegroundColor(color);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void setBackgroundColor(TextColor color) {
        try {
            this.backend.setBackgroundColor(color);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void addResizeListener(TerminalResizeListener listener) {
        this.backend.addResizeListener(listener);
    }

    @Override
    public void removeResizeListener(TerminalResizeListener listener) {
        this.backend.removeResizeListener(listener);
    }

    @Override
    public TerminalSize getTerminalSize() {
        try {
            return this.backend.getTerminalSize();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
            return null;
        }
    }

    @Override
    public byte[] enquireTerminal(int timeout2, TimeUnit timeoutUnit) {
        try {
            return this.backend.enquireTerminal(timeout2, timeoutUnit);
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
            return null;
        }
    }

    @Override
    public void bell() {
        try {
            this.backend.bell();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void flush() {
        try {
            this.backend.flush();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public void close() {
        try {
            this.backend.close();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
        }
    }

    @Override
    public KeyStroke pollInput() {
        try {
            return this.backend.pollInput();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
            return null;
        }
    }

    @Override
    public KeyStroke readInput() {
        try {
            return this.backend.readInput();
        }
        catch (IOException e2) {
            this.exceptionHandler.onException(e2);
            return null;
        }
    }

    public static class Extended
    extends IOSafeTerminalAdapter
    implements IOSafeExtendedTerminal {
        private final ExtendedTerminal backend;

        public Extended(ExtendedTerminal backend, ExceptionHandler exceptionHandler) {
            super(backend, exceptionHandler);
            this.backend = backend;
        }

        @Override
        public void setTerminalSize(int columns, int rows) {
            try {
                this.backend.setTerminalSize(columns, rows);
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }

        @Override
        public void setTitle(String title) {
            try {
                this.backend.setTitle(title);
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }

        @Override
        public void pushTitle() {
            try {
                this.backend.pushTitle();
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }

        @Override
        public void popTitle() {
            try {
                this.backend.popTitle();
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }

        @Override
        public void iconify() {
            try {
                this.backend.iconify();
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }

        @Override
        public void deiconify() {
            try {
                this.backend.deiconify();
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }

        @Override
        public void maximize() {
            try {
                this.backend.maximize();
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }

        @Override
        public void unmaximize() {
            try {
                this.backend.unmaximize();
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }

        @Override
        public void setMouseCaptureMode(MouseCaptureMode mouseCaptureMode) {
            try {
                this.backend.setMouseCaptureMode(mouseCaptureMode);
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }

        @Override
        public void scrollLines(int firstLine, int lastLine, int distance) {
            try {
                this.backend.scrollLines(firstLine, lastLine, distance);
            }
            catch (IOException e2) {
                this.exceptionHandler.onException(e2);
            }
        }
    }

    private static class DoNothingAndOrReturnNull
    implements ExceptionHandler {
        private DoNothingAndOrReturnNull() {
        }

        @Override
        public void onException(IOException e2) {
        }
    }

    private static class ConvertToRuntimeException
    implements ExceptionHandler {
        private ConvertToRuntimeException() {
        }

        @Override
        public void onException(IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static interface ExceptionHandler {
        public void onException(IOException var1);
    }
}

