/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.List;

public class NormalCharacterPattern
implements CharacterPattern {
    @Override
    public CharacterPattern.Matching match(List<Character> seq) {
        if (seq.size() != 1) {
            return null;
        }
        char ch2 = seq.get(0).charValue();
        if (NormalCharacterPattern.isPrintableChar(ch2)) {
            KeyStroke ks2 = new KeyStroke(Character.valueOf(ch2), false, false);
            return new CharacterPattern.Matching(ks2);
        }
        return null;
    }

    private static boolean isPrintableChar(char c2) {
        if (Character.isISOControl(c2)) {
            return false;
        }
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c2);
        return block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

