/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.List;

public class CtrlAndCharacterPattern
implements CharacterPattern {
    @Override
    public CharacterPattern.Matching match(List<Character> seq) {
        int size = seq.size();
        char ch2 = seq.get(0).charValue();
        if (size != 1) {
            return null;
        }
        if (ch2 < ' ') {
            char ctrlCode;
            switch (ch2) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\r': 
                case '\u001b': {
                    return null;
                }
                case '\u0000': {
                    ctrlCode = ' ';
                    break;
                }
                case '\u001c': {
                    ctrlCode = '\\';
                    break;
                }
                case '\u001d': {
                    ctrlCode = ']';
                    break;
                }
                case '\u001e': {
                    ctrlCode = '^';
                    break;
                }
                case '\u001f': {
                    ctrlCode = '_';
                    break;
                }
                default: {
                    ctrlCode = (char)(96 + ch2);
                }
            }
            KeyStroke ks2 = new KeyStroke(Character.valueOf(ctrlCode), true, false);
            return new CharacterPattern.Matching(ks2);
        }
        return null;
    }
}

