/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import java.util.List;

public class CtrlAltAndCharacterPattern
implements CharacterPattern {
    @Override
    public CharacterPattern.Matching match(List<Character> seq) {
        int size = seq.size();
        if (size > 2 || seq.get(0).charValue() != '\u001b') {
            return null;
        }
        if (size == 1) {
            return CharacterPattern.Matching.NOT_YET;
        }
        char ch2 = seq.get(1).charValue();
        if (ch2 < ' ' && ch2 != '\b') {
            char ctrlCode;
            switch (ch2) {
                case '\u001b': {
                    return null;
                }
                case '\u0000': {
                    ctrlCode = ' ';
                    break;
                }
                case '\u001c': {
                    ctrlCode = '\\';
                    break;
                }
                case '\u001d': {
                    ctrlCode = ']';
                    break;
                }
                case '\u001e': {
                    ctrlCode = '^';
                    break;
                }
                case '\u001f': {
                    ctrlCode = '_';
                    break;
                }
                default: {
                    ctrlCode = (char)(96 + ch2);
                }
            }
            KeyStroke ks2 = new KeyStroke(Character.valueOf(ctrlCode), true, true);
            return new CharacterPattern.Matching(ks2);
        }
        if (ch2 == '\u007f' || ch2 == '\b') {
            KeyStroke ks3 = new KeyStroke(KeyType.Backspace, false, true);
            return new CharacterPattern.Matching(ks3);
        }
        return null;
    }
}

