/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.menu;

import com.googlecode.lanterna.gui2.MenuPopupWindow;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.WindowListenerAdapter;
import com.googlecode.lanterna.gui2.menu.MenuBar;
import com.googlecode.lanterna.gui2.menu.MenuItem;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Menu
extends MenuItem {
    private final List<MenuItem> subItems = new ArrayList<MenuItem>();

    public Menu(String label) {
        super(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Menu add(MenuItem menuItem) {
        List<MenuItem> list = this.subItems;
        synchronized (list) {
            this.subItems.add(menuItem);
        }
        return this;
    }

    @Override
    protected boolean onActivated() {
        boolean result = true;
        if (this.subItems.isEmpty()) {
            return result;
        }
        final MenuPopupWindow popupMenu = new MenuPopupWindow(this);
        final AtomicBoolean popupCancelled = new AtomicBoolean(false);
        for (MenuItem menuItem : this.subItems) {
            popupMenu.addMenuItem(menuItem);
        }
        if (this.getParent() instanceof MenuBar) {
            final MenuBar menuBar = (MenuBar)this.getParent();
            popupMenu.addWindowListener(new WindowListenerAdapter(){

                @Override
                public void onUnhandledInput(Window basePane, KeyStroke keyStroke, AtomicBoolean hasBeenHandled) {
                    int thisMenuIndex;
                    if (keyStroke.getKeyType() == KeyType.ArrowLeft) {
                        int thisMenuIndex2 = menuBar.getChildrenList().indexOf(Menu.this);
                        if (thisMenuIndex2 > 0) {
                            popupMenu.close();
                            Menu nextSelectedMenu = menuBar.getMenu(thisMenuIndex2 - 1);
                            nextSelectedMenu.takeFocus();
                            nextSelectedMenu.onActivated();
                        }
                    } else if (keyStroke.getKeyType() == KeyType.ArrowRight && (thisMenuIndex = menuBar.getChildrenList().indexOf(Menu.this)) >= 0 && thisMenuIndex < menuBar.getMenuCount() - 1) {
                        popupMenu.close();
                        Menu nextSelectedMenu = menuBar.getMenu(thisMenuIndex + 1);
                        nextSelectedMenu.takeFocus();
                        nextSelectedMenu.onActivated();
                    }
                }
            });
        }
        popupMenu.addWindowListener(new WindowListenerAdapter(){

            @Override
            public void onUnhandledInput(Window basePane, KeyStroke keyStroke, AtomicBoolean hasBeenHandled) {
                if (keyStroke.getKeyType() == KeyType.Escape) {
                    popupCancelled.set(true);
                    popupMenu.close();
                }
            }
        });
        ((WindowBasedTextGUI)this.getTextGUI()).addWindowAndWait(popupMenu);
        result = !popupCancelled.get();
        return result;
    }
}

