/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.gui2.ActionListBox;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.Panels;
import com.googlecode.lanterna.gui2.Separator;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

public class FileDialog
extends DialogWindow {
    private final ActionListBox fileListBox;
    private final ActionListBox directoryListBox;
    private final TextBox fileBox;
    private final Button okButton;
    private final boolean showHiddenFilesAndDirs;
    private File directory;
    private File selectedFile = null;

    public FileDialog(String title, String description, String actionLabel, TerminalSize dialogSize, boolean showHiddenFilesAndDirs, File selectedObject) {
        super(title);
        this.showHiddenFilesAndDirs = showHiddenFilesAndDirs;
        if (selectedObject == null || !selectedObject.exists()) {
            selectedObject = new File("").getAbsoluteFile();
        }
        selectedObject = selectedObject.getAbsoluteFile();
        Panel contentPane = new Panel();
        contentPane.setLayoutManager(new GridLayout(2));
        if (description != null) {
            ((Label)new Label(description).setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.BEGINNING, GridLayout.Alignment.CENTER, false, false, 2, 1))).addTo(contentPane);
        }
        int unitWidth = dialogSize.getColumns() / 3;
        int unitHeight = dialogSize.getRows();
        ((Label)new FileSystemLocationLabel().setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.FILL, GridLayout.Alignment.CENTER, true, false, 2, 1))).addTo(contentPane);
        this.fileListBox = new ActionListBox(new TerminalSize(unitWidth * 2, unitHeight));
        this.fileListBox.withBorder(Borders.singleLine()).setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.BEGINNING, GridLayout.Alignment.CENTER, false, false)).addTo(contentPane);
        this.directoryListBox = new ActionListBox(new TerminalSize(unitWidth, unitHeight));
        this.directoryListBox.withBorder(Borders.singleLine()).addTo(contentPane);
        this.fileBox = (TextBox)((TextBox)new TextBox().setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.FILL, GridLayout.Alignment.CENTER, true, false, 2, 1))).addTo(contentPane);
        ((Separator)new Separator(Direction.HORIZONTAL).setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.FILL, GridLayout.Alignment.CENTER, true, false, 2, 1))).addTo(contentPane);
        this.okButton = new Button(actionLabel, new OkHandler());
        ((Panel)Panels.grid(2, this.okButton, new Button(LocalizedString.Cancel.toString(), new CancelHandler())).setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.END, GridLayout.Alignment.CENTER, false, false, 2, 1))).addTo(contentPane);
        if (selectedObject.isFile()) {
            this.directory = selectedObject.getParentFile();
            this.fileBox.setText(selectedObject.getName());
        } else if (selectedObject.isDirectory()) {
            this.directory = selectedObject;
        }
        this.reloadViews(this.directory);
        this.setComponent(contentPane);
    }

    @Override
    public File showDialog(WindowBasedTextGUI textGUI) {
        this.selectedFile = null;
        super.showDialog(textGUI);
        return this.selectedFile;
    }

    private void reloadViews(File directory) {
        this.directoryListBox.clearItems();
        this.fileListBox.clearItems();
        File[] entries = directory.listFiles();
        if (entries == null) {
            return;
        }
        Arrays.sort(entries, Comparator.comparing(o2 -> o2.getName().toLowerCase()));
        if (directory.getAbsoluteFile().getParentFile() != null) {
            this.directoryListBox.addItem("..", () -> {
                this.directory = directory.getAbsoluteFile().getParentFile();
                this.reloadViews(directory.getAbsoluteFile().getParentFile());
            });
        } else {
            File[] roots;
            File[] fileArray = roots = File.listRoots();
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File entry = fileArray[i2];
                if (!entry.canRead()) continue;
                this.directoryListBox.addItem('[' + entry.getPath() + ']', () -> {
                    this.directory = entry;
                    this.reloadViews(entry);
                });
            }
        }
        for (File entry : entries) {
            if (entry.isHidden() && !this.showHiddenFilesAndDirs) continue;
            if (entry.isDirectory()) {
                this.directoryListBox.addItem(entry.getName(), () -> {
                    this.directory = entry;
                    this.reloadViews(entry);
                });
                continue;
            }
            this.fileListBox.addItem(entry.getName(), () -> {
                this.fileBox.setText(entry.getName());
                this.setFocusedInteractable(this.okButton);
            });
        }
        if (this.fileListBox.isEmpty()) {
            this.fileListBox.addItem("<empty>", new DoNothing());
        }
    }

    private class FileSystemLocationLabel
    extends Label {
        public FileSystemLocationLabel() {
            super("");
            this.setPreferredSize(TerminalSize.ONE);
        }

        @Override
        public void onBeforeDrawing() {
            TerminalSize area = this.getSize();
            String absolutePath = FileDialog.this.directory.getAbsolutePath();
            int absolutePathLengthInColumns = TerminalTextUtils.getColumnWidth(absolutePath);
            if (area.getColumns() < absolutePathLengthInColumns) {
                absolutePath = absolutePath.substring(absolutePathLengthInColumns - area.getColumns());
                absolutePath = "..." + absolutePath.substring(Math.min(absolutePathLengthInColumns, 3));
            }
            this.setText(absolutePath);
        }
    }

    private static class DoNothing
    implements Runnable {
        private DoNothing() {
        }

        @Override
        public void run() {
        }
    }

    private class CancelHandler
    implements Runnable {
        private CancelHandler() {
        }

        @Override
        public void run() {
            FileDialog.this.selectedFile = null;
            FileDialog.this.close();
        }
    }

    private class OkHandler
    implements Runnable {
        private OkHandler() {
        }

        @Override
        public void run() {
            if (!FileDialog.this.fileBox.getText().isEmpty()) {
                File file = new File(FileDialog.this.fileBox.getText());
                FileDialog.this.selectedFile = file.isAbsolute() ? file : new File(FileDialog.this.directory, FileDialog.this.fileBox.getText());
                FileDialog.this.close();
            } else {
                MessageDialog.showMessageDialog(FileDialog.this.getTextGUI(), "Error", "Please select a valid file name", MessageDialogButton.OK);
            }
        }
    }
}

