/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.ActionListBox;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

public class DirectoryDialog
extends DialogWindow {
    private final ActionListBox dirListBox;
    private final TextBox dirBox;
    private final boolean showHiddenDirs;
    private File directory;
    private File selectedDir = null;

    public DirectoryDialog(String title, String description, String actionLabel, TerminalSize dialogSize, boolean showHiddenDirs, File selectedObject) {
        super(title);
        this.showHiddenDirs = showHiddenDirs;
        if (selectedObject == null || !selectedObject.exists()) {
            selectedObject = new File("").getAbsoluteFile();
        }
        selectedObject = selectedObject.getAbsoluteFile();
        Panel contentPane = new Panel();
        contentPane.setLayoutManager(new BorderLayout());
        Panel dirsPane = new Panel();
        dirsPane.setLayoutManager(new BorderLayout());
        contentPane.addComponent(dirsPane, BorderLayout.Location.CENTER);
        if (description != null) {
            contentPane.addComponent(new Label(description), BorderLayout.Location.TOP);
        }
        int unitHeight = dialogSize.getRows();
        this.dirListBox = new ActionListBox(new TerminalSize(dialogSize.getColumns(), unitHeight));
        dirsPane.addComponent(this.dirListBox.withBorder(Borders.singleLine()), BorderLayout.Location.CENTER);
        this.dirBox = new TextBox(new TerminalSize(dialogSize.getColumns(), 1));
        dirsPane.addComponent(this.dirBox.withBorder(Borders.singleLine()), BorderLayout.Location.BOTTOM);
        Panel panelButtons = new Panel(new GridLayout(2));
        panelButtons.setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.END, GridLayout.Alignment.CENTER, false, false, 2, 1));
        panelButtons.addComponent(new Button(actionLabel, new OkHandler()));
        panelButtons.addComponent(new Button(LocalizedString.Cancel.toString(), new CancelHandler()));
        contentPane.addComponent(panelButtons, BorderLayout.Location.BOTTOM);
        if (selectedObject.isFile()) {
            this.directory = selectedObject.getParentFile();
        } else if (selectedObject.isDirectory()) {
            this.directory = selectedObject;
        }
        this.reloadViews(this.directory);
        this.setComponent(contentPane);
    }

    @Override
    public File showDialog(WindowBasedTextGUI textGUI) {
        this.selectedDir = null;
        super.showDialog(textGUI);
        return this.selectedDir;
    }

    private void reloadViews(File directory) {
        this.dirBox.setText(directory.getAbsolutePath());
        this.dirListBox.clearItems();
        File[] entries = directory.listFiles();
        if (entries == null) {
            return;
        }
        Arrays.sort(entries, Comparator.comparing(o2 -> o2.getName().toLowerCase()));
        if (directory.getAbsoluteFile().getParentFile() != null) {
            this.dirListBox.addItem("..", () -> {
                this.directory = directory.getAbsoluteFile().getParentFile();
                this.reloadViews(directory.getAbsoluteFile().getParentFile());
            });
        } else {
            File[] roots;
            File[] fileArray = roots = File.listRoots();
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File entry = fileArray[i2];
                if (!entry.canRead()) continue;
                this.dirListBox.addItem('[' + entry.getPath() + ']', () -> {
                    this.directory = entry;
                    this.reloadViews(entry);
                });
            }
        }
        for (File entry : entries) {
            if (entry.isHidden() && !this.showHiddenDirs || !entry.isDirectory()) continue;
            this.dirListBox.addItem(entry.getName(), () -> {
                this.directory = entry;
                this.reloadViews(entry);
            });
        }
        if (this.dirListBox.isEmpty()) {
            this.dirListBox.addItem("<empty>", new DoNothing());
        }
    }

    private static class DoNothing
    implements Runnable {
        private DoNothing() {
        }

        @Override
        public void run() {
        }
    }

    private class CancelHandler
    implements Runnable {
        private CancelHandler() {
        }

        @Override
        public void run() {
            DirectoryDialog.this.selectedDir = null;
            DirectoryDialog.this.close();
        }
    }

    private class OkHandler
    implements Runnable {
        private OkHandler() {
        }

        @Override
        public void run() {
            File dir = new File(DirectoryDialog.this.dirBox.getText());
            if (dir.exists() && dir.isDirectory()) {
                DirectoryDialog.this.selectedDir = dir;
                DirectoryDialog.this.close();
            } else {
                MessageDialog.showMessageDialog(DirectoryDialog.this.getTextGUI(), "Error", "Please select a valid directory name", MessageDialogButton.OK);
            }
        }
    }
}

