/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.WindowDecorationRenderer;

public class DefaultWindowDecorationRenderer
implements WindowDecorationRenderer {
    private static final int TITLE_POSITION_WITH_PADDING = 4;
    private static final int TITLE_POSITION_WITHOUT_PADDING = 3;
    private static final TerminalPosition OFFSET = new TerminalPosition(1, 1);

    @Override
    public TextGUIGraphics draw(WindowBasedTextGUI textGUI, TextGUIGraphics graphics, Window window) {
        String title = window.getTitle();
        if (title == null) {
            title = "";
        }
        TerminalSize drawableArea = graphics.getSize();
        ThemeDefinition themeDefinition = window.getTheme().getDefinition(DefaultWindowDecorationRenderer.class);
        char horizontalLine = themeDefinition.getCharacter("HORIZONTAL_LINE", '\u2500');
        char verticalLine = themeDefinition.getCharacter("VERTICAL_LINE", '\u2502');
        char bottomLeftCorner = themeDefinition.getCharacter("BOTTOM_LEFT_CORNER", '\u2514');
        char topLeftCorner = themeDefinition.getCharacter("TOP_LEFT_CORNER", '\u250c');
        char bottomRightCorner = themeDefinition.getCharacter("BOTTOM_RIGHT_CORNER", '\u2518');
        char topRightCorner = themeDefinition.getCharacter("TOP_RIGHT_CORNER", '\u2510');
        char titleSeparatorLeft = themeDefinition.getCharacter("TITLE_SEPARATOR_LEFT", '\u2500');
        char titleSeparatorRight = themeDefinition.getCharacter("TITLE_SEPARATOR_RIGHT", '\u2500');
        boolean useTitlePadding = themeDefinition.getBooleanProperty("TITLE_PADDING", false);
        boolean centerTitle = themeDefinition.getBooleanProperty("CENTER_TITLE", false);
        int titleHorizontalPosition = useTitlePadding ? 4 : 3;
        int titleMaxColumns = drawableArea.getColumns() - titleHorizontalPosition * 2;
        if (centerTitle) {
            titleHorizontalPosition = drawableArea.getColumns() / 2 - TerminalTextUtils.getColumnWidth(title) / 2;
            titleHorizontalPosition = Math.max(titleHorizontalPosition, useTitlePadding ? 4 : 3);
        }
        String actualTitle = TerminalTextUtils.fitString(title, titleMaxColumns);
        int titleActualColumns = TerminalTextUtils.getColumnWidth(actualTitle);
        if (window.getHints().contains(Window.Hint.MENU_POPUP)) {
            graphics.applyThemeStyle(themeDefinition.getNormal());
        } else {
            graphics.applyThemeStyle(themeDefinition.getPreLight());
        }
        graphics.drawLine(new TerminalPosition(0, drawableArea.getRows() - 2), new TerminalPosition(0, 1), verticalLine);
        graphics.drawLine(new TerminalPosition(1, 0), new TerminalPosition(drawableArea.getColumns() - 2, 0), horizontalLine);
        graphics.setCharacter(0, 0, topLeftCorner);
        graphics.setCharacter(0, drawableArea.getRows() - 1, bottomLeftCorner);
        if (!actualTitle.isEmpty() && drawableArea.getColumns() > 8) {
            int separatorOffset = 1;
            if (useTitlePadding) {
                graphics.setCharacter(titleHorizontalPosition - 1, 0, ' ');
                graphics.setCharacter(titleHorizontalPosition + titleActualColumns, 0, ' ');
                separatorOffset = 2;
            }
            graphics.setCharacter(titleHorizontalPosition - separatorOffset, 0, titleSeparatorLeft);
            graphics.setCharacter(titleHorizontalPosition + titleActualColumns + separatorOffset - 1, 0, titleSeparatorRight);
        }
        graphics.applyThemeStyle(themeDefinition.getNormal());
        graphics.drawLine(new TerminalPosition(drawableArea.getColumns() - 1, 1), new TerminalPosition(drawableArea.getColumns() - 1, drawableArea.getRows() - 2), verticalLine);
        graphics.drawLine(new TerminalPosition(1, drawableArea.getRows() - 1), new TerminalPosition(drawableArea.getColumns() - 2, drawableArea.getRows() - 1), horizontalLine);
        graphics.setCharacter(drawableArea.getColumns() - 1, 0, topRightCorner);
        graphics.setCharacter(drawableArea.getColumns() - 1, drawableArea.getRows() - 1, bottomRightCorner);
        if (!actualTitle.isEmpty()) {
            if (textGUI.getActiveWindow() == window) {
                graphics.applyThemeStyle(themeDefinition.getActive());
            } else {
                graphics.applyThemeStyle(themeDefinition.getInsensitive());
            }
            graphics.putString(titleHorizontalPosition, 0, actualTitle);
        }
        return graphics.newTextGraphics(new TerminalPosition(1, 1), drawableArea.withRelativeColumns(-Math.min(2, drawableArea.getColumns())).withRelativeRows(-Math.min(2, drawableArea.getRows())));
    }

    @Override
    public TerminalSize getDecoratedSize(Window window, TerminalSize contentAreaSize) {
        ThemeDefinition themeDefinition = window.getTheme().getDefinition(DefaultWindowDecorationRenderer.class);
        boolean useTitlePadding = themeDefinition.getBooleanProperty("TITLE_PADDING", false);
        int titleWidth = TerminalTextUtils.getColumnWidth(window.getTitle());
        int minPadding = 6;
        if (useTitlePadding) {
            minPadding = 8;
        }
        return contentAreaSize.withRelativeColumns(2).withRelativeRows(2).max(new TerminalSize(titleWidth + minPadding, 1));
    }

    @Override
    public TerminalPosition getOffset(Window window) {
        return OFFSET;
    }
}

