/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.StyleSet;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.graphics.TextImage;
import com.googlecode.lanterna.graphics.ThemeStyle;
import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.screen.TabBehaviour;
import java.util.Collection;
import java.util.EnumSet;

public class DefaultTextGUIGraphics
implements TextGUIGraphics {
    private final TextGUI textGUI;
    private final TextGraphics backend;

    DefaultTextGUIGraphics(TextGUI textGUI, TextGraphics backend) {
        this.backend = backend;
        this.textGUI = textGUI;
    }

    @Override
    public TextGUI getTextGUI() {
        return this.textGUI;
    }

    @Override
    public DefaultTextGUIGraphics newTextGraphics(TerminalPosition topLeftCorner, TerminalSize size) throws IllegalArgumentException {
        return new DefaultTextGUIGraphics(this.textGUI, this.backend.newTextGraphics(topLeftCorner, size));
    }

    @Override
    public DefaultTextGUIGraphics applyThemeStyle(ThemeStyle themeStyle) {
        this.setForegroundColor(themeStyle.getForeground());
        this.setBackgroundColor(themeStyle.getBackground());
        this.setModifiers((EnumSet)themeStyle.getSGRs());
        return this;
    }

    @Override
    public TerminalSize getSize() {
        return this.backend.getSize();
    }

    @Override
    public TextColor getBackgroundColor() {
        return this.backend.getBackgroundColor();
    }

    @Override
    public DefaultTextGUIGraphics setBackgroundColor(TextColor backgroundColor) {
        this.backend.setBackgroundColor(backgroundColor);
        return this;
    }

    @Override
    public TextColor getForegroundColor() {
        return this.backend.getForegroundColor();
    }

    @Override
    public DefaultTextGUIGraphics setForegroundColor(TextColor foregroundColor) {
        this.backend.setForegroundColor(foregroundColor);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics enableModifiers(SGR ... modifiers) {
        this.backend.enableModifiers(modifiers);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics disableModifiers(SGR ... modifiers) {
        this.backend.disableModifiers(modifiers);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics setModifiers(EnumSet<SGR> modifiers) {
        this.backend.setModifiers(modifiers);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics clearModifiers() {
        this.backend.clearModifiers();
        return this;
    }

    @Override
    public EnumSet<SGR> getActiveModifiers() {
        return this.backend.getActiveModifiers();
    }

    @Override
    public TabBehaviour getTabBehaviour() {
        return this.backend.getTabBehaviour();
    }

    @Override
    public DefaultTextGUIGraphics setTabBehaviour(TabBehaviour tabBehaviour) {
        this.backend.setTabBehaviour(tabBehaviour);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics fill(char c2) {
        this.backend.fill(c2);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics fillRectangle(TerminalPosition topLeft, TerminalSize size, char character) {
        this.backend.fillRectangle(topLeft, size, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics fillRectangle(TerminalPosition topLeft, TerminalSize size, TextCharacter character) {
        this.backend.fillRectangle(topLeft, size, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawRectangle(TerminalPosition topLeft, TerminalSize size, char character) {
        this.backend.drawRectangle(topLeft, size, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawRectangle(TerminalPosition topLeft, TerminalSize size, TextCharacter character) {
        this.backend.drawRectangle(topLeft, size, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics fillTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, char character) {
        this.backend.fillTriangle(p1, p2, p3, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics fillTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, TextCharacter character) {
        this.backend.fillTriangle(p1, p2, p3, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, char character) {
        this.backend.drawTriangle(p1, p2, p3, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, TextCharacter character) {
        this.backend.drawTriangle(p1, p2, p3, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawLine(TerminalPosition fromPoint, TerminalPosition toPoint, char character) {
        this.backend.drawLine(fromPoint, toPoint, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawLine(TerminalPosition fromPoint, TerminalPosition toPoint, TextCharacter character) {
        this.backend.drawLine(fromPoint, toPoint, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawLine(int fromX, int fromY, int toX, int toY, char character) {
        this.backend.drawLine(fromX, fromY, toX, toY, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawLine(int fromX, int fromY, int toX, int toY, TextCharacter character) {
        this.backend.drawLine(fromX, fromY, toX, toY, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawImage(TerminalPosition topLeft, TextImage image) {
        this.backend.drawImage(topLeft, image);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics drawImage(TerminalPosition topLeft, TextImage image, TerminalPosition sourceImageTopLeft, TerminalSize sourceImageSize) {
        this.backend.drawImage(topLeft, image, sourceImageTopLeft, sourceImageSize);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics setCharacter(TerminalPosition position, char character) {
        this.backend.setCharacter(position, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics setCharacter(TerminalPosition position, TextCharacter character) {
        this.backend.setCharacter(position, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics setCharacter(int column, int row, char character) {
        this.backend.setCharacter(column, row, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics setCharacter(int column, int row, TextCharacter character) {
        this.backend.setCharacter(column, row, character);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics putString(int column, int row, String string) {
        this.backend.putString(column, row, string);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics putString(TerminalPosition position, String string) {
        this.backend.putString(position, string);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics putString(int column, int row, String string, SGR extraModifier, SGR ... optionalExtraModifiers) {
        this.backend.putString(column, row, string, extraModifier, optionalExtraModifiers);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics putString(TerminalPosition position, String string, SGR extraModifier, SGR ... optionalExtraModifiers) {
        this.backend.putString(position, string, extraModifier, optionalExtraModifiers);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics putString(int column, int row, String string, Collection<SGR> extraModifiers) {
        this.backend.putString(column, row, string, extraModifiers);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics putCSIStyledString(int column, int row, String string) {
        this.backend.putCSIStyledString(column, row, string);
        return this;
    }

    @Override
    public DefaultTextGUIGraphics putCSIStyledString(TerminalPosition position, String string) {
        this.backend.putCSIStyledString(position, string);
        return this;
    }

    @Override
    public TextCharacter getCharacter(int column, int row) {
        return this.backend.getCharacter(column, row);
    }

    @Override
    public TextCharacter getCharacter(TerminalPosition position) {
        return this.backend.getCharacter(position);
    }

    @Override
    public DefaultTextGUIGraphics setStyleFrom(StyleSet<?> source2) {
        this.setBackgroundColor(source2.getBackgroundColor());
        this.setForegroundColor(source2.getForegroundColor());
        this.setModifiers((EnumSet)source2.getActiveModifiers());
        return this;
    }
}

