/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.AbstractListBox;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseAction;
import com.googlecode.lanterna.input.MouseActionType;

public class ActionListBox
extends AbstractListBox<Runnable, ActionListBox> {
    public ActionListBox() {
        this(null);
    }

    public ActionListBox(TerminalSize preferredSize) {
        super(preferredSize);
    }

    @Override
    public ActionListBox addItem(Runnable object) {
        return (ActionListBox)super.addItem(object);
    }

    public ActionListBox addItem(final String label, final Runnable action) {
        return this.addItem(new Runnable(){

            @Override
            public void run() {
                action.run();
            }

            public String toString() {
                return label;
            }
        });
    }

    @Override
    public TerminalPosition getCursorLocation() {
        return null;
    }

    @Override
    public Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        if (this.isKeyboardActivationStroke(keyStroke)) {
            this.runSelectedItem();
            return Interactable.Result.HANDLED;
        }
        if (keyStroke.getKeyType() == KeyType.MouseEvent) {
            int newIndex;
            MouseAction mouseAction = (MouseAction)keyStroke;
            MouseActionType actionType = mouseAction.getActionType();
            if (this.isMouseMove(keyStroke) || actionType == MouseActionType.CLICK_RELEASE || actionType == MouseActionType.SCROLL_UP || actionType == MouseActionType.SCROLL_DOWN) {
                return super.handleKeyStroke(keyStroke);
            }
            int existingIndex = this.getSelectedIndex();
            if (existingIndex != (newIndex = this.getIndexByMouseAction(mouseAction)) || !this.isFocused() || actionType == MouseActionType.CLICK_DOWN) {
                Interactable.Result result = super.handleKeyStroke(keyStroke);
                this.runSelectedItem();
                return result;
            }
            return Interactable.Result.HANDLED;
        }
        Interactable.Result result = super.handleKeyStroke(keyStroke);
        return result;
    }

    public void runSelectedItem() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            ((Runnable)selectedItem).run();
        }
    }
}

