/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.DefaultMutableThemeStyle;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.graphics.ThemeStyle;
import com.googlecode.lanterna.gui2.AbstractBorder;
import com.googlecode.lanterna.gui2.AbstractListBox;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.CheckBox;
import com.googlecode.lanterna.gui2.CheckBoxList;
import com.googlecode.lanterna.gui2.ComboBox;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.DefaultWindowDecorationRenderer;
import com.googlecode.lanterna.gui2.GUIBackdrop;
import com.googlecode.lanterna.gui2.RadioBoxList;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.WindowDecorationRenderer;
import com.googlecode.lanterna.gui2.WindowPostRenderer;
import com.googlecode.lanterna.gui2.WindowShadowRenderer;
import com.googlecode.lanterna.gui2.table.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SimpleTheme
implements Theme {
    private final Definition defaultDefinition;
    private final Map<Class<?>, Definition> overrideDefinitions;
    private WindowPostRenderer windowPostRenderer;
    private WindowDecorationRenderer windowDecorationRenderer;

    public static SimpleTheme makeTheme(boolean activeIsBold, TextColor baseForeground, TextColor baseBackground, TextColor editableForeground, TextColor editableBackground, TextColor selectedForeground, TextColor selectedBackground, TextColor guiBackground) {
        SGR[] sGRArray;
        if (activeIsBold) {
            SGR[] sGRArray2 = new SGR[1];
            sGRArray = sGRArray2;
            sGRArray2[0] = SGR.BOLD;
        } else {
            sGRArray = new SGR[]{};
        }
        SGR[] activeStyle = sGRArray;
        SimpleTheme theme = new SimpleTheme(baseForeground, baseBackground, new SGR[0]);
        theme.getDefaultDefinition().setSelected(baseBackground, baseForeground, activeStyle);
        theme.getDefaultDefinition().setActive(selectedForeground, selectedBackground, activeStyle);
        theme.addOverride(AbstractBorder.class, baseForeground, baseBackground, new SGR[0]).setSelected(baseForeground, baseBackground, activeStyle);
        theme.addOverride(AbstractListBox.class, baseForeground, baseBackground, new SGR[0]).setSelected(selectedForeground, selectedBackground, activeStyle);
        theme.addOverride(Button.class, baseForeground, baseBackground, new SGR[0]).setActive(selectedForeground, selectedBackground, activeStyle).setSelected(selectedForeground, selectedBackground, activeStyle);
        theme.addOverride(CheckBox.class, baseForeground, baseBackground, new SGR[0]).setActive(selectedForeground, selectedBackground, activeStyle).setPreLight(selectedForeground, selectedBackground, activeStyle).setSelected(selectedForeground, selectedBackground, activeStyle);
        theme.addOverride(CheckBoxList.class, baseForeground, baseBackground, new SGR[0]).setActive(selectedForeground, selectedBackground, activeStyle);
        theme.addOverride(ComboBox.class, baseForeground, baseBackground, new SGR[0]).setActive(editableForeground, editableBackground, activeStyle).setPreLight(editableForeground, editableBackground, new SGR[0]);
        theme.addOverride(DefaultWindowDecorationRenderer.class, baseForeground, baseBackground, new SGR[0]).setActive(baseForeground, baseBackground, activeStyle);
        theme.addOverride(GUIBackdrop.class, baseForeground, guiBackground, new SGR[0]);
        theme.addOverride(RadioBoxList.class, baseForeground, baseBackground, new SGR[0]).setActive(selectedForeground, selectedBackground, activeStyle);
        theme.addOverride(Table.class, baseForeground, baseBackground, new SGR[0]).setActive(editableForeground, editableBackground, activeStyle).setSelected(baseForeground, baseBackground, new SGR[0]);
        theme.addOverride(TextBox.class, editableForeground, editableBackground, new SGR[0]).setActive(editableForeground, editableBackground, activeStyle).setSelected(editableForeground, editableBackground, activeStyle);
        theme.setWindowPostRenderer(new WindowShadowRenderer());
        return theme;
    }

    public SimpleTheme(TextColor foreground, TextColor background, SGR ... styles) {
        this.defaultDefinition = new Definition(new DefaultMutableThemeStyle(foreground, background, styles));
        this.overrideDefinitions = new HashMap();
        this.windowPostRenderer = null;
        this.windowDecorationRenderer = null;
    }

    @Override
    public synchronized Definition getDefaultDefinition() {
        return this.defaultDefinition;
    }

    @Override
    public synchronized Definition getDefinition(Class<?> clazz) {
        Definition definition = this.overrideDefinitions.get(clazz);
        if (definition == null) {
            return this.getDefaultDefinition();
        }
        return definition;
    }

    public synchronized Definition addOverride(Class<?> clazz, TextColor foreground, TextColor background, SGR ... styles) {
        Definition definition = new Definition(new DefaultMutableThemeStyle(foreground, background, styles));
        this.overrideDefinitions.put(clazz, definition);
        return definition;
    }

    @Override
    public synchronized WindowPostRenderer getWindowPostRenderer() {
        return this.windowPostRenderer;
    }

    public synchronized SimpleTheme setWindowPostRenderer(WindowPostRenderer windowPostRenderer) {
        this.windowPostRenderer = windowPostRenderer;
        return this;
    }

    @Override
    public synchronized WindowDecorationRenderer getWindowDecorationRenderer() {
        return this.windowDecorationRenderer;
    }

    public synchronized SimpleTheme setWindowDecorationRenderer(WindowDecorationRenderer windowDecorationRenderer) {
        this.windowDecorationRenderer = windowDecorationRenderer;
        return this;
    }

    public static class Definition
    implements ThemeDefinition {
        private final ThemeStyle normal;
        private ThemeStyle preLight;
        private ThemeStyle selected;
        private ThemeStyle active;
        private ThemeStyle insensitive;
        private final Map<String, ThemeStyle> customStyles;
        private final Properties properties;
        private final Map<String, Character> characterMap;
        private final Map<Class<?>, RendererProvider<?>> componentRendererMap;
        private boolean cursorVisible;

        private Definition(ThemeStyle normal) {
            this.normal = normal;
            this.preLight = null;
            this.selected = null;
            this.active = null;
            this.insensitive = null;
            this.customStyles = new HashMap<String, ThemeStyle>();
            this.properties = new Properties();
            this.characterMap = new HashMap<String, Character>();
            this.componentRendererMap = new HashMap();
            this.cursorVisible = true;
        }

        @Override
        public synchronized ThemeStyle getNormal() {
            return this.normal;
        }

        @Override
        public synchronized ThemeStyle getPreLight() {
            if (this.preLight == null) {
                return this.normal;
            }
            return this.preLight;
        }

        public synchronized Definition setPreLight(TextColor foreground, TextColor background, SGR ... styles) {
            this.preLight = new DefaultMutableThemeStyle(foreground, background, styles);
            return this;
        }

        @Override
        public synchronized ThemeStyle getSelected() {
            if (this.selected == null) {
                return this.normal;
            }
            return this.selected;
        }

        public synchronized Definition setSelected(TextColor foreground, TextColor background, SGR ... styles) {
            this.selected = new DefaultMutableThemeStyle(foreground, background, styles);
            return this;
        }

        @Override
        public synchronized ThemeStyle getActive() {
            if (this.active == null) {
                return this.normal;
            }
            return this.active;
        }

        public synchronized Definition setActive(TextColor foreground, TextColor background, SGR ... styles) {
            this.active = new DefaultMutableThemeStyle(foreground, background, styles);
            return this;
        }

        @Override
        public synchronized ThemeStyle getInsensitive() {
            if (this.insensitive == null) {
                return this.normal;
            }
            return this.insensitive;
        }

        public synchronized Definition setInsensitive(TextColor foreground, TextColor background, SGR ... styles) {
            this.insensitive = new DefaultMutableThemeStyle(foreground, background, styles);
            return this;
        }

        @Override
        public synchronized ThemeStyle getCustom(String name) {
            return this.customStyles.get(name);
        }

        @Override
        public synchronized ThemeStyle getCustom(String name, ThemeStyle defaultValue) {
            ThemeStyle themeStyle = this.customStyles.get(name);
            if (themeStyle == null) {
                return defaultValue;
            }
            return themeStyle;
        }

        public synchronized Definition setCustom(String name, TextColor foreground, TextColor background, SGR ... styles) {
            this.customStyles.put(name, new DefaultMutableThemeStyle(foreground, background, styles));
            return this;
        }

        @Override
        public synchronized boolean getBooleanProperty(String name, boolean defaultValue) {
            return Boolean.parseBoolean(this.properties.getProperty(name, Boolean.toString(defaultValue)));
        }

        public synchronized Definition setBooleanProperty(String name, boolean value) {
            this.properties.setProperty(name, Boolean.toString(value));
            return this;
        }

        @Override
        public synchronized boolean isCursorVisible() {
            return this.cursorVisible;
        }

        public synchronized Definition setCursorVisible(boolean cursorVisible) {
            this.cursorVisible = cursorVisible;
            return this;
        }

        @Override
        public synchronized char getCharacter(String name, char fallback) {
            Character character = this.characterMap.get(name);
            if (character == null) {
                return fallback;
            }
            return character.charValue();
        }

        public synchronized Definition setCharacter(String name, char character) {
            this.characterMap.put(name, Character.valueOf(character));
            return this;
        }

        @Override
        public synchronized <T extends Component> ComponentRenderer<T> getRenderer(Class<T> type) {
            RendererProvider<?> rendererProvider = this.componentRendererMap.get(type);
            if (rendererProvider == null) {
                return null;
            }
            return rendererProvider.getRenderer(type);
        }

        public synchronized <T extends Component> Definition setRenderer(Class<T> type, RendererProvider<T> rendererProvider) {
            if (rendererProvider == null) {
                this.componentRendererMap.remove(type);
            } else {
                this.componentRendererMap.put(type, rendererProvider);
            }
            return this;
        }
    }

    public static interface RendererProvider<T extends Component> {
        public ComponentRenderer<T> getRenderer(Class<T> var1);
    }
}

