/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.ShapeRenderer;
import java.util.Arrays;
import java.util.Comparator;

class DefaultShapeRenderer
implements ShapeRenderer {
    private final Callback callback;

    DefaultShapeRenderer(Callback callback) {
        this.callback = callback;
    }

    @Override
    public void drawLine(TerminalPosition p1, TerminalPosition p2, TextCharacter character) {
        if (p1.getRow() > p2.getRow()) {
            TerminalPosition temp = p1;
            p1 = p2;
            p2 = temp;
        }
        int deltaX = p2.getColumn() - p1.getColumn();
        int deltaY = p2.getRow() - p1.getRow();
        if (deltaX > 0) {
            if (deltaX > deltaY) {
                this.drawLine0(p1, deltaX, deltaY, true, character);
            } else {
                this.drawLine1(p1, deltaX, deltaY, true, character);
            }
        } else if ((deltaX = Math.abs(deltaX)) > deltaY) {
            this.drawLine0(p1, deltaX, deltaY, false, character);
        } else {
            this.drawLine1(p1, deltaX, deltaY, false, character);
        }
    }

    private void drawLine0(TerminalPosition start, int deltaX, int deltaY, boolean leftToRight, TextCharacter character) {
        int x2 = start.getColumn();
        int y2 = start.getRow();
        int deltaYx2 = deltaY * 2;
        int deltaYx2MinusDeltaXx2 = deltaYx2 - deltaX * 2;
        int errorTerm = deltaYx2 - deltaX;
        this.callback.onPoint(x2, y2, character);
        while (deltaX-- > 0) {
            if (errorTerm >= 0) {
                ++y2;
                errorTerm += deltaYx2MinusDeltaXx2;
            } else {
                errorTerm += deltaYx2;
            }
            this.callback.onPoint(x2 += leftToRight ? 1 : -1, y2, character);
        }
    }

    private void drawLine1(TerminalPosition start, int deltaX, int deltaY, boolean leftToRight, TextCharacter character) {
        int x2 = start.getColumn();
        int y2 = start.getRow();
        int deltaXx2 = deltaX * 2;
        int deltaXx2MinusDeltaYx2 = deltaXx2 - deltaY * 2;
        int errorTerm = deltaXx2 - deltaY;
        this.callback.onPoint(x2, y2, character);
        while (deltaY-- > 0) {
            if (errorTerm >= 0) {
                x2 += leftToRight ? 1 : -1;
                errorTerm += deltaXx2MinusDeltaYx2;
            } else {
                errorTerm += deltaXx2;
            }
            this.callback.onPoint(x2, ++y2, character);
        }
    }

    @Override
    public void drawTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, TextCharacter character) {
        this.drawLine(p1, p2, character);
        this.drawLine(p2, p3, character);
        this.drawLine(p3, p1, character);
    }

    @Override
    public void drawRectangle(TerminalPosition topLeft, TerminalSize size, TextCharacter character) {
        TerminalPosition topRight = topLeft.withRelativeColumn(size.getColumns() - 1);
        TerminalPosition bottomRight = topRight.withRelativeRow(size.getRows() - 1);
        TerminalPosition bottomLeft = topLeft.withRelativeRow(size.getRows() - 1);
        this.drawLine(topLeft, topRight, character);
        this.drawLine(topRight, bottomRight, character);
        this.drawLine(bottomRight, bottomLeft, character);
        this.drawLine(bottomLeft, topLeft, character);
    }

    @Override
    public void fillTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, TextCharacter character) {
        float endX;
        TerminalPosition[] points = new TerminalPosition[]{p1, p2, p3};
        Arrays.sort(points, Comparator.comparingInt(TerminalPosition::getRow));
        float dx1 = points[1].getRow() - points[0].getRow() > 0 ? (float)(points[1].getColumn() - points[0].getColumn()) / (float)(points[1].getRow() - points[0].getRow()) : 0.0f;
        float dx2 = points[2].getRow() - points[0].getRow() > 0 ? (float)(points[2].getColumn() - points[0].getColumn()) / (float)(points[2].getRow() - points[0].getRow()) : 0.0f;
        float dx3 = points[2].getRow() - points[1].getRow() > 0 ? (float)(points[2].getColumn() - points[1].getColumn()) / (float)(points[2].getRow() - points[1].getRow()) : 0.0f;
        float startX = endX = (float)points[0].getColumn();
        float startY = points[0].getRow();
        if (dx1 > dx2) {
            while (startY <= (float)points[1].getRow()) {
                this.drawLine(new TerminalPosition((int)startX, (int)startY), new TerminalPosition((int)endX, (int)startY), character);
                startY += 1.0f;
                startX += dx2;
                endX += dx1;
            }
            endX = points[1].getColumn();
            while (startY <= (float)points[2].getRow()) {
                this.drawLine(new TerminalPosition((int)startX, (int)startY), new TerminalPosition((int)endX, (int)startY), character);
                startY += 1.0f;
                startX += dx2;
                endX += dx3;
            }
        } else {
            while (startY <= (float)points[1].getRow()) {
                this.drawLine(new TerminalPosition((int)startX, (int)startY), new TerminalPosition((int)endX, (int)startY), character);
                startY += 1.0f;
                startX += dx1;
                endX += dx2;
            }
            startX = points[1].getColumn();
            startY = points[1].getRow();
            while (startY <= (float)points[2].getRow()) {
                this.drawLine(new TerminalPosition((int)startX, (int)startY), new TerminalPosition((int)endX, (int)startY), character);
                startY += 1.0f;
                startX += dx3;
                endX += dx2;
            }
        }
    }

    @Override
    public void fillRectangle(TerminalPosition topLeft, TerminalSize size, TextCharacter character) {
        boolean characterDoubleWidth = character.isDoubleWidth();
        for (int y2 = 0; y2 < size.getRows(); ++y2) {
            for (int x2 = 0; x2 < size.getColumns(); ++x2) {
                if (characterDoubleWidth && x2 + 1 == size.getColumns()) {
                    this.callback.onPoint(topLeft.getColumn() + x2, topLeft.getRow() + y2, character.withCharacter(' '));
                } else {
                    this.callback.onPoint(topLeft.getColumn() + x2, topLeft.getRow() + y2, character);
                }
                if (!characterDoubleWidth) continue;
                ++x2;
            }
        }
    }

    static interface Callback {
        public void onPoint(int var1, int var2, TextCharacter var3);
    }
}

