/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.StyleSet;
import com.googlecode.lanterna.screen.TabBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class TerminalTextUtils {
    private TerminalTextUtils() {
    }

    public static String getANSIControlSequenceAt(String string, int index) {
        int len = TerminalTextUtils.getANSIControlSequenceLength(string, index);
        return len == 0 ? null : string.substring(index, index + len);
    }

    public static int getANSIControlSequenceLength(String string, int index) {
        int len = 0;
        int restlen = string.length() - index;
        if (restlen >= 3) {
            char esc = string.charAt(index);
            char bracket = string.charAt(index + 1);
            if (esc == '\u001b' && bracket == '[') {
                char ch2;
                len = 3;
                for (int i2 = 2; i2 < restlen && ((ch2 = string.charAt(i2 + index)) >= '0' && ch2 <= '9' || ch2 == ';'); ++i2) {
                    ++len;
                }
                if (len > restlen) {
                    len = 0;
                }
            }
        }
        return len;
    }

    public static boolean isCharCJK(char c2) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
        return unicodeBlock == Character.UnicodeBlock.HIRAGANA || unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS || unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS && c2 < '\uff61';
    }

    public static boolean isCharThai(char c2) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
        return unicodeBlock == Character.UnicodeBlock.THAI;
    }

    public static boolean isCharDoubleWidth(char c2) {
        return TerminalTextUtils.isCharCJK(c2);
    }

    public static boolean isControlCharacter(char c2) {
        return c2 < ' ' || c2 == '\u007f';
    }

    public static boolean isPrintableCharacter(char c2) {
        return !TerminalTextUtils.isControlCharacter(c2) || c2 == '\t' || c2 == '\n' || c2 == '\b';
    }

    public static int getColumnWidth(String s2) {
        return TerminalTextUtils.getColumnIndex(s2, s2.length());
    }

    public static int getColumnIndex(String s2, int stringCharacterIndex) throws StringIndexOutOfBoundsException {
        return TerminalTextUtils.getColumnIndex(s2, stringCharacterIndex, TabBehaviour.CONVERT_TO_FOUR_SPACES, -1);
    }

    public static int getColumnIndex(String s2, int stringCharacterIndex, TabBehaviour tabBehaviour, int firstCharacterColumnPosition) throws StringIndexOutOfBoundsException {
        int index = 0;
        for (int i2 = 0; i2 < stringCharacterIndex; ++i2) {
            if (s2.charAt(i2) == '\t') {
                index += tabBehaviour.getTabReplacement(firstCharacterColumnPosition).length();
                continue;
            }
            if (TerminalTextUtils.isCharCJK(s2.charAt(i2))) {
                ++index;
            }
            ++index;
        }
        return index;
    }

    public static int getStringCharacterIndex(String s2, int columnIndex) {
        int index = 0;
        for (int counter = 0; counter < columnIndex; ++counter) {
            if (!TerminalTextUtils.isCharCJK(s2.charAt(index++)) || ++counter != columnIndex) continue;
            return index - 1;
        }
        return index;
    }

    public static String fitString(String string, int availableColumnSpace) {
        return TerminalTextUtils.fitString(string, 0, availableColumnSpace);
    }

    public static String fitString(String string, int fromColumn, int availableColumnSpace) {
        int column;
        char c2;
        if (availableColumnSpace <= 0) {
            return "";
        }
        StringBuilder bob = new StringBuilder();
        int index = 0;
        for (column = 0; index < string.length() && column < fromColumn; column += TerminalTextUtils.isCharCJK(c2 = string.charAt(index++)) ? 2 : 1) {
        }
        if (column > fromColumn) {
            bob.append(" ");
            --availableColumnSpace;
        }
        while (availableColumnSpace > 0 && index < string.length()) {
            if ((availableColumnSpace -= TerminalTextUtils.isCharCJK(c2 = string.charAt(index++)) ? 2 : 1) < 0) {
                bob.append(' ');
                continue;
            }
            bob.append(c2);
        }
        return bob.toString();
    }

    public static List<String> getWordWrappedText(int maxWidth, String ... lines) {
        if (maxWidth <= 0) {
            return Arrays.asList(lines);
        }
        ArrayList<String> result = new ArrayList<String>();
        LinkedList<String> linesToBeWrapped = new LinkedList<String>(Arrays.asList(lines));
        while (!linesToBeWrapped.isEmpty()) {
            int characterIndexMax;
            int characterIndex;
            String row = linesToBeWrapped.removeFirst();
            int rowWidth = TerminalTextUtils.getColumnWidth(row);
            if (rowWidth <= maxWidth) {
                result.add(row);
                continue;
            }
            for (characterIndex = characterIndexMax = TerminalTextUtils.getStringCharacterIndex(row, maxWidth); characterIndex >= 0 && !Character.isSpaceChar(row.charAt(characterIndex)) && !TerminalTextUtils.isCharCJK(row.charAt(characterIndex)); --characterIndex) {
            }
            if (characterIndex >= 0 && characterIndex < characterIndexMax && TerminalTextUtils.isCharCJK(row.charAt(characterIndex))) {
                ++characterIndex;
            }
            if (characterIndex < 0) {
                characterIndex = Math.max(characterIndexMax, 1);
                result.add(row.substring(0, characterIndex));
                linesToBeWrapped.addFirst(row.substring(characterIndex));
                continue;
            }
            result.add(row.substring(0, characterIndex));
            for (characterIndex = Math.max(characterIndex, 1); characterIndex < row.length() && Character.isSpaceChar(row.charAt(characterIndex)); ++characterIndex) {
            }
            if (characterIndex >= row.length()) continue;
            linesToBeWrapped.addFirst(row.substring(characterIndex));
        }
        return result;
    }

    private static Integer[] mapCodesToIntegerArray(String[] codes) {
        Integer[] result = new Integer[codes.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            if (codes[i2].isEmpty()) {
                result[i2] = 0;
                continue;
            }
            try {
                result[i2] = Integer.parseInt(codes[i2]);
                continue;
            }
            catch (NumberFormatException ignored) {
                throw new IllegalArgumentException("Unknown CSI code " + codes[i2]);
            }
        }
        return result;
    }

    public static void updateModifiersFromCSICode(String controlSequence, StyleSet<?> target, StyleSet<?> original) {
        char controlCodeType = controlSequence.charAt(controlSequence.length() - 1);
        controlSequence = controlSequence.substring(2, controlSequence.length() - 1);
        Integer[] codes = TerminalTextUtils.mapCodesToIntegerArray(controlSequence.split(";"));
        TextColor.ANSI[] palette = TextColor.ANSI.values();
        if (controlCodeType == 'm') {
            block17: for (int i2 = 0; i2 < codes.length; ++i2) {
                int code = codes[i2];
                switch (code) {
                    case 0: {
                        target.setStyleFrom(original);
                        continue block17;
                    }
                    case 1: {
                        target.enableModifiers(SGR.BOLD);
                        continue block17;
                    }
                    case 3: {
                        target.enableModifiers(SGR.ITALIC);
                        continue block17;
                    }
                    case 4: {
                        target.enableModifiers(SGR.UNDERLINE);
                        continue block17;
                    }
                    case 5: {
                        target.enableModifiers(SGR.BLINK);
                        continue block17;
                    }
                    case 7: {
                        target.enableModifiers(SGR.REVERSE);
                        continue block17;
                    }
                    case 21: 
                    case 22: {
                        target.disableModifiers(SGR.BOLD);
                        continue block17;
                    }
                    case 23: {
                        target.disableModifiers(SGR.ITALIC);
                        continue block17;
                    }
                    case 24: {
                        target.disableModifiers(SGR.UNDERLINE);
                        continue block17;
                    }
                    case 25: {
                        target.disableModifiers(SGR.BLINK);
                        continue block17;
                    }
                    case 27: {
                        target.disableModifiers(SGR.REVERSE);
                        continue block17;
                    }
                    case 38: {
                        if (i2 + 2 < codes.length && codes[i2 + 1] == 5) {
                            target.setForegroundColor(new TextColor.Indexed(codes[i2 + 2]));
                            i2 += 2;
                            continue block17;
                        }
                        if (i2 + 4 >= codes.length || codes[i2 + 1] != 2) continue block17;
                        target.setForegroundColor(new TextColor.RGB(codes[i2 + 2], codes[i2 + 3], codes[i2 + 4]));
                        i2 += 4;
                        continue block17;
                    }
                    case 39: {
                        target.setForegroundColor(original.getForegroundColor());
                        continue block17;
                    }
                    case 48: {
                        if (i2 + 2 < codes.length && codes[i2 + 1] == 5) {
                            target.setBackgroundColor(new TextColor.Indexed(codes[i2 + 2]));
                            i2 += 2;
                            continue block17;
                        }
                        if (i2 + 4 >= codes.length || codes[i2 + 1] != 2) continue block17;
                        target.setBackgroundColor(new TextColor.RGB(codes[i2 + 2], codes[i2 + 3], codes[i2 + 4]));
                        i2 += 4;
                        continue block17;
                    }
                    case 49: {
                        target.setBackgroundColor(original.getBackgroundColor());
                        continue block17;
                    }
                    default: {
                        if (code >= 30 && code <= 37) {
                            target.setForegroundColor(palette[code - 30]);
                            continue block17;
                        }
                        if (code < 40 || code > 47) continue block17;
                        target.setBackgroundColor(palette[code - 40]);
                    }
                }
            }
        }
    }
}

