/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import java.util.Objects;

public class TerminalRectangle {
    public final TerminalPosition position;
    public final TerminalSize size;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final int xAndWidth;
    public final int yAndHeight;

    public TerminalRectangle(int x2, int y2, int width, int height) {
        this.position = new TerminalPosition(x2, y2);
        this.size = new TerminalSize(width, height);
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
        this.xAndWidth = x2 + width;
        this.yAndHeight = y2 + height;
    }

    public int getColumns() {
        return this.width;
    }

    public int getRows() {
        return this.height;
    }

    public TerminalRectangle withColumns(int columns) {
        return new TerminalRectangle(this.x, this.y, columns, this.height);
    }

    public TerminalRectangle withRows(int rows) {
        return new TerminalRectangle(this.x, this.y, this.width, rows);
    }

    public boolean whenContains(TerminalPosition p2, Runnable op) {
        return this.whenContains(p2.getColumn(), p2.getRow(), op);
    }

    public boolean whenContains(int x2, int y2, Runnable op) {
        if (this.x <= x2 && x2 < this.xAndWidth && this.y <= y2 && y2 < this.yAndHeight) {
            op.run();
            return true;
        }
        return false;
    }

    public String toString() {
        return "{x: " + this.x + ", y: " + this.y + ", width: " + this.width + ", height: " + this.height + "}";
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && Objects.equals(this.position, ((TerminalRectangle)obj).position) && Objects.equals(this.size, ((TerminalRectangle)obj).size);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.size);
    }
}

