/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle.prf;

import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.prf.StreamingPrf;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@Immutable
public class HkdfStreamingPrf
implements StreamingPrf {
    private final Enums.HashType hashType;
    private final byte[] ikm;
    private final byte[] salt;

    private static String getJavaxHmacName(Enums.HashType hashType) throws GeneralSecurityException {
        switch (hashType) {
            case SHA1: {
                return "HmacSha1";
            }
            case SHA256: {
                return "HmacSha256";
            }
            case SHA384: {
                return "HmacSha384";
            }
            case SHA512: {
                return "HmacSha512";
            }
        }
        throw new GeneralSecurityException("No getJavaxHmacName for given hash " + (Object)((Object)hashType) + " known");
    }

    public HkdfStreamingPrf(Enums.HashType hashType, byte[] ikm, byte[] salt) {
        this.hashType = hashType;
        this.ikm = Arrays.copyOf(ikm, ikm.length);
        this.salt = Arrays.copyOf(salt, salt.length);
    }

    @Override
    public InputStream computePrf(byte[] input) {
        return new HkdfInputStream(input);
    }

    private class HkdfInputStream
    extends InputStream {
        private final byte[] input;
        private Mac mac;
        private byte[] prk;
        private ByteBuffer buffer;
        private int ctr = -1;

        public HkdfInputStream(byte[] input) {
            this.input = Arrays.copyOf(input, input.length);
        }

        private void initialize() throws GeneralSecurityException, IOException {
            try {
                this.mac = EngineFactory.MAC.getInstance(HkdfStreamingPrf.getJavaxHmacName(HkdfStreamingPrf.this.hashType));
            }
            catch (GeneralSecurityException e2) {
                throw new IOException("Creating HMac failed", e2);
            }
            if (HkdfStreamingPrf.this.salt == null || HkdfStreamingPrf.this.salt.length == 0) {
                this.mac.init(new SecretKeySpec(new byte[this.mac.getMacLength()], HkdfStreamingPrf.getJavaxHmacName(HkdfStreamingPrf.this.hashType)));
            } else {
                this.mac.init(new SecretKeySpec(HkdfStreamingPrf.this.salt, HkdfStreamingPrf.getJavaxHmacName(HkdfStreamingPrf.this.hashType)));
            }
            this.mac.update(HkdfStreamingPrf.this.ikm);
            this.prk = this.mac.doFinal();
            this.buffer = ByteBuffer.allocateDirect(0);
            this.buffer.mark();
            this.ctr = 0;
        }

        private void updateBuffer() throws GeneralSecurityException, IOException {
            this.mac.init(new SecretKeySpec(this.prk, HkdfStreamingPrf.getJavaxHmacName(HkdfStreamingPrf.this.hashType)));
            this.buffer.reset();
            this.mac.update(this.buffer);
            this.mac.update(this.input);
            ++this.ctr;
            this.mac.update((byte)this.ctr);
            this.buffer = ByteBuffer.wrap(this.mac.doFinal());
            this.buffer.mark();
        }

        @Override
        public int read() throws IOException {
            byte[] oneByte = new byte[1];
            int ret = this.read(oneByte, 0, 1);
            if (ret == 1) {
                return oneByte[0] & 0xFF;
            }
            if (ret == -1) {
                return ret;
            }
            throw new IOException("Reading failed");
        }

        @Override
        public int read(byte[] dst) throws IOException {
            return this.read(dst, 0, dst.length);
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            int totalRead = 0;
            try {
                if (this.ctr == -1) {
                    this.initialize();
                }
                while (totalRead < len) {
                    if (!this.buffer.hasRemaining()) {
                        if (this.ctr == 255) {
                            return totalRead;
                        }
                        this.updateBuffer();
                    }
                    int toRead = Math.min(len - totalRead, this.buffer.remaining());
                    this.buffer.get(b2, off, toRead);
                    off += toRead;
                    totalRead += toRead;
                }
            }
            catch (GeneralSecurityException e2) {
                this.mac = null;
                throw new IOException("HkdfInputStream failed", e2);
            }
            return totalRead;
        }
    }
}

