/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.Validators;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;

public class SubtleUtil {
    public static String toEcdsaAlgo(Enums.HashType hash) throws GeneralSecurityException {
        Validators.validateSignatureHash(hash);
        return (Object)((Object)hash) + "withECDSA";
    }

    public static String toRsaSsaPkcs1Algo(Enums.HashType hash) throws GeneralSecurityException {
        Validators.validateSignatureHash(hash);
        return (Object)((Object)hash) + "withRSA";
    }

    public static String toDigestAlgo(Enums.HashType hash) throws GeneralSecurityException {
        switch (hash) {
            case SHA1: {
                return "SHA-1";
            }
            case SHA256: {
                return "SHA-256";
            }
            case SHA384: {
                return "SHA-384";
            }
            case SHA512: {
                return "SHA-512";
            }
        }
        throw new GeneralSecurityException("Unsupported hash " + (Object)((Object)hash));
    }

    public static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, null);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static int androidApiLevel() {
        try {
            Class<?> buildVersion = Class.forName("android.os.Build$VERSION");
            return buildVersion.getDeclaredField("SDK_INT").getInt(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e2) {
            return -1;
        }
    }

    public static BigInteger bytes2Integer(byte[] bs2) {
        return new BigInteger(1, bs2);
    }

    public static byte[] integer2Bytes(BigInteger num, int intendedLength) throws GeneralSecurityException {
        byte[] b2 = num.toByteArray();
        if (b2.length == intendedLength) {
            return b2;
        }
        if (b2.length > intendedLength + 1) {
            throw new GeneralSecurityException("integer too large");
        }
        if (b2.length == intendedLength + 1) {
            if (b2[0] == 0) {
                return Arrays.copyOfRange(b2, 1, b2.length);
            }
            throw new GeneralSecurityException("integer too large");
        }
        byte[] res = new byte[intendedLength];
        System.arraycopy(b2, 0, res, intendedLength - b2.length, b2.length);
        return res;
    }

    public static byte[] mgf1(byte[] mgfSeed, int maskLen, Enums.HashType mgfHash) throws GeneralSecurityException {
        MessageDigest digest = EngineFactory.MESSAGE_DIGEST.getInstance(SubtleUtil.toDigestAlgo(mgfHash));
        int hLen = digest.getDigestLength();
        byte[] t2 = new byte[maskLen];
        int tPos = 0;
        for (int counter = 0; counter <= (maskLen - 1) / hLen; ++counter) {
            digest.reset();
            digest.update(mgfSeed);
            digest.update(SubtleUtil.integer2Bytes(BigInteger.valueOf(counter), 4));
            byte[] c2 = digest.digest();
            System.arraycopy(c2, 0, t2, tPos, Math.min(c2.length, t2.length - tPos));
            tPos += c2.length;
        }
        return t2;
    }

    public static void putAsUnsigedInt(ByteBuffer buffer, long value) throws GeneralSecurityException {
        if (0L > value || value >= 0x100000000L) {
            throw new GeneralSecurityException("Index out of range");
        }
        buffer.putInt((int)value);
    }
}

