/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.prf.Prf;
import com.google.crypto.tink.subtle.AesUtil;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Validators;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@Immutable
public final class PrfAesCmac
implements Prf {
    private final SecretKey keySpec;
    private byte[] subKey1;
    private byte[] subKey2;

    private static Cipher instance() throws GeneralSecurityException {
        return EngineFactory.CIPHER.getInstance("AES/ECB/NoPadding");
    }

    public PrfAesCmac(byte[] key) throws GeneralSecurityException {
        Validators.validateAesKeySize(key.length);
        this.keySpec = new SecretKeySpec(key, "AES");
        this.generateSubKeys();
    }

    @Override
    public byte[] compute(byte[] data, int outputLength) throws GeneralSecurityException {
        byte[] y2;
        if (outputLength > 16) {
            throw new InvalidAlgorithmParameterException("outputLength too large, max is 16 bytes");
        }
        Cipher aes = PrfAesCmac.instance();
        aes.init(1, this.keySpec);
        int n2 = Math.max(1, (int)Math.ceil((double)data.length / 16.0));
        boolean flag = n2 * 16 == data.length;
        byte[] mLast = flag ? Bytes.xor(data, (n2 - 1) * 16, this.subKey1, 0, 16) : Bytes.xor(AesUtil.cmacPad(Arrays.copyOfRange(data, (n2 - 1) * 16, data.length)), this.subKey2);
        byte[] x2 = new byte[16];
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            y2 = Bytes.xor(x2, 0, data, i2 * 16, 16);
            x2 = aes.doFinal(y2);
        }
        y2 = Bytes.xor(mLast, x2);
        byte[] output = Arrays.copyOf(aes.doFinal(y2), outputLength);
        return output;
    }

    private void generateSubKeys() throws GeneralSecurityException {
        Cipher aes = PrfAesCmac.instance();
        aes.init(1, this.keySpec);
        byte[] zeroes = new byte[16];
        byte[] l2 = aes.doFinal(zeroes);
        this.subKey1 = AesUtil.dbl(l2);
        this.subKey2 = AesUtil.dbl(this.subKey1);
    }
}

