/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.Ed25519;
import com.google.crypto.tink.subtle.Field25519;
import java.math.BigInteger;

final class Ed25519Constants {
    static final long[] D;
    static final long[] D2;
    static final long[] SQRTM1;
    static final Ed25519.CachedXYT[][] B_TABLE;
    static final Ed25519.CachedXYT[] B2;
    private static final BigInteger P_BI;
    private static final BigInteger D_BI;
    private static final BigInteger D2_BI;
    private static final BigInteger SQRTM1_BI;

    Ed25519Constants() {
    }

    private static BigInteger recoverX(BigInteger y2) {
        BigInteger xx = y2.pow(2).subtract(BigInteger.ONE).multiply(D_BI.multiply(y2.pow(2)).add(BigInteger.ONE).modInverse(P_BI));
        BigInteger x2 = xx.modPow(P_BI.add(BigInteger.valueOf(3L)).divide(BigInteger.valueOf(8L)), P_BI);
        if (!x2.pow(2).subtract(xx).mod(P_BI).equals(BigInteger.ZERO)) {
            x2 = x2.multiply(SQRTM1_BI).mod(P_BI);
        }
        if (x2.testBit(0)) {
            x2 = P_BI.subtract(x2);
        }
        return x2;
    }

    private static Point edwards(Point a2, Point b2) {
        Point o2 = new Point();
        BigInteger xxyy = D_BI.multiply(a2.x.multiply(b2.x).multiply(a2.y).multiply(b2.y)).mod(P_BI);
        o2.x = a2.x.multiply(b2.y).add(b2.x.multiply(a2.y)).multiply(BigInteger.ONE.add(xxyy).modInverse(Ed25519Constants.P_BI)).mod(Ed25519Constants.P_BI);
        o2.y = a2.y.multiply(b2.y).add(a2.x.multiply(b2.x)).multiply(BigInteger.ONE.subtract(xxyy).modInverse(Ed25519Constants.P_BI)).mod(Ed25519Constants.P_BI);
        return o2;
    }

    private static byte[] toLittleEndian(BigInteger n2) {
        byte[] b2 = new byte[32];
        byte[] nBytes = n2.toByteArray();
        System.arraycopy(nBytes, 0, b2, 32 - nBytes.length, nBytes.length);
        for (int i2 = 0; i2 < b2.length / 2; ++i2) {
            byte t2 = b2[i2];
            b2[i2] = b2[b2.length - i2 - 1];
            b2[b2.length - i2 - 1] = t2;
        }
        return b2;
    }

    private static Ed25519.CachedXYT getCachedXYT(Point p2) {
        return new Ed25519.CachedXYT(Field25519.expand(Ed25519Constants.toLittleEndian(p2.y.add(p2.x).mod(P_BI))), Field25519.expand(Ed25519Constants.toLittleEndian(p2.y.subtract(p2.x).mod(P_BI))), Field25519.expand(Ed25519Constants.toLittleEndian(D2_BI.multiply(p2.x).multiply(p2.y).mod(P_BI))));
    }

    static {
        P_BI = BigInteger.valueOf(2L).pow(255).subtract(BigInteger.valueOf(19L));
        D_BI = BigInteger.valueOf(-121665L).multiply(BigInteger.valueOf(121666L).modInverse(P_BI)).mod(P_BI);
        D2_BI = BigInteger.valueOf(2L).multiply(D_BI).mod(P_BI);
        SQRTM1_BI = BigInteger.valueOf(2L).modPow(P_BI.subtract(BigInteger.ONE).divide(BigInteger.valueOf(4L)), P_BI);
        Point b2 = new Point();
        b2.y = BigInteger.valueOf(4L).multiply(BigInteger.valueOf(5L).modInverse(Ed25519Constants.P_BI)).mod(Ed25519Constants.P_BI);
        b2.x = Ed25519Constants.recoverX(b2.y);
        D = Field25519.expand(Ed25519Constants.toLittleEndian(D_BI));
        D2 = Field25519.expand(Ed25519Constants.toLittleEndian(D2_BI));
        SQRTM1 = Field25519.expand(Ed25519Constants.toLittleEndian(SQRTM1_BI));
        Point bi2 = b2;
        B_TABLE = new Ed25519.CachedXYT[32][8];
        for (int i2 = 0; i2 < 32; ++i2) {
            int j2;
            Point bij = bi2;
            for (j2 = 0; j2 < 8; ++j2) {
                Ed25519Constants.B_TABLE[i2][j2] = Ed25519Constants.getCachedXYT(bij);
                bij = Ed25519Constants.edwards(bij, bi2);
            }
            for (j2 = 0; j2 < 8; ++j2) {
                bi2 = Ed25519Constants.edwards(bi2, bi2);
            }
        }
        bi2 = b2;
        Point b22 = Ed25519Constants.edwards(b2, b2);
        B2 = new Ed25519.CachedXYT[8];
        for (int i3 = 0; i3 < 8; ++i3) {
            Ed25519Constants.B2[i3] = Ed25519Constants.getCachedXYT(bi2);
            bi2 = Ed25519Constants.edwards(bi2, b22);
        }
    }

    private static class Point {
        private BigInteger x;
        private BigInteger y;

        private Point() {
        }
    }
}

