/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import java.util.Arrays;

class AesUtil {
    public static final int BLOCK_SIZE = 16;

    AesUtil() {
    }

    static byte[] dbl(byte[] value) {
        if (value.length != 16) {
            throw new IllegalArgumentException("value must be a block.");
        }
        byte[] res = new byte[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            res[i2] = (byte)(0xFE & value[i2] << 1);
            if (i2 >= 15) continue;
            int n2 = i2;
            res[n2] = (byte)(res[n2] | (byte)(1 & value[i2 + 1] >> 7));
        }
        res[15] = (byte)(res[15] ^ (byte)(0x87 & value[0] >> 7));
        return res;
    }

    static byte[] cmacPad(byte[] x2) {
        if (x2.length >= 16) {
            throw new IllegalArgumentException("x must be smaller than a block.");
        }
        byte[] result = Arrays.copyOf(x2, 16);
        result[x2.length] = -128;
        return result;
    }
}

