/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesEaxJce
implements Aead {
    private static final ThreadLocal<Cipher> localEcbCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return EngineFactory.CIPHER.getInstance("AES/ECB/NOPADDING");
            }
            catch (GeneralSecurityException ex2) {
                throw new IllegalStateException(ex2);
            }
        }
    };
    private static final ThreadLocal<Cipher> localCtrCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return EngineFactory.CIPHER.getInstance("AES/CTR/NOPADDING");
            }
            catch (GeneralSecurityException ex2) {
                throw new IllegalStateException(ex2);
            }
        }
    };
    static final int BLOCK_SIZE_IN_BYTES = 16;
    static final int TAG_SIZE_IN_BYTES = 16;
    private final byte[] b;
    private final byte[] p;
    private final SecretKeySpec keySpec;
    private final int ivSizeInBytes;

    public AesEaxJce(byte[] key, int ivSizeInBytes) throws GeneralSecurityException {
        if (ivSizeInBytes != 12 && ivSizeInBytes != 16) {
            throw new IllegalArgumentException("IV size should be either 12 or 16 bytes");
        }
        this.ivSizeInBytes = ivSizeInBytes;
        Validators.validateAesKeySize(key.length);
        this.keySpec = new SecretKeySpec(key, "AES");
        Cipher ecb = localEcbCipher.get();
        ecb.init(1, this.keySpec);
        byte[] block = ecb.doFinal(new byte[16]);
        this.b = AesEaxJce.multiplyByX(block);
        this.p = AesEaxJce.multiplyByX(this.b);
    }

    private static byte[] xor(byte[] x2, byte[] y2) {
        assert (x2.length == y2.length);
        int len = x2.length;
        byte[] res = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            res[i2] = (byte)(x2[i2] ^ y2[i2]);
        }
        return res;
    }

    private static byte[] multiplyByX(byte[] block) {
        byte[] res = new byte[16];
        for (int i2 = 0; i2 < 15; ++i2) {
            res[i2] = (byte)((block[i2] << 1 ^ (block[i2 + 1] & 0xFF) >>> 7) & 0xFF);
        }
        res[15] = (byte)(block[15] << 1 ^ ((block[0] & 0x80) == 0 ? 0 : 135));
        return res;
    }

    private byte[] pad(byte[] data) {
        if (data.length == 16) {
            return AesEaxJce.xor(data, this.b);
        }
        byte[] res = Arrays.copyOf(this.p, 16);
        for (int i2 = 0; i2 < data.length; ++i2) {
            int n2 = i2;
            res[n2] = (byte)(res[n2] ^ data[i2]);
        }
        res[data.length] = (byte)(res[data.length] ^ 0x80);
        return res;
    }

    private byte[] omac(Cipher ecb, int tag, byte[] data, int offset, int length) throws IllegalBlockSizeException, BadPaddingException {
        assert (length >= 0);
        assert (0 <= tag && tag <= 3);
        byte[] block = new byte[16];
        block[15] = (byte)tag;
        if (length == 0) {
            return ecb.doFinal(AesEaxJce.xor(block, this.b));
        }
        block = ecb.doFinal(block);
        int position = 0;
        while (length - position > 16) {
            for (int i2 = 0; i2 < 16; ++i2) {
                int n2 = i2;
                block[n2] = (byte)(block[n2] ^ data[offset + position + i2]);
            }
            block = ecb.doFinal(block);
            position += 16;
        }
        byte[] padded = this.pad(Arrays.copyOfRange(data, offset + position, offset + length));
        block = AesEaxJce.xor(block, padded);
        return ecb.doFinal(block);
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        if (plaintext.length > Integer.MAX_VALUE - this.ivSizeInBytes - 16) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] ciphertext = new byte[this.ivSizeInBytes + plaintext.length + 16];
        byte[] iv2 = Random.randBytes(this.ivSizeInBytes);
        System.arraycopy(iv2, 0, ciphertext, 0, this.ivSizeInBytes);
        Cipher ecb = localEcbCipher.get();
        ecb.init(1, this.keySpec);
        byte[] n2 = this.omac(ecb, 0, iv2, 0, iv2.length);
        byte[] aad = associatedData;
        if (aad == null) {
            aad = new byte[]{};
        }
        byte[] h2 = this.omac(ecb, 1, aad, 0, aad.length);
        Cipher ctr = localCtrCipher.get();
        ctr.init(1, (Key)this.keySpec, new IvParameterSpec(n2));
        ctr.doFinal(plaintext, 0, plaintext.length, ciphertext, this.ivSizeInBytes);
        byte[] t2 = this.omac(ecb, 2, ciphertext, this.ivSizeInBytes, plaintext.length);
        int offset = plaintext.length + this.ivSizeInBytes;
        for (int i2 = 0; i2 < 16; ++i2) {
            ciphertext[offset + i2] = (byte)(h2[i2] ^ n2[i2] ^ t2[i2]);
        }
        return ciphertext;
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        int plaintextLength = ciphertext.length - this.ivSizeInBytes - 16;
        if (plaintextLength < 0) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        Cipher ecb = localEcbCipher.get();
        ecb.init(1, this.keySpec);
        byte[] n2 = this.omac(ecb, 0, ciphertext, 0, this.ivSizeInBytes);
        byte[] aad = associatedData;
        if (aad == null) {
            aad = new byte[]{};
        }
        byte[] h2 = this.omac(ecb, 1, aad, 0, aad.length);
        byte[] t2 = this.omac(ecb, 2, ciphertext, this.ivSizeInBytes, plaintextLength);
        int res = 0;
        int offset = ciphertext.length - 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            res = (byte)(res | ciphertext[offset + i2] ^ h2[i2] ^ n2[i2] ^ t2[i2]);
        }
        if (res != 0) {
            throw new AEADBadTagException("tag mismatch");
        }
        Cipher ctr = localCtrCipher.get();
        ctr.init(1, (Key)this.keySpec, new IvParameterSpec(n2));
        return ctr.doFinal(ciphertext, this.ivSizeInBytes, plaintextLength);
    }
}

