/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

class JavaScanner {
    private final String s;

    JavaScanner(String s2) {
        this.s = s2.endsWith("\n") ? s2 : s2 + '\n';
    }

    String string() {
        return this.s;
    }

    int tokenEnd(int start) {
        if (start >= this.s.length()) {
            return this.s.length();
        }
        switch (this.s.charAt(start)) {
            case '\n': 
            case ' ': {
                return this.spaceEnd(start);
            }
            case '/': {
                if (this.s.charAt(start + 1) == '*') {
                    return this.blockCommentEnd(start);
                }
                if (this.s.charAt(start + 1) == '/') {
                    return this.lineCommentEnd(start);
                }
                return start + 1;
            }
            case '\"': 
            case '\'': 
            case '`': {
                return this.quoteEnd(start);
            }
        }
        return start + 1;
    }

    private int spaceEnd(int start) {
        int i2;
        assert (this.s.charAt(start) == ' ' || this.s.charAt(start) == '\n');
        for (i2 = start + 1; i2 < this.s.length() && this.s.charAt(i2) == ' '; ++i2) {
        }
        return i2;
    }

    private int blockCommentEnd(int start) {
        assert (this.s.charAt(start) == '/' && this.s.charAt(start + 1) == '*');
        int i2 = start + 2;
        while (this.s.charAt(i2) != '*' || this.s.charAt(i2 + 1) != '/') {
            ++i2;
        }
        return i2 + 2;
    }

    private int lineCommentEnd(int start) {
        assert (this.s.charAt(start) == '/' && this.s.charAt(start + 1) == '/');
        int end = this.s.indexOf(10, start + 2);
        assert (end > 0);
        return end;
    }

    private int quoteEnd(int start) {
        char quote = this.s.charAt(start);
        assert (quote == '\'' || quote == '\"' || quote == '`');
        int i2 = start + 1;
        while (this.s.charAt(i2) != quote) {
            if (this.s.charAt(i2) == '\\') {
                ++i2;
            }
            ++i2;
        }
        return i2 + 1;
    }
}

