/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import com.google.auto.value.processor.TypeEncoder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.tools.Diagnostic;

final class AnnotationOutput {
    private AnnotationOutput() {
    }

    static String sourceFormForInitializer(AnnotationValue annotationValue, ProcessingEnvironment processingEnv, String memberName, Element context) {
        InitializerSourceFormVisitor visitor = new InitializerSourceFormVisitor(processingEnv, memberName, context);
        StringBuilder sb = new StringBuilder();
        visitor.visit(annotationValue, sb);
        return sb.toString();
    }

    static String sourceFormForAnnotation(AnnotationMirror annotationMirror) {
        StringBuilder sb = new StringBuilder();
        new AnnotationSourceFormVisitor().visitAnnotation(annotationMirror, sb);
        return sb.toString();
    }

    private static StringBuilder appendQuoted(StringBuilder sb, String s2) {
        sb.append('\"');
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            AnnotationOutput.appendEscaped(sb, s2.charAt(i2));
        }
        return sb.append('\"');
    }

    private static StringBuilder appendQuoted(StringBuilder sb, char c2) {
        sb.append('\'');
        AnnotationOutput.appendEscaped(sb, c2);
        return sb.append('\'');
    }

    private static void appendEscaped(StringBuilder sb, char c2) {
        switch (c2) {
            case '\"': 
            case '\'': 
            case '\\': {
                sb.append('\\').append(c2);
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            default: {
                if (c2 < ' ') {
                    sb.append(String.format("\\%03o", c2));
                    break;
                }
                if (c2 < '\u007f' || Character.isLetter(c2)) {
                    sb.append(c2);
                    break;
                }
                sb.append(String.format("\\u%04x", c2));
            }
        }
    }

    private static class AnnotationSourceFormVisitor
    extends SourceFormVisitor {
        private AnnotationSourceFormVisitor() {
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> values2, StringBuilder sb) {
            if (values2.size() == 1) {
                this.visit(values2.get(0), sb);
                return null;
            }
            return super.visitArray(values2, sb);
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a2, StringBuilder sb) {
            sb.append('@').append(TypeEncoder.encode(a2.getAnnotationType()));
            $ImmutableMap<ExecutableElement, AnnotationValue> map = $ImmutableMap.copyOf(a2.getElementValues());
            if (!map.isEmpty()) {
                sb.append('(');
                Optional<AnnotationValue> shortForm = AnnotationSourceFormVisitor.shortForm(map);
                if (shortForm.isPresent()) {
                    this.visit(shortForm.get(), sb);
                } else {
                    String sep = "";
                    for (Map.Entry entry : map.entrySet()) {
                        sb.append(sep).append(((ExecutableElement)entry.getKey()).getSimpleName()).append(" = ");
                        sep = ", ";
                        this.visit((AnnotationValue)entry.getValue(), sb);
                    }
                }
                sb.append(')');
            }
            return null;
        }

        private static Optional<AnnotationValue> shortForm(Map<ExecutableElement, AnnotationValue> values2) {
            if (values2.size() == 1 && $Iterables.getOnlyElement(values2.keySet()).getSimpleName().contentEquals("value")) {
                return Optional.of($Iterables.getOnlyElement(values2.values()));
            }
            return Optional.empty();
        }
    }

    private static class InitializerSourceFormVisitor
    extends SourceFormVisitor {
        private final ProcessingEnvironment processingEnv;
        private final String memberName;
        private final Element context;

        InitializerSourceFormVisitor(ProcessingEnvironment processingEnv, String memberName, Element context) {
            this.processingEnv = processingEnv;
            this.memberName = memberName;
            this.context = context;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a2, StringBuilder sb) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@AutoAnnotation cannot yet supply a default value for annotation-valued member '" + this.memberName + "'", this.context);
            sb.append("null");
            return null;
        }
    }

    private static abstract class SourceFormVisitor
    extends SimpleAnnotationValueVisitor8<Void, StringBuilder> {
        private SourceFormVisitor() {
        }

        @Override
        protected Void defaultAction(Object value, StringBuilder sb) {
            sb.append(value);
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> values2, StringBuilder sb) {
            sb.append('{');
            String sep = "";
            for (AnnotationValue annotationValue : values2) {
                sb.append(sep);
                this.visit(annotationValue, sb);
                sep = ", ";
            }
            sb.append('}');
            return null;
        }

        @Override
        public Void visitChar(char c2, StringBuilder sb) {
            AnnotationOutput.appendQuoted(sb, c2);
            return null;
        }

        @Override
        public Void visitLong(long i2, StringBuilder sb) {
            sb.append(i2).append('L');
            return null;
        }

        @Override
        public Void visitDouble(double d2, StringBuilder sb) {
            if (Double.isNaN(d2)) {
                sb.append("Double.NaN");
            } else if (d2 == Double.POSITIVE_INFINITY) {
                sb.append("Double.POSITIVE_INFINITY");
            } else if (d2 == Double.NEGATIVE_INFINITY) {
                sb.append("Double.NEGATIVE_INFINITY");
            } else {
                sb.append(d2);
            }
            return null;
        }

        @Override
        public Void visitFloat(float f2, StringBuilder sb) {
            if (Float.isNaN(f2)) {
                sb.append("Float.NaN");
            } else if (f2 == Float.POSITIVE_INFINITY) {
                sb.append("Float.POSITIVE_INFINITY");
            } else if (f2 == Float.NEGATIVE_INFINITY) {
                sb.append("Float.NEGATIVE_INFINITY");
            } else {
                sb.append(f2).append('F');
            }
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement c2, StringBuilder sb) {
            sb.append(TypeEncoder.encode(c2.asType())).append('.').append(c2.getSimpleName());
            return null;
        }

        @Override
        public Void visitString(String s2, StringBuilder sb) {
            AnnotationOutput.appendQuoted(sb, s2);
            return null;
        }

        @Override
        public Void visitType(TypeMirror classConstant, StringBuilder sb) {
            sb.append(TypeEncoder.encode(classConstant)).append(".class");
            return null;
        }
    }
}

