/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.extension.toprettystring.processor;

import autovalue.shaded.com.google;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.base.$Equivalence;
import autovalue.shaded.com.google$.common.collect.$ImmutableCollection;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import autovalue.shaded.com.google$.common.collect.$Sets;
import autovalue.shaded.com.squareup.javapoet$.$ClassName;
import autovalue.shaded.com.squareup.javapoet$.$CodeBlock;
import autovalue.shaded.com.squareup.javapoet$.$JavaFile;
import autovalue.shaded.com.squareup.javapoet$.$MethodSpec;
import autovalue.shaded.com.squareup.javapoet$.$TypeName;
import autovalue.shaded.com.squareup.javapoet$.$TypeSpec;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.auto.value.extension.toprettystring.processor.ExtensionClassTypeSpecBuilder;
import com.google.auto.value.extension.toprettystring.processor.ToPrettyStringCollectors;
import com.google.auto.value.extension.toprettystring.processor.ToPrettyStringMethods;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

@google..AutoService(value={AutoValueExtension.class})
public final class ToPrettyStringExtension
extends AutoValueExtension {
    private static final $ImmutableSet<Modifier> INHERITED_VISIBILITY_MODIFIERS = $ImmutableSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
    private static final String INDENT = "  ";
    private static final String INDENT_METHOD_NAME = "$indent";
    private static final $CodeBlock KEY_VALUE_SEPARATOR = $CodeBlock.of("$S", ": ");

    @Override
    public String generateClass(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
        $TypeSpec type = ExtensionClassTypeSpecBuilder.extensionClassTypeSpecBuilder(context, className, classToExtend, isFinal).addMethods(this.toPrettyStringMethodSpecs(context)).build();
        return $JavaFile.builder(context.packageName(), type).skipJavaLangImports(true).build().toString();
    }

    private $ImmutableList<$MethodSpec> toPrettyStringMethodSpecs(AutoValueExtension.Context context) {
        ExecutableElement toPrettyStringMethod = $Iterables.getOnlyElement(ToPrettyStringMethods.toPrettyStringMethods(context));
        $MethodSpec.Builder method = $MethodSpec.methodBuilder(toPrettyStringMethod.getSimpleName().toString()).addAnnotation(Override.class).returns($ClassName.get(String.class)).addModifiers(Modifier.FINAL).addModifiers($Sets.intersection(toPrettyStringMethod.getModifiers(), INHERITED_VISIBILITY_MODIFIERS));
        method.addCode("return $S", context.autoValueClass().getSimpleName() + " {");
        ToPrettyStringImplementation implementation = ToPrettyStringImplementation.create(context);
        method.addCode(implementation.toStringCodeBlock.build());
        if (!context.properties().isEmpty()) {
            method.addCode(" + $S", "\n");
        }
        method.addCode(" + $S;\n", "}");
        return (($ImmutableList.Builder)(($ImmutableList.Builder)(($ImmutableList.Builder)$ImmutableList.builder().add(method.build())).addAll((Iterable)implementation.delegateMethods.values())).add(ToPrettyStringExtension.indentMethod())).build();
    }

    private static $MethodSpec indentMethod() {
        return $MethodSpec.methodBuilder(INDENT_METHOD_NAME).addModifiers(Modifier.PRIVATE, Modifier.STATIC).returns($ClassName.get(String.class)).addParameter($TypeName.INT, "level", new Modifier[0]).addStatement("$1T builder = new $1T()", StringBuilder.class).beginControlFlow("for (int i = 0; i < level; i++)", new Object[0]).addStatement("builder.append($S)", INDENT).endControlFlow().addStatement("return builder.toString()", new Object[0]).build();
    }

    @Override
    public boolean applicable(AutoValueExtension.Context context) {
        return ToPrettyStringMethods.toPrettyStringMethods(context).size() == 1;
    }

    public $ImmutableSet<ExecutableElement> consumeMethods(AutoValueExtension.Context context) {
        return ToPrettyStringMethods.toPrettyStringMethods(context);
    }

    @Override
    public AutoValueExtension.IncrementalExtensionType incrementalType(ProcessingEnvironment processingEnvironment) {
        return AutoValueExtension.IncrementalExtensionType.ISOLATING;
    }

    static enum PrettyPrintableKind {
        HAS_TO_PRETTY_STRING_METHOD,
        REGULAR_OBJECT,
        PRIMITIVE,
        COLLECTION,
        ARRAY,
        IMMUTABLE_PRIMITIVE_ARRAY,
        OPTIONAL,
        GUAVA_OPTIONAL,
        MAP,
        MULTIMAP;

        private static final $ImmutableMap<String, PrettyPrintableKind> KINDS_BY_EXACT_TYPE;
        private static final $ImmutableMap<String, PrettyPrintableKind> KINDS_BY_SUPERTYPE;

        static {
            KINDS_BY_EXACT_TYPE = $ImmutableMap.of("java.util.Optional", OPTIONAL, "autovalue.shaded.com.google$.common.base.$Optional", GUAVA_OPTIONAL, "autovalue.shaded.com.google$.common.primitives.$ImmutableIntArray", IMMUTABLE_PRIMITIVE_ARRAY, "autovalue.shaded.com.google$.common.primitives.$ImmutableLongArray", IMMUTABLE_PRIMITIVE_ARRAY, "autovalue.shaded.com.google$.common.primitives.$ImmutableDoubleArray", IMMUTABLE_PRIMITIVE_ARRAY);
            KINDS_BY_SUPERTYPE = $ImmutableMap.of("java.util.Collection", COLLECTION, "java.util.Map", MAP, "autovalue.shaded.com.google$.common.collect.$Multimap", MULTIMAP);
        }

        static class KindVisitor
        extends SimpleTypeVisitor8<PrettyPrintableKind, Void> {
            private final Elements elements;
            private final Types types;

            KindVisitor(Types types, Elements elements) {
                this.types = types;
                this.elements = elements;
            }

            @Override
            public PrettyPrintableKind visitPrimitive(PrimitiveType primitiveType, Void v2) {
                return PRIMITIVE;
            }

            @Override
            public PrettyPrintableKind visitArray(ArrayType arrayType, Void v2) {
                return ARRAY;
            }

            @Override
            public PrettyPrintableKind visitDeclared(DeclaredType declaredType, Void v2) {
                TypeElement typeElement = $MoreTypes.asTypeElement(declaredType);
                if (ToPrettyStringMethods.toPrettyStringMethod(typeElement, this.types, this.elements).isPresent()) {
                    return HAS_TO_PRETTY_STRING_METHOD;
                }
                PrettyPrintableKind byExactType = (PrettyPrintableKind)((Object)KINDS_BY_EXACT_TYPE.get(typeElement.getQualifiedName().toString()));
                if (byExactType != null) {
                    return byExactType;
                }
                for (Map.Entry entry : KINDS_BY_SUPERTYPE.entrySet()) {
                    TypeElement supertypeElement = this.elements.getTypeElement((CharSequence)entry.getKey());
                    if (supertypeElement == null || !this.types.isAssignable(declaredType, this.types.erasure(supertypeElement.asType()))) continue;
                    return (PrettyPrintableKind)((Object)entry.getValue());
                }
                return REGULAR_OBJECT;
            }
        }
    }

    private static class ToPrettyStringImplementation {
        private final Types types;
        private final Elements elements;
        private final $CodeBlock.Builder toStringCodeBlock = $CodeBlock.builder();
        private final Map<$Equivalence.Wrapper<TypeMirror>, $MethodSpec> delegateMethods = new LinkedHashMap<$Equivalence.Wrapper<TypeMirror>, $MethodSpec>();
        private final Set<String> methodNames = new HashSet<String>();

        private ToPrettyStringImplementation(AutoValueExtension.Context context) {
            this.types = context.processingEnvironment().getTypeUtils();
            this.elements = context.processingEnvironment().getElementUtils();
            $MoreElements.getLocalAndInheritedMethods(context.autoValueClass(), this.types, this.elements).forEach(method -> this.methodNames.add(method.getSimpleName().toString()));
        }

        static ToPrettyStringImplementation create(AutoValueExtension.Context context) {
            ToPrettyStringImplementation implemention = new ToPrettyStringImplementation(context);
            context.propertyTypes().forEach((propertyName, type) -> {
                String methodName = context.properties().get(propertyName).getSimpleName().toString();
                implemention.toStringCodeBlock.add("\n + $S + $L + $S", String.format("\n%s%s = ", ToPrettyStringExtension.INDENT, propertyName), implemention.format($CodeBlock.of("$N()", methodName), $CodeBlock.of("1", new Object[0]), (TypeMirror)type), ",");
            });
            return implemention;
        }

        private $CodeBlock format($CodeBlock propertyAccess, $CodeBlock indentAccess, TypeMirror type) {
            PrettyPrintableKind printableKind = type.accept(new PrettyPrintableKind.KindVisitor(this.types, this.elements), null);
            DelegateMethod delegateMethod = new DelegateMethod(propertyAccess, indentAccess);
            switch (printableKind) {
                case PRIMITIVE: {
                    return propertyAccess;
                }
                case REGULAR_OBJECT: {
                    return delegateMethod.methodName("format").invocation(this.elements.getTypeElement("java.lang.Object").asType(), () -> this.reindent("toString"));
                }
                case HAS_TO_PRETTY_STRING_METHOD: {
                    ExecutableElement method = ToPrettyStringMethods.toPrettyStringMethod($MoreTypes.asTypeElement(type), this.types, this.elements).get();
                    return delegateMethod.invocation(type, () -> this.reindent(method.getSimpleName()));
                }
                case ARRAY: {
                    TypeMirror componentType = $MoreTypes.asArray(type).getComponentType();
                    return delegateMethod.invocation(type, () -> this.forEachLoopMethodBody(componentType));
                }
                case COLLECTION: {
                    TypeMirror elementType = $Iterables.getOnlyElement(this.resolvedTypeParameters(type, "java.util.Collection"));
                    return delegateMethod.invocation(this.collectionOf(elementType), () -> this.forEachLoopMethodBody(elementType));
                }
                case IMMUTABLE_PRIMITIVE_ARRAY: {
                    return delegateMethod.invocation(type, this::forLoopMethodBody);
                }
                case OPTIONAL: 
                case GUAVA_OPTIONAL: {
                    TypeMirror optionalType = $Iterables.getOnlyElement($MoreTypes.asDeclared(type).getTypeArguments());
                    return delegateMethod.invocation(type, () -> this.optionalMethodBody(optionalType, printableKind));
                }
                case MAP: {
                    return this.formatMap(type, delegateMethod);
                }
                case MULTIMAP: {
                    return this.formatMultimap(type, delegateMethod);
                }
            }
            throw new AssertionError((Object)printableKind);
        }

        private $CodeBlock formatMap(TypeMirror type, DelegateMethod delegateMethod) {
            $ImmutableList<TypeMirror> typeParameters = this.resolvedTypeParameters(type, "java.util.Map");
            TypeMirror keyType = (TypeMirror)typeParameters.get(0);
            TypeMirror valueType = (TypeMirror)typeParameters.get(1);
            return delegateMethod.invocation(this.mapOf(keyType, valueType), () -> this.mapMethodBody(keyType, valueType));
        }

        private $CodeBlock formatMultimap(TypeMirror type, DelegateMethod delegateMethod) {
            $ImmutableList<TypeMirror> typeParameters = this.resolvedTypeParameters(type, "autovalue.shaded.com.google$.common.collect.$Multimap");
            TypeMirror keyType = (TypeMirror)typeParameters.get(0);
            TypeMirror valueType = (TypeMirror)typeParameters.get(1);
            return delegateMethod.invocation(this.multimapOf(keyType, valueType), () -> this.multimapMethodBody(keyType, this.collectionOf(valueType)));
        }

        private $CodeBlock reindent(CharSequence methodName) {
            return $CodeBlock.builder().addStatement("return value.$1N().replace($2S, $2S + $3N(indentLevel))", methodName, "\n", ToPrettyStringExtension.INDENT_METHOD_NAME).build();
        }

        private $CodeBlock forEachLoopMethodBody(TypeMirror elementType) {
            return this.loopMethodBody("[", "]", $CodeBlock.of("for ($T element : value)", elementType), this.format($CodeBlock.of("element", new Object[0]), $CodeBlock.of("indentLevel + 1", new Object[0]), elementType));
        }

        private $CodeBlock forLoopMethodBody() {
            return this.loopMethodBody("[", "]", $CodeBlock.of("for (int i = 0; i < value.length(); i++)", new Object[0]), $CodeBlock.of("value.get(i)", new Object[0]));
        }

        private $CodeBlock mapMethodBody(TypeMirror keyType, TypeMirror valueType) {
            return this.forEachMapEntryMethodBody(keyType, valueType, "value");
        }

        private $CodeBlock multimapMethodBody(TypeMirror keyType, TypeMirror valueType) {
            return this.forEachMapEntryMethodBody(keyType, valueType, "value.asMap()");
        }

        private $CodeBlock forEachMapEntryMethodBody(TypeMirror keyType, TypeMirror valueType, String propertyAccess) {
            $CodeBlock entryType = $CodeBlock.of("$T<$T, $T>", Map.Entry.class, keyType, valueType);
            return this.loopMethodBody("{", "}", $CodeBlock.of("for ($L entry : $L.entrySet())", entryType, propertyAccess), this.format($CodeBlock.of("entry.getKey()", new Object[0]), $CodeBlock.of("indentLevel + 1", new Object[0]), keyType), KEY_VALUE_SEPARATOR, this.format($CodeBlock.of("entry.getValue()", new Object[0]), $CodeBlock.of("indentLevel + 1", new Object[0]), valueType));
        }

        private $CodeBlock loopMethodBody(String openSymbol, String closeSymbol, $CodeBlock loopDeclaration, $CodeBlock ... appendedValues) {
            $ImmutableCollection allAppendedValues = (($ImmutableList.Builder)(($ImmutableList.Builder)(($ImmutableList.Builder)(($ImmutableList.Builder)$ImmutableList.builder().add($CodeBlock.of("$S", "\n"))).add($CodeBlock.of("$N(indentLevel + 1)", ToPrettyStringExtension.INDENT_METHOD_NAME))).add(appendedValues)).add($CodeBlock.of("$S", ","))).build();
            return $CodeBlock.builder().addStatement("$1T builder = new $1T().append($2S)", StringBuilder.class, openSymbol).addStatement("boolean hasElements = false", new Object[0]).beginControlFlow("$L", loopDeclaration).addStatement("builder$L", allAppendedValues.stream().map(value -> $CodeBlock.of(".append($L)", value)).collect($CodeBlock.joining(""))).addStatement("hasElements = true", new Object[0]).endControlFlow().beginControlFlow("if (hasElements)", new Object[0]).addStatement("builder.append($S).append($N(indentLevel))", "\n", ToPrettyStringExtension.INDENT_METHOD_NAME).endControlFlow().addStatement("return builder.append($S).toString()", closeSymbol).build();
        }

        private $CodeBlock optionalMethodBody(TypeMirror optionalType, PrettyPrintableKind printableKind) {
            return $CodeBlock.builder().addStatement("return (value.isPresent() ? $L : $S)", this.format($CodeBlock.of("value.get()", new Object[0]), $CodeBlock.of("indentLevel", new Object[0]), optionalType), printableKind.equals((Object)PrettyPrintableKind.OPTIONAL) ? "<empty>" : "<absent>").build();
        }

        private $ImmutableList<TypeMirror> resolvedTypeParameters(TypeMirror propertyType, String interfaceName) {
            return this.elements.getTypeElement(interfaceName).getTypeParameters().stream().map(p2 -> this.types.asMemberOf($MoreTypes.asDeclared(propertyType), (Element)p2)).collect(ToPrettyStringCollectors.toImmutableList());
        }

        private DeclaredType collectionOf(TypeMirror elementType) {
            return this.types.getDeclaredType(this.elements.getTypeElement("java.util.Collection"), elementType);
        }

        private DeclaredType mapOf(TypeMirror keyType, TypeMirror valueType) {
            return this.types.getDeclaredType(this.elements.getTypeElement("java.util.Map"), keyType, valueType);
        }

        private DeclaredType multimapOf(TypeMirror keyType, TypeMirror valueType) {
            return this.types.getDeclaredType(this.elements.getTypeElement("autovalue.shaded.com.google$.common.collect.$Multimap"), keyType, valueType);
        }

        private String nameForType(TypeMirror type) {
            return type.accept(new SimpleTypeVisitor8<String, Void>(){

                @Override
                public String visitDeclared(DeclaredType type, Void v2) {
                    String simpleName = this.simpleNameForType(type);
                    if (type.getTypeArguments().isEmpty()) {
                        return simpleName;
                    }
                    $ImmutableList typeArgumentNames = type.getTypeArguments().stream().map(t2 -> this.simpleNameForType(t2)).collect(ToPrettyStringCollectors.toImmutableList());
                    if (this.isMapOrMultimap(type) && typeArgumentNames.size() == 2) {
                        return String.format("%sOf%sTo%s", simpleName, typeArgumentNames.get(0), typeArgumentNames.get(1));
                    }
                    ArrayList<String> parts = new ArrayList<String>();
                    parts.add(simpleName);
                    parts.add("Of");
                    parts.addAll(typeArgumentNames.subList(0, typeArgumentNames.size() - 1));
                    if (typeArgumentNames.size() > 1) {
                        parts.add("And");
                    }
                    parts.add((String)$Iterables.getLast(typeArgumentNames));
                    return String.join((CharSequence)"", parts);
                }

                @Override
                protected String defaultAction(TypeMirror type, Void v2) {
                    return this.simpleNameForType(type);
                }
            }, null);
        }

        boolean isMapOrMultimap(TypeMirror type) {
            TypeMirror mapType = this.elements.getTypeElement("java.util.Map").asType();
            if (this.types.isAssignable(type, this.types.erasure(mapType))) {
                return true;
            }
            TypeElement multimapElement = this.elements.getTypeElement("autovalue.shaded.com.google$.common.collect.$Multimap");
            return multimapElement != null && this.types.isAssignable(type, this.types.erasure(multimapElement.asType()));
        }

        private String simpleNameForType(TypeMirror type) {
            return type.accept(new SimpleTypeVisitor8<String, Void>(){

                @Override
                public String visitPrimitive(PrimitiveType primitiveType, Void v2) {
                    return types.boxedClass(primitiveType).getSimpleName().toString();
                }

                @Override
                public String visitArray(ArrayType arrayType, Void v2) {
                    return arrayType.getComponentType().accept(this, null) + "Array";
                }

                @Override
                public String visitDeclared(DeclaredType declaredType, Void v2) {
                    return declaredType.asElement().getSimpleName().toString();
                }

                @Override
                protected String defaultAction(TypeMirror typeMirror, Void v2) {
                    throw new AssertionError(typeMirror);
                }
            }, null);
        }

        private class DelegateMethod {
            private final $CodeBlock propertyAccess;
            private final $CodeBlock indentAccess;
            private Optional<String> methodName = Optional.empty();

            DelegateMethod($CodeBlock propertyAccess, $CodeBlock indentAccess) {
                this.propertyAccess = propertyAccess;
                this.indentAccess = indentAccess;
            }

            DelegateMethod methodName(String methodName) {
                this.methodName = Optional.of(methodName);
                return this;
            }

            $CodeBlock invocation(TypeMirror parameterType, Supplier<$CodeBlock> methodBody) {
                $Equivalence.Wrapper<TypeMirror> key = $MoreTypes.equivalence().wrap(parameterType);
                if (!ToPrettyStringImplementation.this.delegateMethods.containsKey(key)) {
                    ToPrettyStringImplementation.this.delegateMethods.put(key, this.createMethod(this.methodName.orElseGet(() -> this.newDelegateMethodName(parameterType)), parameterType, methodBody));
                }
                return $CodeBlock.of("$N($L, $L)", (($MethodSpec)((ToPrettyStringImplementation)ToPrettyStringImplementation.this).delegateMethods.get(key)).name, this.propertyAccess, this.indentAccess);
            }

            private String newDelegateMethodName(TypeMirror type) {
                String prefix;
                String methodName = prefix = "format" + ToPrettyStringImplementation.this.nameForType(type);
                int i2 = 2;
                while (!ToPrettyStringImplementation.this.methodNames.add(methodName)) {
                    methodName = prefix + i2;
                    ++i2;
                }
                return methodName;
            }

            private $MethodSpec createMethod(String methodName, TypeMirror type, Supplier<$CodeBlock> methodBody) {
                return $MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PRIVATE, Modifier.STATIC).returns($ClassName.get(String.class)).addParameter($TypeName.get(type), "value", new Modifier[0]).addParameter($TypeName.INT, "indentLevel", new Modifier[0]).beginControlFlow("if (value == null)", new Object[0]).addStatement("return $S", "null").endControlFlow().addCode(methodBody.get()).build();
            }
        }
    }
}

