/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BBHeader;
import com.github.benmanes.caffeine.cache.Buffer;
import com.github.benmanes.caffeine.cache.StripedBuffer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.Consumer;

final class BoundedBuffer<E>
extends StripedBuffer<E> {
    static final int BUFFER_SIZE = 16;
    static final int MASK = 15;

    BoundedBuffer() {
    }

    @Override
    protected Buffer<E> create(E e2) {
        return new RingBuffer<E>(e2);
    }

    static final class RingBuffer<E>
    extends BBHeader.ReadAndWriteCounterRef
    implements Buffer<E> {
        static final VarHandle BUFFER = MethodHandles.arrayElementVarHandle(Object[].class);
        final Object[] buffer = new Object[16];

        public RingBuffer(E e2) {
            BUFFER.set(this.buffer, 0, e2);
        }

        @Override
        public int offer(E e2) {
            long head = this.readCounter;
            long tail = this.relaxedWriteCounter();
            long size = tail - head;
            if (size >= 16L) {
                return 1;
            }
            if (this.casWriteCounter(tail, tail + 1L)) {
                int index = (int)(tail & 0xFL);
                BUFFER.setRelease(this.buffer, index, e2);
                return 0;
            }
            return -1;
        }

        @Override
        public void drainTo(Consumer<E> consumer) {
            int index;
            Object e2;
            long head = this.readCounter;
            long tail = this.relaxedWriteCounter();
            long size = tail - head;
            if (size == 0L) {
                return;
            }
            while ((e2 = BUFFER.getVolatile(this.buffer, index = (int)(head & 0xFL))) != null) {
                BUFFER.setRelease(this.buffer, index, null);
                consumer.accept(e2);
                if (++head != tail) continue;
            }
            this.lazySetReadCounter(head);
        }

        @Override
        public int reads() {
            return (int)this.readCounter;
        }

        @Override
        public int writes() {
            return (int)this.writeCounter;
        }
    }
}

