/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.util;

import com.floreysoft.jmte.util.MiniParser;
import com.floreysoft.jmte.util.StartEndPair;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Util {
    public static final MiniParser MINI_PARSER = MiniParser.defaultInstance();
    public static final MiniParser RAW_MINI_PARSER = MiniParser.fullRawInstance();
    public static final MiniParser NO_QUOTE_MINI_PARSER = new MiniParser('\\', '\uffff', false, false, false);
    public static final MiniParser RAW_OUTPUT_MINI_PARSER = MiniParser.rawOutputInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stringToFile(String string, File file, String charsetName) {
        FileOutputStream fos = null;
        Writer writer = null;
        try {
            try {
                fos = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)fos, charsetName);
                writer.write(string);
            }
            finally {
                if (writer != null) {
                    writer.close();
                } else if (fos != null) {
                    fos.close();
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToString(File file, String charsetName) {
        String string;
        block6: {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                string = Util.streamToString(fileInputStream, charsetName);
                if (fileInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            fileInputStream.close();
        }
        return string;
    }

    public static String fileToString(String fileName, String charsetName) {
        return Util.fileToString(new File(fileName), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream is2, String charsetName) {
        String string;
        block10: {
            Reader r2 = null;
            try {
                r2 = new BufferedReader(new InputStreamReader(is2, charsetName));
                string = Util.readerToString(r2);
                if (r2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (r2 != null) {
                        try {
                            r2.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            try {
                r2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String resourceToString(String resourceName, String charsetName) {
        InputStream templateStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        String template = Util.streamToString(templateStream, "UTF-8");
        return template;
    }

    public static String readerToString(Reader reader) {
        try {
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                sb.append(buf, 0, numRead);
            }
            return sb.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static byte[] streamToBa(InputStream is2) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int numRead = 0;
            while ((numRead = is2.read(buf)) != -1) {
                baos.write(buf, 0, numRead);
            }
            byte[] byteArray = baos.toByteArray();
            return byteArray;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static List<Object> arrayAsList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        List<Object> list = null;
        if (value instanceof int[]) {
            int[] array;
            list = new ArrayList<Object>();
            for (int i2 : array = (int[])value) {
                list.add(i2);
            }
        } else if (value instanceof short[]) {
            short[] array;
            list = new ArrayList();
            for (short i3 : array = (short[])value) {
                list.add(i3);
            }
        } else if (value instanceof char[]) {
            char[] array;
            list = new ArrayList();
            for (char i4 : array = (char[])value) {
                list.add(Character.valueOf(i4));
            }
        } else if (value instanceof byte[]) {
            byte[] array;
            list = new ArrayList();
            for (byte i5 : array = (byte[])value) {
                list.add(i5);
            }
        } else if (value instanceof long[]) {
            long[] array;
            list = new ArrayList();
            for (long i6 : array = (long[])value) {
                list.add(i6);
            }
        } else if (value instanceof double[]) {
            double[] array;
            list = new ArrayList();
            for (double i7 : array = (double[])value) {
                list.add(i7);
            }
        } else if (value instanceof float[]) {
            float[] array;
            list = new ArrayList();
            for (float i8 : array = (float[])value) {
                list.add(Float.valueOf(i8));
            }
        } else if (value instanceof boolean[]) {
            boolean[] array;
            list = new ArrayList();
            for (boolean i9 : array = (boolean[])value) {
                list.add(i9);
            }
        } else if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            list = Arrays.asList(array);
        }
        return list;
    }

    public static String extractArrayIndex(String objectName) {
        return objectName.substring(objectName.indexOf("[") + 1, objectName.indexOf("]"));
    }

    public static String extractArrayName(String objectName) {
        return objectName.substring(0, objectName.indexOf("["));
    }

    public static boolean isArrayAccess(String objectName) {
        return objectName.contains("[") || objectName.contains("]");
    }

    public static boolean isValidArrayAccess(String objectName) {
        int arrayOpenIndex = objectName.indexOf("[");
        int arrayCloseIndex = objectName.indexOf("]");
        return arrayOpenIndex != -1 && arrayCloseIndex != -1 && arrayOpenIndex < arrayCloseIndex;
    }

    public static String trimFront(String input) {
        int i2;
        for (i2 = 0; i2 < input.length() && Character.isWhitespace(input.charAt(i2)); ++i2) {
        }
        return input.substring(i2);
    }

    public static List<StartEndPair> scan(String input, String splitStart, String splitEnd, boolean useEscaping) {
        int exprStart;
        ArrayList<StartEndPair> result = new ArrayList<StartEndPair>();
        int fromIndex = 0;
        while ((exprStart = input.indexOf(splitStart, fromIndex)) != -1) {
            if (useEscaping && Util.isEscaped(input, exprStart)) {
                fromIndex = exprStart + splitStart.length();
                continue;
            }
            int exprEnd = input.indexOf(splitEnd, exprStart += splitStart.length());
            if (exprEnd == -1) break;
            while (useEscaping && Util.isEscaped(input, exprEnd)) {
                exprEnd = input.indexOf(splitEnd, exprEnd + splitEnd.length());
            }
            fromIndex = exprEnd + splitEnd.length();
            StartEndPair startEndPair = new StartEndPair(exprStart, exprEnd);
            result.add(startEndPair);
        }
        return result;
    }

    static boolean isEscaped(String input, int index) {
        return Util.isEscaped(input, index, '\\');
    }

    static boolean isEscaped(String input, int index, char escapeCharacter) {
        int leftOfleftOfIndex;
        int leftOfIndex = index - 1;
        boolean escaped = leftOfIndex >= 0 ? (input.charAt(leftOfIndex) == escapeCharacter ? (leftOfleftOfIndex = leftOfIndex - 1) < 0 || input.charAt(leftOfleftOfIndex) != escapeCharacter : false) : false;
        return escaped;
    }

    public static <T> Set<T> asSet(T ... a2) {
        return a2 != null ? new HashSet<T>(Arrays.asList(a2)) : Collections.emptySet();
    }

    public static String unifyNewlines(String source2) {
        String regex = "\\r?\\n";
        String clearedSource = source2.replaceAll("\\r?\\n", "\n");
        return clearedSource;
    }
}

