/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.token;

import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.token.AbstractToken;
import com.floreysoft.jmte.util.Util;
import java.util.List;

public abstract class ExpressionToken
extends AbstractToken {
    private List<String> segments;
    private String expression;

    public static final String segmentsToString(List<String> segments, int start, int end) {
        if (start >= segments.size() || end > segments.size()) {
            String errorMessage = String.format("Range %d -> %d is not inside segments: %d", start, end, segments.size());
            throw new IllegalArgumentException(errorMessage);
        }
        StringBuilder builder = new StringBuilder();
        for (int i2 = start; i2 < end; ++i2) {
            String segment = segments.get(i2);
            builder.append(segment);
            if (i2 >= end - 1) continue;
            builder.append(".");
        }
        return builder.toString();
    }

    public ExpressionToken(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Parameter expression must not be null");
        }
        this.setExpression(expression);
    }

    protected ExpressionToken(List<String> segments, String expression) {
        this.segments = segments;
        this.expression = expression;
    }

    public boolean isComposed() {
        return this.getSegments().size() > 1;
    }

    public boolean isEmpty() {
        return this.getSegments().size() == 0;
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public String getFirstSegment() {
        if (this.isEmpty()) {
            throw new IllegalStateException("There is no first segment");
        }
        return this.getSegments().get(0);
    }

    public String getLastSegment() {
        if (this.isEmpty()) {
            throw new IllegalStateException("There is no last segment");
        }
        return this.getSegments().get(this.getSegments().size() - 1);
    }

    public String getAllButLastSegment() {
        if (this.isEmpty()) {
            throw new IllegalStateException("There are no segments");
        }
        return ExpressionToken.segmentsToString(this.segments, 0, this.getSegments().size() - 1);
    }

    public String getAllButFirstSegment() {
        if (this.isEmpty()) {
            throw new IllegalStateException("There are no segments");
        }
        return ExpressionToken.segmentsToString(this.segments, 1, this.getSegments().size());
    }

    public void setExpression(String expression) {
        this.text = null;
        this.segments = Util.MINI_PARSER.split(expression, '.');
        this.expression = Util.MINI_PARSER.unescape(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setSegments(List<String> segments) {
        this.segments = segments;
        this.expression = ExpressionToken.segmentsToString(segments, 0, segments.size());
        this.text = null;
    }

    @Override
    public abstract Object evaluate(TemplateContext var1);

    protected Object evaluatePlain(TemplateContext context) {
        Object value = context.modelAdaptor.getValue(context, this, this.getSegments(), this.getExpression());
        return value;
    }
}

