/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.renderer;

import com.floreysoft.jmte.DefaultModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractParameterRenderer<T>
implements NamedRenderer {
    private static final Logger logger = Logger.getLogger(AbstractParameterRenderer.class.getName());

    @Override
    public String render(Object o2, String pattern, Locale locale, Map<String, Object> model) {
        Map<String, String> parameters = this.parsePattern(pattern, model);
        T value = this.parse(o2);
        String formattedValue = null;
        if (value != null) {
            formattedValue = this.format(value, locale, parameters, model);
        }
        return formattedValue;
    }

    protected abstract T parse(Object var1);

    protected abstract String format(T var1, Locale var2, Map<String, String> var3, Map<String, Object> var4);

    protected Map<String, String> parsePattern(String pattern, Map<String, Object> model) {
        logger.log(Level.FINE, "Extracting parameters from pattern=" + pattern);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (pattern != null) {
            String[] tokens;
            for (String token : tokens = pattern.split(";")) {
                String key;
                int index = token.indexOf(61);
                String value = null;
                if (index > 0) {
                    key = token.substring(0, index);
                    value = token.substring(index + 1);
                } else {
                    key = token;
                }
                logger.log(Level.FINE, "Extracted parameter with key=" + key + ", value=" + value);
                if (value != null && value.startsWith("$")) {
                    String expression = value.substring(1);
                    logger.log(Level.FINE, "Resolving pattern value with path=" + expression);
                    DefaultModelAdaptor modelAdaptor = new DefaultModelAdaptor();
                    value = (String)modelAdaptor.getValue(model, expression);
                }
                parameters.put(key, value);
            }
        }
        return parameters;
    }
}

