/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.message;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.message.InternalErrorHandler;
import com.floreysoft.jmte.message.Message;
import com.floreysoft.jmte.token.Token;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ResourceBundleMessage
implements Message {
    private final String messageCode;
    private String locationCode = "location";
    private String prefixCode = "prefix";
    private String frameCode = "frame";
    private Map<String, Object> argumentModel = new HashMap<String, Object>();
    private String baseName = "com.floreysoft.jmte.message.messages";

    protected static String getTemplate(ResourceBundle bundle, String key, String fallback) {
        return key != null && bundle.containsKey(key) ? bundle.getString(key) : fallback;
    }

    public ResourceBundleMessage(String messageCode) {
        this.messageCode = messageCode;
    }

    public ResourceBundleMessage useLocationCode(String locationCode) {
        this.locationCode = locationCode;
        return this;
    }

    public ResourceBundleMessage onToken(Token token) {
        this.argumentModel.put("token", token);
        return this;
    }

    public ResourceBundleMessage usePrefixCode(String prefixCode) {
        this.prefixCode = prefixCode;
        return this;
    }

    public ResourceBundleMessage useFrameCode(String frameCode) {
        this.frameCode = frameCode;
        return this;
    }

    public ResourceBundleMessage withModel(Map<String, Object> model) {
        if (model != null) {
            this.argumentModel.putAll(model);
        }
        return this;
    }

    public ResourceBundleMessage withBaseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public String getLocationCode() {
        return this.locationCode;
    }

    public String getPrefixCode() {
        return this.prefixCode;
    }

    public String getFrameCode() {
        return this.frameCode;
    }

    public Map<String, Object> getArgumentModel() {
        return this.argumentModel;
    }

    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public String format() {
        return this.format(new Locale("en"));
    }

    @Override
    public String format(Locale locale) {
        ResourceBundle messages = ResourceBundle.getBundle(this.baseName, locale);
        String frameTemplate = ResourceBundleMessage.getTemplate(messages, this.frameCode, "${prefix} ${location}: ${message}");
        String prefixTemplate = ResourceBundleMessage.getTemplate(messages, this.prefixCode, "");
        String locationTemplate = ResourceBundleMessage.getTemplate(messages, this.locationCode, "");
        String messageTemplate = ResourceBundleMessage.getTemplate(messages, this.messageCode, "");
        Engine engine = new Engine();
        engine.setErrorHandler(new InternalErrorHandler());
        this.argumentModel.put("prefix", engine.transform(prefixTemplate, this.argumentModel));
        this.argumentModel.put("location", engine.transform(locationTemplate, this.argumentModel));
        this.argumentModel.put("message", engine.transform(messageTemplate, this.argumentModel));
        String transformed = engine.transform(frameTemplate, this.argumentModel);
        return transformed;
    }

    @Override
    public String formatPlain() {
        return this.formatPlain(new Locale("en"));
    }

    @Override
    public String formatPlain(Locale locale) {
        ResourceBundle messages = ResourceBundle.getBundle(this.baseName, locale);
        String messageTemplate = ResourceBundleMessage.getTemplate(messages, this.messageCode, "");
        Engine engine = new Engine();
        engine.setErrorHandler(new InternalErrorHandler());
        String transformed = engine.transform(messageTemplate, this.argumentModel);
        return transformed;
    }
}

