/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class DateTimeDeserializer
extends JodaDateDeserializerBase<ReadableInstant> {
    private static final long serialVersionUID = 1L;

    public DateTimeDeserializer(Class<?> cls, JacksonJodaDateFormat format) {
        super(cls, format);
    }

    public static <T extends ReadableInstant> JsonDeserializer<T> forType(Class<T> cls) {
        return new DateTimeDeserializer(cls, FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new DateTimeDeserializer(this._valueClass, format);
    }

    @Override
    public ReadableInstant deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p2.getLongValue());
            }
            case 6: {
                return this._fromString(p2, ctxt, p2.getText());
            }
            case 1: {
                return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, this, this.handledType()));
            }
        }
        return (ReadableInstant)this._handleNotNumberOrString(p2, ctxt);
    }

    protected ReadableInstant _fromString(JsonParser p2, DeserializationContext ctxt, String value) throws IOException {
        if ((value = value.trim()).isEmpty()) {
            return (ReadableInstant)this._fromEmptyString(p2, ctxt, value);
        }
        int ix2 = value.indexOf(91);
        if (ix2 > 0) {
            DateTimeZone tz;
            int ix22 = value.lastIndexOf(93);
            String tzId = ix22 < ix2 ? value.substring(ix2 + 1) : value.substring(ix2 + 1, ix22);
            try {
                tz = DateTimeZone.forID(tzId);
            }
            catch (IllegalArgumentException e2) {
                ctxt.reportInputMismatch(this.handledType(), "Unknown DateTimeZone id '%s'", tzId);
                tz = null;
            }
            value = value.substring(0, ix2);
            DateTime result = this._format.createParser(ctxt).withZone(tz).parseDateTime(value);
            if (this._format.shouldAdjustToContextTimeZone(ctxt)) {
                result = result.withZone(this._format.getTimeZone());
            }
            return result;
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value));
        }
        return this._format.createParser(ctxt).parseDateTime(value);
    }

    protected DateTime _fromTimestamp(DeserializationContext ctxt, long ts) {
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
        return new DateTime(ts, tz);
    }
}

