/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.RenameTriggerStatement;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class RenameTriggerGenerator
extends AbstractSqlGenerator<RenameTriggerStatement> {
    @Override
    public boolean supports(RenameTriggerStatement renameTriggerStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof PostgresDatabase;
    }

    @Override
    public ValidationErrors validate(RenameTriggerStatement renameTriggerStatement, Database database, SqlGeneratorChain object) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkRequiredField("oldTriggerName", renameTriggerStatement.getOldTriggerName());
        ((ValidationErrors)object).checkRequiredField("newTriggerName", renameTriggerStatement.getNewTriggerName());
        ((ValidationErrors)object).checkDisallowedField("catalogName", renameTriggerStatement.getCatalogName(), database, MSSQLDatabase.class);
        if (database instanceof PostgresDatabase) {
            ((ValidationErrors)object).checkRequiredField("tableName", renameTriggerStatement.getTableName());
        }
        return object;
    }

    @Override
    public Sql[] generateSql(RenameTriggerStatement sqlArray, Database database, SqlGeneratorChain object) {
        if (database instanceof OracleDatabase) {
            return new Sql[]{new UnparsedSql("ALTER TRIGGER " + database.escapeObjectName(sqlArray.getCatalogName(), sqlArray.getSchemaName(), sqlArray.getOldTriggerName(), Trigger.class) + " RENAME TO " + database.escapeObjectName(sqlArray.getNewTriggerName(), Trigger.class), new DatabaseObject[0])};
        }
        if (database instanceof PostgresDatabase) {
            return new Sql[]{new UnparsedSql("ALTER TRIGGER " + sqlArray.getOldTriggerName() + " ON " + database.escapeObjectName(null, sqlArray.getSchemaName(), sqlArray.getTableName(), Trigger.class) + " RENAME TO " + database.escapeObjectName(sqlArray.getNewTriggerName(), Trigger.class), new DatabaseObject[0])};
        }
        object = sqlArray.getSchemaName();
        sqlArray = object != null && !((String)object).isEmpty() ? new Sql[]{new UnparsedSql("sp_rename '" + database.escapeObjectName((String)object, Schema.class) + "." + sqlArray.getOldTriggerName() + "', '" + sqlArray.getNewTriggerName() + "'", new DatabaseObject[0])} : new Sql[]{new UnparsedSql("sp_rename '" + sqlArray.getOldTriggerName() + "', '" + sqlArray.getNewTriggerName() + "'", new DatabaseObject[0])};
        return new ArrayList<Sql>(Arrays.asList(sqlArray)).toArray(new Sql[0]);
    }
}

