/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.validation;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import com.cronutils.validation.Cron;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class CronValidator
implements ConstraintValidator<Cron, String> {
    private CronType type;

    @Override
    public void initialize(Cron constraintAnnotation) {
        this.type = constraintAnnotation.type();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor(this.type);
        CronParser cronParser = new CronParser(cronDefinition);
        try {
            cronParser.parse(value).validate();
            return true;
        }
        catch (IllegalArgumentException e2) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(e2.getMessage()).addConstraintViolation();
            return false;
        }
    }
}

