/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformSnapshot;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class UniformReservoir
implements Reservoir {
    private static final int DEFAULT_SIZE = 1028;
    private final AtomicLong count = new AtomicLong();
    private final AtomicLongArray values;

    public UniformReservoir() {
        this(1028);
    }

    public UniformReservoir(int size) {
        this.values = new AtomicLongArray(size);
        for (int i2 = 0; i2 < this.values.length(); ++i2) {
            this.values.set(i2, 0L);
        }
        this.count.set(0L);
    }

    @Override
    public int size() {
        long c2 = this.count.get();
        if (c2 > (long)this.values.length()) {
            return this.values.length();
        }
        return (int)c2;
    }

    @Override
    public void update(long value) {
        long c2 = this.count.incrementAndGet();
        if (c2 <= (long)this.values.length()) {
            this.values.set((int)c2 - 1, value);
        } else {
            long r2 = ThreadLocalRandom.current().nextLong(c2);
            if (r2 < (long)this.values.length()) {
                this.values.set((int)r2, value);
            }
        }
    }

    @Override
    public Snapshot getSnapshot() {
        int s2 = this.size();
        long[] copy = new long[s2];
        for (int i2 = 0; i2 < s2; ++i2) {
            copy[i2] = this.values.get(i2);
        }
        return new UniformSnapshot(copy);
    }
}

